/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.launching.LaunchUtil;
import org.eclipse.php.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.debug.ui.preferences.phps.PHPsComboBlock;
import org.eclipse.php.server.apache.ui.ApacheUIPlugin;
import org.eclipse.php.server.apache.ui.HTTPServerUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.util.WebResource;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    public static final String FIRST_EDIT = "editedByPHPExecutableLaunchTab";
    protected Text locationField;
    protected Button fileLocationButton;
    protected Button fileWorkingDirectoryButton;
    protected Button runWithDebugInfo;
    protected Text argumentField;
    protected Button argumentVariablesButton;
    protected SelectionAdapter selectionAdapter;
    protected PHPsComboBlock phpsComboBlock;
    protected boolean disableFileSelection = false;
    protected boolean disableDebugInfoOption = false;
    private ISelectionChangedListener fCheckListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    protected WidgetListener fListener = new WidgetListener();

    public PHPExecutableLaunchTab(String string) {
        if (!string.equals("run")) {
            this.setDisableDebugInfoOption();
        }
    }

    public void setDisableFileSelection() {
        this.disableFileSelection = true;
    }

    public void setDisableDebugInfoOption() {
        this.disableDebugInfoOption = true;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.createLocationComponent(composite2);
        if (!this.disableDebugInfoOption) {
            this.createDebugInfoComponent(composite2);
        }
        if (!this.disableFileSelection) {
            this.createArgumentComponent(composite2);
        }
        this.createVerticalSpacer(composite2, 1);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createLocationComponent(Composite composite) {
        this.phpsComboBlock = new PHPsComboBlock();
        this.phpsComboBlock.setSpecificPHPexeDescriptor(this.getSpecificPHPexeDescriptor());
        this.phpsComboBlock.createControl(composite);
        Control control = this.phpsComboBlock.getControl();
        this.phpsComboBlock.addSelectionChangedListener(this.fCheckListener);
        GridData gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
    }

    protected PHPexeDescriptor getDefaultPHPexeDescriptor() {
        return null;
    }

    protected PHPexeDescriptor getSpecificPHPexeDescriptor() {
        return null;
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateLaunchConfigurationDialog();
    }

    protected void createDebugInfoComponent(Composite composite) {
        this.runWithDebugInfo = new Button(composite, 32);
        this.runWithDebugInfo.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.runWithDebugInfo.setLayoutData((Object)gridData);
        this.runWithDebugInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void createArgumentComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPDebugUIMessages.Arguments;
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setFont(composite.getFont());
        this.argumentField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.argumentField.setLayoutData((Object)gridData);
        this.argumentField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentField, group.getText());
        Composite composite2 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridData = new GridData(128);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.argumentVariablesButton = this.createPushButton(composite2, PHPDebugUIMessages.Variables, null);
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.updateLocation(iLaunchConfiguration);
        if (!this.disableDebugInfoOption) {
            this.updateDebugInfoOption(iLaunchConfiguration);
        }
        if (!this.disableFileSelection) {
            IProject iProject;
            WebResource webResource;
            IModule iModule;
            IStructuredSelection iStructuredSelection;
            IModuleArtifact iModuleArtifact;
            this.updateArgument(iLaunchConfiguration);
            String string = this.argumentField.getText();
            if (string.equals("") && ApacheUIPlugin.currentSelection != null && !ApacheUIPlugin.currentSelection.isEmpty() && (iModuleArtifact = ServerPlugin.getModuleArtifact((Object)(iStructuredSelection = (IStructuredSelection)ApacheUIPlugin.currentSelection).getFirstElement())) instanceof WebResource && (iModule = (webResource = (WebResource)iModuleArtifact).getModule()) != null && (iProject = iModule.getProject()) != null) {
                IPath iPath = webResource.getPath();
                if (iPath.isEmpty()) {
                    string = iProject.getFullPath().toString();
                } else {
                    IFile iFile = iProject.getFile(iPath);
                    string = iFile.getFullPath().toString();
                }
                this.argumentField.setText(string);
            }
        }
    }

    public String getName() {
        return "PHP Exe";
    }

    protected void updateLocation(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        PHPexes pHPexes = this.phpsComboBlock.getPHPs(true);
        PHPexeItem pHPexeItem = string != null && string.length() > 0 ? pHPexes.getItemForFile(string) : pHPexes.getDefaultItem();
        this.phpsComboBlock.setPHPexe(pHPexeItem);
    }

    protected void updateArgument(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        this.argumentField.setText(string);
    }

    protected void updateDebugInfoOption(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = PHPDebugPlugin.getDebugInfoOption();
        try {
            bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        this.runWithDebugInfo.setSelection(bl);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.phpsComboBlock.getSelectedLocation();
        if (string.length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string);
        }
        String string2 = null;
        if (this.disableFileSelection || (string2 = this.argumentField.getText().trim()).length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string2);
        }
        boolean bl = this.disableDebugInfoOption ? true : this.runWithDebugInfo.getSelection();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
    }

    private boolean fileExists(String string) {
        ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string);
        boolean bl = ResourcesPlugin.getWorkspace().getRoot().exists((IPath)path);
        return bl;
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        Object object;
        String string;
        block5: {
            this.setErrorMessage(null);
            try {
                string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
                if (string == "" || string == null || ((File)(object = new File(string))).exists()) break block5;
                this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                return false;
            }
            catch (CoreException coreException) {}
        }
        if (!this.disableFileSelection && (object = iLaunchConfiguration.getAttribute("ATTR_FILE", "")) != "" && string != null && !this.fileExists((String)object)) {
            this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
            return false;
        }
        return true;
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String string = fileDialog.open();
        if (string != null) {
            this.locationField.setText(string);
        }
    }

    private void handleVariablesButtonSelected(Text text) {
        ResourcesPlugin.getWorkspace().getRoot();
        IFile iFile = null;
        iFile = (IFile)HTTPServerUtil.getFileFromDialog(null, (Shell)this.getShell(), (String[])LaunchUtil.getFileExtensions(), (String[])LaunchUtil.getRequiredNatures());
        if (iFile != null) {
            text.setText(iFile.getFullPath().toString());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (object == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleVariablesButtonSelected(PHPExecutableLaunchTab.this.argumentField);
            }
        }
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }
}

