/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences.phps;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.debug.ui.preferences.phps.InstalledPHPsBlock;
import org.eclipse.php.ui.preferences.ui.AbstractPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PHPsPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private InstalledPHPsBlock fPHPBlock;
    PHPexes phpExes;

    public PHPsPreferencePage() {
        this.setTitle(PHPDebugUIMessages.PHPsPreferencePage_1);
        this.setDescription(PHPDebugUIMessages.PHPsPreferencePage_2);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Preferences getModelPreferences() {
        return PHPDebugUIPlugin.getDefault().getPluginPreferences();
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.noDefaultAndApplyButton();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.phpExes = new PHPexes();
        this.phpExes.load(this.getModelPreferences());
        this.fPHPBlock = new InstalledPHPsBlock(this.phpExes);
        this.fPHPBlock.createControl(composite);
        Control control = this.fPHPBlock.getControl();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        control.setLayoutData((Object)gridData);
        this.fPHPBlock.restoreColumnSettings(PHPDebugUIPlugin.getDefault().getDialogSettings(), PHPDebugCorePreferenceNames.DIALOG_COLUMN_WIDTH);
        this.initDefaultPHP();
        this.applyDialogFont(composite);
        return composite;
    }

    private PHPexeItem getCurrentDefaultPHP() {
        return this.fPHPBlock.getCheckedPHP();
    }

    public boolean performOk() {
        IDialogSettings iDialogSettings = PHPDebugUIPlugin.getDefault().getDialogSettings();
        this.fPHPBlock.saveColumnSettings(iDialogSettings, PHPDebugCorePreferenceNames.DIALOG_COLUMN_WIDTH);
        return super.performOk();
    }

    protected void storeValues() {
        this.phpExes.setDefaultItem(this.fPHPBlock.getCheckedPHP());
        Preferences preferences = this.getModelPreferences();
        this.phpExes.store(preferences);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyDefaultPHP(PHPexeItem pHPexeItem) {
        if (pHPexeItem == null) {
            this.fPHPBlock.setCheckedPHP(null);
            return;
        }
        boolean bl = pHPexeItem.getLocation().exists();
        if (bl) {
            this.fPHPBlock.setCheckedPHP(pHPexeItem);
            return;
        }
        this.fPHPBlock.removePHPs(new PHPexeItem[]{pHPexeItem});
        PHPexeItem pHPexeItem2 = this.phpExes.getDefaultItem();
        if (pHPexeItem2 == null) {
            this.fPHPBlock.setCheckedPHP(null);
        } else {
            this.fPHPBlock.setCheckedPHP(pHPexeItem2);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)PHPDebugUIMessages.PHPsPreferencePage_1, (String)PHPDebugUIMessages.PHPsPreferencePage_10, (IStatus)new Status(4, "org.eclipse.php.debug.ui", 10001, PHPDebugUIMessages.PHPsPreferencePage_11, null));
    }

    private void initDefaultPHP() {
        PHPexeItem pHPexeItem = this.phpExes.getDefaultItem();
        if (pHPexeItem != null) {
            PHPexeItem[] pHPexeItemArray = this.fPHPBlock.getPHPs();
            int n = 0;
            while (n < pHPexeItemArray.length) {
                PHPexeItem pHPexeItem2 = pHPexeItemArray[n];
                if (pHPexeItem2.equals((Object)pHPexeItem)) {
                    this.verifyDefaultPHP(pHPexeItem2);
                    break;
                }
                ++n;
            }
        }
    }
}

