/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.server.apache.core.ApachePlugin;
import org.eclipse.php.server.apache.core.ApacheServer;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.BundleContext;

public class PHPDebugPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.core";
    public static final int INTERNAL_ERROR = 10001;
    private static PHPDebugPlugin plugin;
    private static String fPHPDebugPerspective;
    private static String fDebugPerspective;
    public static final boolean DebugPHP;

    static {
        fPHPDebugPerspective = "org.eclipse.php.debug.ui.PHPDebugPerspective";
        fDebugPerspective = "org.eclipse.debug.ui.DebugPerspective";
        String string = Platform.getDebugOption((String)"org.eclipse.php.debug.core/debug");
        DebugPHP = string != null && string.equalsIgnoreCase("true");
    }

    public PHPDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        ApachePlugin.getInstance();
        this.setLaunchPerspective();
        PHPDebugPlugin.createDefaultPHPServer();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static PHPDebugPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static boolean getStopAtFirstLine() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
    }

    public static boolean getDebugInfoOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO);
    }

    public static boolean getOpenDebugViewsOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS);
    }

    public static int getDebugPort() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getInt(PHPDebugCorePreferenceNames.DEBUG_PORT);
    }

    public static String getWorkspaceURL() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getString(PHPDebugCorePreferenceNames.DEDAULT_URL);
    }

    public void setLaunchPerspective() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = iLaunchManager.getLaunchConfigurationTypes();
        Preferences preferences = this.getPluginPreferences();
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.USE_PHP_DEBUG_PERSPECTIVE);
        int n = 0;
        while (n < iLaunchConfigurationTypeArray.length) {
            if (iLaunchConfigurationTypeArray[n].getIdentifier().startsWith("org.eclipse.php.")) {
                if (bl) {
                    DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationTypeArray[n], (String)"debug", (String)fPHPDebugPerspective);
                } else {
                    DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationTypeArray[n], (String)"debug", (String)fDebugPerspective);
                }
            }
            ++n;
        }
    }

    public static void createDefaultPHPServer() {
        String string = PHPDebugPlugin.getWorkspaceURL();
        IServer iServer = ApacheServer.checkForApacheServer((String)"org.eclipse.php.debug.core.Default_Server");
        if (iServer == null) {
            ApacheServer.createApacheServer((String)"Default PHP Web Server", (String)string, (String)"org.eclipse.php.debug.core.Default_Server");
        } else {
            ApacheServer.updateBaseURL((IServer)iServer, (String)string);
        }
    }

    public static void log(IStatus iStatus) {
        PHPDebugPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, "PHPDebug plugin internal error", throwable));
    }

    public static void logErrorMessage(String string) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, string, null));
    }
}

