/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.launching;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.PHPExecutableDebuggerInitializer;
import org.eclipse.php.debug.core.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.debug.core.model.DebugSessionIdGenerator;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;

public class PHPExecutableLaunchDelegate
implements ILaunchConfigurationDelegate {
    protected Map envVariables = null;

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        IResource iResource;
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string3 = iLaunchConfiguration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        String string4 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (string4 == null || string4.equals("")) {
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string4);
        IProject iProject = null;
        String string5 = null;
        if (string3 == null) {
            iResource = iWorkspaceRoot.findMember((IPath)path);
            if (iResource == null) {
                return;
            }
            iProject = iResource.getProject();
            string5 = iResource.getLocation().toString();
        } else {
            try {
                iResource = new Path(string3);
                iProject = iWorkspaceRoot.getProject(iResource.lastSegment());
                string5 = path.makeAbsolute().toString();
            }
            catch (Exception exception) {}
            if (iProject == null) {
                return;
            }
        }
        if (string.equals("debug") || bl) {
            boolean bl2 = PHPProjectPreferences.getStopAtFirstLine(iProject);
            int n = PHPProjectPreferences.getDebugPort(iProject);
            String string6 = iProject.getFullPath().toString();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string6);
            iLaunchConfigurationWorkingCopy.doSave();
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            int n2 = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(n2, iLaunch);
            iLaunch.setAttribute("port", Integer.toString(n));
            iLaunch.setAttribute("firstLineBreakpoint", Boolean.toString(bl2));
            iLaunch.setAttribute("debugSessionID", Integer.toString(n2));
            this.debugPHPExecutable(iLaunch, string2, string5);
        } else {
            iResource = new Path(string2);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            IPath iPath = iProject.getRawLocation();
            if (iPath == null) {
                iPath = iProject.getLocation();
            }
            String string7 = iPath.toOSString();
            Path path2 = new Path(string7);
            File file = path2.toFile();
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            Path path3 = new Path(string4);
            if (string4.startsWith("/")) {
                path3 = path3.removeFirstSegments(1);
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String[] stringArray = DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String[] stringArray2 = new String[]{iResource.toOSString(), path3.toOSString()};
            Process process = DebugPlugin.exec((String[])stringArray2, (File)file, (String[])stringArray);
            IProcess iProcess = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string8 = iResource.lastSegment();
            String string9 = iResource.getFileExtension();
            if (string9 != null) {
                string8 = string8.substring(0, string8.length() - (string9.length() + 1));
            }
            string8 = string8.toLowerCase();
            hashMap.put(IProcess.ATTR_PROCESS_TYPE, string8);
            if (process != null) {
                iProgressMonitor.beginTask(MessageFormat.format("start launch", iLaunchConfiguration.getName()), -1);
                iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)iResource.toOSString(), hashMap);
                if (iProcess == null) {
                    process.destroy();
                    throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
                }
            }
            iProcess.setAttribute(IProcess.ATTR_CMDLINE, string4);
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)iLaunchConfiguration)) {
                while (!iProcess.isTerminated()) {
                    try {
                        if (iProgressMonitor.isCanceled()) {
                            iProcess.terminate();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                RefreshTab.refreshResources((ILaunchConfiguration)iLaunchConfiguration, (IProgressMonitor)iProgressMonitor);
            }
        }
    }

    public void debugPHPExecutable(ILaunch iLaunch, String string, String string2) throws DebugException {
        try {
            PHPExecutableDebuggerInitializer pHPExecutableDebuggerInitializer = new PHPExecutableDebuggerInitializer(iLaunch);
            pHPExecutableDebuggerInitializer.initializeDebug(new File(string).getAbsolutePath(), new File(string2).getAbsolutePath(), this.envVariables);
        }
        catch (IOException iOException) {
            Logger.logException("PHPDebugTarget: Debugger didn't find file to debug.", iOException);
            String string3 = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string3, (Throwable)iOException));
        }
    }
}

