/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.launching;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.debug.core.debugger.PHPWebServerDebuggerInitializer;
import org.eclipse.php.debug.core.launching.PHPServerLaunchDecorator;
import org.eclipse.php.debug.core.model.DebugSessionIdGenerator;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.server.apache.core.ApacheLaunchConfigurationDelegate;
import org.eclipse.php.server.apache.core.ApacheServerBehaviour;
import org.eclipse.php.server.apache.core.IHTTPServerLaunch;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class PHPServerLaunchDelegate
implements IHTTPServerLaunch {
    private ApacheLaunchConfigurationDelegate httpServerDelegate = null;
    private ILaunch launch;
    private Job runDispatch;
    static /* synthetic */ Class class$0;

    public void setHTTPServerDelegate(ApacheLaunchConfigurationDelegate apacheLaunchConfigurationDelegate) {
        this.httpServerDelegate = apacheLaunchConfigurationDelegate;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = iLaunchConfiguration.getAttribute("run_with_debug", true);
        this.launch = iLaunch;
        if (string.equals("run") && !bl) {
            this.httpServerDelegate.doLaunch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
            return;
        }
        IServer iServer = ServerUtil.getServer((ILaunchConfiguration)iLaunchConfiguration);
        if (iServer == null) {
            Logger.log(4, "Luanch configuration could not find server");
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServerBehaviour");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ApacheServerBehaviour apacheServerBehaviour = (ApacheServerBehaviour)iServer.loadAdapter((Class)clazz, null);
        apacheServerBehaviour.setupLaunch(iLaunch, string, iProgressMonitor);
        IModuleArtifact iModuleArtifact = this.httpServerDelegate.getModuleArtifact(iLaunchConfiguration);
        if (iModuleArtifact == null) {
            throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, PHPDebugCoreMessages.configurationError, null));
        }
        IModule iModule = iModuleArtifact.getModule();
        boolean bl2 = iLaunchConfiguration.getAttribute("deployable", false);
        if (bl2 && !apacheServerBehaviour.publish(iModule, iProgressMonitor)) {
            this.terminated();
            return;
        }
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
        IProject iProject = iModule.getProject();
        String string2 = iProject.getFullPath().toString();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string2);
        iLaunchConfigurationWorkingCopy.doSave();
        String string3 = iLaunchConfiguration.getAttribute("url", "");
        if (string.equals("debug") || bl) {
            boolean bl3 = PHPProjectPreferences.getStopAtFirstLine(iProject);
            int n = PHPProjectPreferences.getDebugPort(iProject);
            int n2 = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(n2, new PHPServerLaunchDecorator(iLaunch, apacheServerBehaviour, iProject));
            iLaunch.setAttribute("port", Integer.toString(n));
            iLaunch.setAttribute("webServerDebugger", Boolean.toString(true));
            iLaunch.setAttribute("firstLineBreakpoint", Boolean.toString(bl3));
            iLaunch.setAttribute("uriginalURL", string3);
            iLaunch.setAttribute("debugSessionID", Integer.toString(n2));
            this.runDispatch = new RunDispatchJobWebServer(iLaunch);
            this.runDispatch.schedule();
        }
    }

    public void runPHPWebServer(ILaunch iLaunch) {
        PHPWebServerDebuggerInitializer pHPWebServerDebuggerInitializer = new PHPWebServerDebuggerInitializer(iLaunch);
        try {
            pHPWebServerDebuggerInitializer.debug();
        }
        catch (DebugException debugException) {
            IStatus iStatus = debugException.getStatus();
            String string = null;
            if (iStatus == null) {
                Logger.traceException("Unexpected Error return from debuggerInitializer ", debugException);
                this.fireError(PHPDebugCoreMessages.Debugger_Unexpected_Error_1, (Exception)((Object)debugException));
                string = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
            } else {
                this.fireError(iStatus);
                string = iStatus.getMessage();
            }
            this.displayErrorMessage(string);
        }
    }

    private void displayErrorMessage(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)string);
            }
        });
    }

    public void fireError(IStatus iStatus) {
        DebugEvent debugEvent = new DebugEvent((Object)this, 32);
        debugEvent.setData((Object)iStatus);
        this.fireEvent(debugEvent);
    }

    public void fireError(String string, Exception exception) {
        Status status = new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)exception);
        DebugEvent debugEvent = new DebugEvent((Object)this, 32);
        debugEvent.setData((Object)status);
        this.fireEvent(debugEvent);
    }

    public void terminated() {
        DebugEvent debugEvent = null;
        if (this.launch.getDebugTarget() == null) {
            DummyDebugTarget dummyDebugTarget = new DummyDebugTarget(this.launch);
            debugEvent = new DebugEvent((Object)dummyDebugTarget, 8);
            if (this.launch != null) {
                this.launch.addDebugTarget((IDebugTarget)dummyDebugTarget);
                IDebugEventSetListener iDebugEventSetListener = (IDebugEventSetListener)this.launch;
                iDebugEventSetListener.handleDebugEvents(new DebugEvent[]{debugEvent});
            }
        }
        debugEvent = new DebugEvent((Object)this, 8);
        this.fireEvent(debugEvent);
    }

    public void fireEvent(DebugEvent debugEvent) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    class RunDispatchJobWebServer
    extends Job {
        private ILaunch launch;

        public RunDispatchJobWebServer(ILaunch iLaunch) {
            super("runPHPWebServer");
            this.launch = iLaunch;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            PHPServerLaunchDelegate.this.runPHPWebServer(this.launch);
            Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Calling Terminated()");
            PHPServerLaunchDelegate.this.terminated();
            return Status.OK_STATUS;
        }

        public String toString() {
            String string = ((Object)((Object)this)).getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            return String.valueOf(string) + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }

    private class DummyDebugTarget
    implements IDebugTarget {
        private ILaunch launch;

        public DummyDebugTarget(ILaunch iLaunch) {
            this.launch = iLaunch;
        }

        public String getName() throws DebugException {
            return "Session Terminated";
        }

        public IProcess getProcess() {
            return null;
        }

        public IThread[] getThreads() throws DebugException {
            return null;
        }

        public boolean hasThreads() throws DebugException {
            return false;
        }

        public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return this;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public String getModelIdentifier() {
            return "";
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public boolean canTerminate() {
            return true;
        }

        public boolean isTerminated() {
            return true;
        }

        public void terminate() throws DebugException {
        }

        public boolean canResume() {
            return false;
        }

        public boolean canSuspend() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void resume() throws DebugException {
        }

        public void suspend() throws DebugException {
        }

        public void breakpointAdded(IBreakpoint iBreakpoint) {
        }

        public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        }

        public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        }

        public boolean canDisconnect() {
            return false;
        }

        public void disconnect() throws DebugException {
        }

        public boolean isDisconnected() {
            return false;
        }

        public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
            return null;
        }

        public boolean supportsStorageRetrieval() {
            return false;
        }
    }
}

