/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.format;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.documentModel.dom.PHPElementImpl;
import org.eclipse.php.core.format.CaseDefualtIndentationStrategy;
import org.eclipse.php.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.core.format.DefualtIndentationStrategy;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.core.format.IIndentationStrategy;
import org.eclipse.php.core.format.PhpFormatConstraints;
import org.eclipse.php.core.format.PhpFormatProcessorImpl;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class PhpFormatter
implements IStructuredFormatter {
    private IIndentationStrategy defualtIndentationStrategy = new DefualtIndentationStrategy();
    private IIndentationStrategy curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();
    private IIndentationStrategy caseDefualtIndentationStrategy = new CaseDefualtIndentationStrategy();
    protected PhpFormatConstraints fFormatContraints = null;
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected IProgressMonitor fProgressMonitor = null;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_SPACE = 32;
    private PhpFormatProcessorImpl fProcessoer = null;
    private StringBuffer resultBuffer = new StringBuffer();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.core.format.PhpFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void format(Node node) {
        this.format(node, this.getFormatContraints());
    }

    public void format(Node node, IStructuredFormatContraints iStructuredFormatContraints) {
        if (node instanceof IDOMNode) {
            this.formatNode((IDOMNode)node, iStructuredFormatContraints);
        }
    }

    private void formatNode(IDOMNode iDOMNode, IStructuredFormatContraints iStructuredFormatContraints) {
        if (iDOMNode instanceof PHPElementImpl) {
            IStructuredDocumentRegion iStructuredDocumentRegion = iDOMNode.getStartStructuredDocumentRegion();
            IStructuredDocumentRegion iStructuredDocumentRegion2 = iDOMNode.getEndStructuredDocumentRegion();
            iStructuredDocumentRegion2 = iStructuredDocumentRegion2 == null ? iStructuredDocumentRegion : iStructuredDocumentRegion2;
            this.format(iStructuredDocumentRegion, iStructuredDocumentRegion2);
            return;
        }
        if (iDOMNode.hasChildNodes()) {
            IDOMNode iDOMNode2 = (IDOMNode)iDOMNode.getFirstChild();
            while (iDOMNode2 != null) {
                this.formatNode(iDOMNode2, iStructuredFormatContraints);
                iDOMNode2 = (IDOMNode)iDOMNode2.getNextSibling();
            }
        }
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new PhpFormatConstraints();
        }
        return this.fFormatContraints;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        return this.fFormatPreferences;
    }

    public void setFormatPreferences(IStructuredFormatPreferences iStructuredFormatPreferences) {
        this.fFormatPreferences = iStructuredFormatPreferences;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
    }

    public void setProcessor(PhpFormatProcessorImpl phpFormatProcessorImpl) {
        this.fProcessoer = phpFormatProcessorImpl;
    }

    protected int getStart() {
        return this.fProcessoer == null ? 0 : this.fProcessoer.getStart();
    }

    protected int getLength() {
        return this.fProcessoer == null ? 0 : this.fProcessoer.getLength();
    }

    private void format(IStructuredDocumentRegion iStructuredDocumentRegion, IStructuredDocumentRegion iStructuredDocumentRegion2) {
        if (!($assertionsDisabled || iStructuredDocumentRegion2 != null && iStructuredDocumentRegion != null)) {
            throw new AssertionError();
        }
        int n = iStructuredDocumentRegion.getStartOffset();
        int n2 = iStructuredDocumentRegion2.getEnd();
        int n3 = this.getStart();
        int n4 = n3 + this.getLength();
        int n5 = Math.max(n3, n);
        int n6 = Math.min(n4, n2);
        IStructuredDocument iStructuredDocument = iStructuredDocumentRegion.getParentDocument();
        int n7 = iStructuredDocument.getLineOfOffset(n5);
        int n8 = iStructuredDocument.getLineOfOffset(n6);
        while (n7 <= n8) {
            this.formatLine(iStructuredDocument, n7);
            ++n7;
        }
    }

    private void formatLine(IStructuredDocument iStructuredDocument, int n) {
        this.resultBuffer.setLength(0);
        try {
            int n2;
            int n3;
            IRegion iRegion = iStructuredDocument.getLineInformation(n);
            int n4 = iRegion.getOffset();
            int n5 = iRegion.getLength();
            if (n5 == 0) {
                return;
            }
            String string = iStructuredDocument.get(n4, n5);
            IRegion iRegion2 = this.getFormattedLineInformation(iRegion, string);
            if (!this.shouldReformat(iStructuredDocument, iRegion2)) {
                return;
            }
            int n6 = iRegion2.getOffset();
            int n7 = n6 + (n3 = iRegion2.getLength());
            if (n7 != (n2 = n4 + n5)) {
                iStructuredDocument.replace(n7, n2 - n7, "");
            }
            int n8 = n6 - n4;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n6);
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n6);
            if (iTextRegion == null) {
                return;
            }
            if (iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset() < iRegion.getOffset() || iTextRegion.getType() == "WHITESPACE") {
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset() + iTextRegion.getEnd());
            }
            if (iTextRegion == null) {
                return;
            }
            String string2 = iTextRegion.getType();
            IIndentationStrategy iIndentationStrategy = string2 == "PHP_CASE" || string2 == "PHP_DEFAULT" ? this.caseDefualtIndentationStrategy : this.getIndentationStrategy(string.charAt(n8));
            iIndentationStrategy.placeMatchingBlanks(iStructuredDocument, this.resultBuffer, n, iStructuredDocument.getLineOffset(n));
            String string3 = this.resultBuffer.toString();
            String string4 = string.substring(0, n8);
            if (!string3.equals(string4)) {
                iStructuredDocument.replaceText((Object)iStructuredDocumentRegion, n4, n8, string3);
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private IRegion getFormattedLineInformation(IRegion iRegion, String string) {
        int n = 0;
        int n2 = string.length() - 1;
        byte[] byArray = string.getBytes();
        boolean bl = true;
        while (bl) {
            boolean bl2;
            boolean bl3 = byArray[n] == 32 || byArray[n] == 9;
            boolean bl4 = bl2 = byArray[n2] == 32 || byArray[n2] == 9;
            if (bl3) {
                ++n;
            }
            if (bl2) {
                --n2;
            }
            boolean bl5 = bl = (bl3 || bl2) && n < n2;
        }
        if (n > n2) {
            return new SimpleStructuredRegion(iRegion.getOffset(), 0);
        }
        return n == 0 && n2 == string.length() - 1 ? iRegion : new SimpleStructuredRegion(iRegion.getOffset() + n, n2 - n + 1);
    }

    private boolean shouldReformat(IStructuredDocument iStructuredDocument, IRegion iRegion) {
        String string = FormatterUtils.getPartitionType(iStructuredDocument, iRegion.getOffset());
        return string == "org.eclipse.php.PHP_DEFAULT" || string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT";
    }

    protected IIndentationStrategy getIndentationStrategy(char c) {
        if (c == '}') {
            return this.curlyCloseIndentationStrategy;
        }
        return this.getDefaultIndentationStrategy();
    }

    private IIndentationStrategy getDefaultIndentationStrategy() {
        return this.defualtIndentationStrategy;
    }
}

