/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.core.phpModel.parser.CompositePhpModel;
import org.eclipse.php.core.phpModel.parser.ExternalFilesModel;
import org.eclipse.php.core.phpModel.parser.IPhpModel;
import org.eclipse.php.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.parser.ParserClient;
import org.eclipse.php.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.core.preferences.PreferencesSupport;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.core.util.DefaultCacheManager;
import org.eclipse.php.core.util.IncludeCacheManager;

public class PHPIncludePathModelManager
extends PhpModelProxy
implements ExternalFilesModel {
    CompositePhpModel compositePhpModel = new CompositePhpModel(){

        public String getID() {
            return "CompositeIncludePathModel";
        }

        public void initialize(IProject iProject) {
        }
    };
    private PHPParserManager parserManager;
    private String phpVersion;
    private ArrayList libraries;
    private ArrayList projects;
    private ArrayList zips;
    private ArrayList variables;
    private String[] validExtensions;
    private IncludePathListener includePathListener;
    private PhpVersionListener phpVersionListener;
    private IProject project;
    private HashMap modelsToCache;
    private IncludeCacheManager includeCacheManager;
    private boolean initialized;
    private IResourceChangeListener projectResourcesListener;

    public PHPIncludePathModelManager() {
        this.model = this.compositePhpModel;
        this.libraries = new ArrayList();
        this.projects = new ArrayList();
        this.zips = new ArrayList();
        this.variables = new ArrayList();
        this.modelsToCache = new HashMap();
    }

    public void initialize(IProject iProject) {
        if (this.initialized) {
            if (iProject != this.project) {
                PHPCorePlugin.logErrorMessage("PHPIncludePathModelManager in already initialized with a different project.");
            }
            return;
        }
        this.includeCacheManager = DefaultCacheManager.instance().getIncludeCacheManager();
        this.project = iProject;
        this.initListeners();
        this.setPHPVersion(PhpVersionProjectPropertyHandler.getVersion(iProject));
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        if (pHPProjectOptions == null) {
            return;
        }
        IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
        this.loadChanges(iIncludePathEntryArray);
        ArrayList arrayList = new ArrayList(this.variables);
        arrayList.addAll(this.libraries);
        arrayList.addAll(this.zips);
        this.includeCacheManager.includePathChanged(iProject, this.getAsCachedNames(arrayList));
        this.initialized = true;
    }

    public IPhpModel[] listModels() {
        return this.compositePhpModel.getModels();
    }

    private void addLibrary(File file, boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = bl ? this.zips : this.libraries;
        if (this.getIndexOf(file, arrayList) != -1) {
            return;
        }
        arrayList.add(file);
        this.innerAddLibrary(file, bl);
    }

    private void innerAddLibrary(File file, boolean bl) {
        PHPIncludePathModel pHPIncludePathModel = new PHPIncludePathModel(file.getPath(), bl ? 0 : 1);
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        ParserClient parserClient = pHPLanguageManager.createParserClient(pHPIncludePathModel);
        this.updateExtentionList();
        if (file.exists()) {
            if (bl) {
                if (file.lastModified() < DefaultCacheManager.instance().getSharedCacheModificationTime(this.project, pHPIncludePathModel)) {
                    DefaultCacheManager.instance().load(this.project, pHPIncludePathModel, true);
                    this.compositePhpModel.addModel(pHPIncludePathModel);
                    return;
                }
                this.modelsToCache.put(pHPIncludePathModel, pHPIncludePathModel);
                this.parseZip(file, parserClient);
            } else {
                PHPIncludePathModel pHPIncludePathModel2 = new PHPIncludePathModel(file.getPath(), 1);
                DefaultCacheManager.instance().load(this.project, pHPIncludePathModel2, true);
                this.recursiveParse(file, parserClient, pHPIncludePathModel, pHPIncludePathModel2);
            }
        }
        this.compositePhpModel.addModel(pHPIncludePathModel);
    }

    private void recursiveParse(File file, ParserClient parserClient, PHPIncludePathModel pHPIncludePathModel, PHPIncludePathModel pHPIncludePathModel2) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2;
            if (fileArray[n].isDirectory()) {
                this.recursiveParse(fileArray[n], parserClient, pHPIncludePathModel, pHPIncludePathModel2);
            } else if (fileArray[n].isFile() && this.isPhpFile((file2 = fileArray[n]).getName())) {
                String string = file2.getPath();
                PHPFileData pHPFileData = pHPIncludePathModel2.getFileData(string);
                if (this.isValid(pHPFileData, file2)) {
                    pHPIncludePathModel.insert(pHPFileData);
                    pHPIncludePathModel2.delete(string);
                } else {
                    this.modelsToCache.put(pHPIncludePathModel, pHPIncludePathModel);
                    this.parse(file2, parserClient);
                }
            }
            ++n;
        }
    }

    private boolean isValid(PHPFileData pHPFileData, File file) {
        if (pHPFileData != null && file != null) {
            return pHPFileData.getCreationTimeLastModified() - file.lastModified() >= 0L;
        }
        return false;
    }

    private void parse(File file, ParserClient parserClient) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            this.parserManager.parse(inputStreamReader, file.getPath(), file.lastModified(), parserClient, UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (FileNotFoundException fileNotFoundException) {
            PHPCorePlugin.log(fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
            return;
        }
    }

    private boolean isPhpFile(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        int n2 = 0;
        while (n2 < this.validExtensions.length) {
            if (string2.equals(this.validExtensions[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void removeLibrary(File file, boolean bl) {
        ArrayList arrayList = bl ? this.zips : this.libraries;
        int n = this.getIndexOf(file, arrayList);
        if (n == -1) {
            return;
        }
        arrayList.remove(n);
        this.innerRemoveLibrary(file);
    }

    private void innerRemoveLibrary(File file) {
        IPhpModel iPhpModel = this.compositePhpModel.remove(file.getPath());
        if (iPhpModel != null) {
            this.modelsToCache.remove(iPhpModel);
        }
    }

    private void parseZip(File file, ParserClient parserClient) {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    String string = zipEntry.getName();
                    if (this.isPhpFile(string)) {
                        int n = (int)zipEntry.getSize();
                        LimitedByteReader limitedByteReader = new LimitedByteReader(zipInputStream, n);
                        this.parserManager.parse(limitedByteReader, string, file.lastModified(), parserClient, UseAspTagsHandler.useAspTagsAsPhp(this.project));
                    } else {
                        zipInputStream.skip(zipEntry.getSize());
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
        }
        if (zipInputStream != null) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void updatePHPVersion(String string, String string2) {
        this.setPHPVersion(string2);
        this.includeCacheManager.phpVersionChanged(this.project, string, string2);
        DefaultCacheManager defaultCacheManager = DefaultCacheManager.instance();
        IPhpModel[] iPhpModelArray = this.compositePhpModel.getModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            File file = defaultCacheManager.getSharedCacheFile(string2, iPhpModelArray[n].getID());
            if (!file.exists()) {
                this.modelsToCache.put(iPhpModelArray[n], iPhpModelArray[n]);
            } else {
                this.modelsToCache.remove(iPhpModelArray[n]);
            }
            ++n;
        }
    }

    private void setPHPVersion(String string) {
        this.phpVersion = string;
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        this.parserManager = pHPLanguageManager.createPHPParserManager();
    }

    private int getIndexOf(File file, ArrayList arrayList) {
        int n = 0;
        String string = file.getPath();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            if (file2.getPath().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void includePathChanged(IPath[] iPathArray, boolean bl) {
        File[] fileArray = new File[iPathArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            fileArray[n] = new File(iPathArray[n].toString());
            this.addLibrary(fileArray[n], bl);
            ++n;
        }
        ArrayList arrayList = bl ? this.zips : this.libraries;
        File[] fileArray2 = new File[arrayList.size()];
        arrayList.toArray(fileArray2);
        int n2 = 0;
        while (n2 < fileArray2.length) {
            String string = fileArray2[n2].getPath();
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < fileArray.length) {
                if (fileArray[n3].getPath().equals(string)) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2) {
                this.removeLibrary(fileArray2[n2], bl);
            }
            ++n2;
        }
    }

    private void projectListChanged(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            this.addProject(iResourceArray[n]);
            ++n;
        }
        IResource[] iResourceArray2 = new IResource[this.projects.size()];
        this.projects.toArray(iResourceArray2);
        int n2 = 0;
        while (n2 < iResourceArray2.length) {
            String string = iResourceArray2[n2].getName();
            boolean bl = false;
            int n3 = 0;
            while (n3 < iResourceArray.length) {
                if (iResourceArray[n3].getName().equals(string)) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.removeProject(iResourceArray2[n2]);
            }
            ++n2;
        }
    }

    private void addProject(IResource iResource) {
        if (this.getIndexOf(iResource) != -1) {
            return;
        }
        this.projects.add(iResource);
        this.innerAddProject((IProject)iResource);
    }

    private void innerAddProject(IProject iProject) {
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        IPhpModel iPhpModel = null;
        iPhpModel = pHPProjectModel == null ? new PHPUserModel() : pHPProjectModel.getModel(PHPUserModel.ID);
        ModelWrapper modelWrapper = new ModelWrapper(iPhpModel);
        modelWrapper.initialize(iProject);
        this.compositePhpModel.addModel(modelWrapper);
    }

    public void removeProject(IResource iResource) {
        int n = this.getIndexOf(iResource);
        if (n == -1) {
            return;
        }
        this.projects.remove(n);
        this.innerRemoveProject(iResource);
    }

    private void innerRemoveProject(IResource iResource) {
        IPhpModel iPhpModel = this.compositePhpModel.remove(iResource.getName());
        ((ModelWrapper)iPhpModel).dispose();
    }

    private int getIndexOf(IResource iResource) {
        int n = 0;
        String string = iResource.getName();
        Iterator iterator = this.projects.iterator();
        while (iterator.hasNext()) {
            IResource iResource2 = (IResource)iterator.next();
            if (iResource2.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void updateExtentionList() {
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.validExtensions = iContentType.getFileSpecs(8);
    }

    private void initListeners() {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(this.project);
        this.includePathListener = new IncludePathListener();
        pHPProjectOptions.addOptionChangeListener("org.eclipse.php.core.includePath", this.includePathListener);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
        if (this.projectResourcesListener == null) {
            this.projectResourcesListener = new ProjectResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectResourcesListener, 4);
        }
    }

    public void dispose() {
        super.dispose();
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(this.project);
        if (pHPProjectOptions != null) {
            pHPProjectOptions.removeOptionChangeListener("org.eclipse.php.core.includePath", this.includePathListener);
        }
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        IPath iPath = this.project.getLocation();
        if (iPath != null) {
            Iterator iterator = this.modelsToCache.keySet().iterator();
            while (iterator.hasNext()) {
                IPhpModel iPhpModel = (IPhpModel)iterator.next();
                DefaultCacheManager.instance().save(this.project, iPhpModel, true);
            }
        }
    }

    public void clean() {
        this.rebuild();
    }

    private void rebuild() {
        this.rebuildList(this.libraries, false);
        this.rebuildList(this.zips, true);
        this.rebuildVariablesList();
    }

    private void rebuildList(ArrayList arrayList, boolean bl) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.innerRemoveLibrary(file);
            this.innerAddLibrary(file, bl);
        }
    }

    private void rebuildVariablesList() {
        Iterator iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            IPath iPath = (IPath)iterator.next();
            this.innerRemoveVariable(iPath);
            this.innerAddVariable(iPath);
        }
    }

    private void loadChanges(IIncludePathEntry[] iIncludePathEntryArray) {
        ArrayList<IIncludePathEntry> arrayList = new ArrayList<IIncludePathEntry>();
        ArrayList<IIncludePathEntry> arrayList2 = new ArrayList<IIncludePathEntry>();
        ArrayList<IIncludePathEntry> arrayList3 = new ArrayList<IIncludePathEntry>();
        ArrayList<IIncludePathEntry> arrayList4 = new ArrayList<IIncludePathEntry>();
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            if (iIncludePathEntryArray[n].getEntryKind() == 1) {
                if (iIncludePathEntryArray[n].getContentKind() == 2) {
                    arrayList3.add(iIncludePathEntryArray[n]);
                } else {
                    arrayList.add(iIncludePathEntryArray[n]);
                }
            } else if (iIncludePathEntryArray[n].getEntryKind() == 2) {
                arrayList2.add(iIncludePathEntryArray[n]);
            } else if (iIncludePathEntryArray[n].getEntryKind() == 4) {
                arrayList4.add(iIncludePathEntryArray[n]);
            }
            ++n;
        }
        IPath[] iPathArray = new IPath[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            iPathArray[n2] = ((IIncludePathEntry)arrayList.get(n2)).getPath();
            ++n2;
        }
        this.includePathChanged(iPathArray, false);
        IResource[] iResourceArray = new IResource[arrayList2.size()];
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            iResourceArray[n3] = ((IIncludePathEntry)arrayList2.get(n3)).getResource();
            ++n3;
        }
        this.projectListChanged(iResourceArray);
        IPath[] iPathArray2 = new IPath[arrayList3.size()];
        int n4 = 0;
        while (n4 < arrayList3.size()) {
            iPathArray2[n4] = ((IIncludePathEntry)arrayList3.get(n4)).getPath();
            ++n4;
        }
        this.includePathChanged(iPathArray2, true);
        IPath[] iPathArray3 = new IPath[arrayList4.size()];
        int n5 = 0;
        while (n5 < arrayList4.size()) {
            iPathArray3[n5] = ((IIncludePathEntry)arrayList4.get(n5)).getPath();
            ++n5;
        }
        this.variablesListChanged(iPathArray3);
    }

    private void variablesListChanged(IPath[] iPathArray) {
        int n = 0;
        while (n < iPathArray.length) {
            this.addVariable(iPathArray[n]);
            ++n;
        }
        IPath[] iPathArray2 = new IPath[this.variables.size()];
        this.variables.toArray(iPathArray2);
        int n2 = 0;
        while (n2 < iPathArray2.length) {
            IPath iPath = iPathArray2[n2];
            boolean bl = false;
            int n3 = 0;
            while (n3 < iPathArray.length) {
                if (iPathArray[n3].equals((Object)iPath)) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.removeVariable(iPathArray2[n2]);
            }
            ++n2;
        }
        if (this.initialized) {
            ArrayList arrayList = new ArrayList(this.variables);
            arrayList.addAll(this.libraries);
            arrayList.addAll(this.zips);
            this.includeCacheManager.includePathChanged(this.project, this.getAsCachedNames(arrayList));
        }
    }

    private List getAsCachedNames(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        DefaultCacheManager defaultCacheManager = DefaultCacheManager.instance();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof File) {
                arrayList.add(defaultCacheManager.getSharedCacheFile(this.project, ((File)e).getPath()).getName());
            } else if (e instanceof IPath) {
                arrayList.add(defaultCacheManager.getSharedCacheFile(this.project, ((IPath)e).toFile().getPath()).getName());
            }
            ++n;
        }
        return arrayList;
    }

    private void addVariable(IPath iPath) {
        if (this.variables.indexOf(iPath) != -1) {
            return;
        }
        this.variables.add(iPath);
        this.innerAddVariable(iPath);
    }

    private void innerAddVariable(IPath iPath) {
        this.updateExtentionList();
        String string = iPath.toString();
        PHPIncludePathModel pHPIncludePathModel = new PHPIncludePathModel(string, 2);
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        ParserClient parserClient = pHPLanguageManager.createParserClient(pHPIncludePathModel);
        File file = this.getVriableFile(string);
        if (file != null) {
            if (file.isDirectory()) {
                PHPIncludePathModel pHPIncludePathModel2 = new PHPIncludePathModel(string, 2);
                DefaultCacheManager.instance().load(this.project, pHPIncludePathModel2, true);
                this.recursiveParse(file, parserClient, pHPIncludePathModel, pHPIncludePathModel2);
            } else {
                String string2 = file.getName();
                if (string2.toLowerCase().endsWith(".zip")) {
                    if (file.lastModified() < DefaultCacheManager.instance().getSharedCacheModificationTime(this.project, pHPIncludePathModel)) {
                        DefaultCacheManager.instance().load(this.project, pHPIncludePathModel, true);
                        return;
                    }
                    this.modelsToCache.put(pHPIncludePathModel, pHPIncludePathModel);
                    this.parseZip(file, parserClient);
                } else if (this.isPhpFile(string2)) {
                    PHPIncludePathModel pHPIncludePathModel3 = new PHPIncludePathModel(string, 2);
                    DefaultCacheManager.instance().load(this.project, pHPIncludePathModel3, true);
                    PHPFileData pHPFileData = pHPIncludePathModel3.getFileData(string2);
                    if (this.isValid(pHPFileData, file)) {
                        pHPIncludePathModel.insert(pHPFileData);
                        pHPIncludePathModel3.delete(string2);
                    } else {
                        this.modelsToCache.put(pHPIncludePathModel, pHPIncludePathModel);
                        this.parse(file, parserClient);
                    }
                }
            }
        }
        this.compositePhpModel.addModel(pHPIncludePathModel);
    }

    private File getVriableFile(String string) {
        IPath iPath;
        int n = string.indexOf(47);
        String string2 = "";
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        if ((iPath = PHPProjectOptions.getIncludePathVariable(string)) == null) {
            return null;
        }
        iPath = iPath.append(string2);
        return iPath.toFile();
    }

    private void removeVariable(IPath iPath) {
        if (this.variables.remove(iPath)) {
            this.innerRemoveVariable(iPath);
        }
    }

    private void innerRemoveVariable(IPath iPath) {
        this.compositePhpModel.remove(iPath.toString());
    }

    public Object getExternalResource(PHPFileData pHPFileData) {
        IPhpModel[] iPhpModelArray = this.compositePhpModel.getModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            if (this.contains(iPhpModelArray[n], pHPFileData)) {
                File file;
                String string = iPhpModelArray[n].getID();
                Path path = new Path(string);
                if (this.variables.indexOf(path) != -1) {
                    file = this.getVriableFile(string);
                    if (file == null) {
                        return null;
                    }
                    File file2 = new File(pHPFileData.getName());
                    if (file.isDirectory()) {
                        return file2;
                    }
                    if (file.getName().endsWith(".zip")) {
                        try {
                            return new ZipFile(file);
                        }
                        catch (ZipException zipException) {
                            Logger.logException(zipException);
                        }
                        catch (IOException iOException) {
                            Logger.logException(iOException);
                        }
                    }
                }
                if (this.getIndexOf(file = new File(string), this.libraries) != -1) {
                    return new File(pHPFileData.getName());
                }
                if (this.getIndexOf(file, this.zips) != -1) {
                    try {
                        return new ZipFile(file);
                    }
                    catch (ZipException zipException) {
                        Logger.logException(zipException);
                    }
                    catch (IOException iOException) {
                        Logger.logException(iOException);
                    }
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    private boolean contains(IPhpModel iPhpModel, PHPFileData pHPFileData) {
        return iPhpModel.getFileData(pHPFileData.getName()) != null;
    }

    private class IncludePathListener
    implements IPhpProjectOptionChangeListener {
        private IncludePathListener() {
        }

        public void notifyOptionChanged(Object object, Object object2) {
            IIncludePathEntry[] iIncludePathEntryArray = (IIncludePathEntry[])object2;
            PHPIncludePathModelManager.this.loadChanges(iIncludePathEntryArray);
        }
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string = (String)preferencesPropagatorEvent.getNewValue();
            String string2 = (String)preferencesPropagatorEvent.getOldValue();
            if (string2 == null) {
                string2 = PreferencesSupport.getWorkspacePreferencesValue("phpVersion", PHPCorePlugin.getDefault().getPreferenceStore());
            }
            PHPIncludePathModelManager.this.updatePHPVersion(string2, string);
        }

        public IProject getProject() {
            return PHPIncludePathModelManager.this.project;
        }
    }

    private class ModelWrapper
    extends PhpModelProxy {
        String id;
        IWorkspaceModelListener listener;

        ModelWrapper(IPhpModel iPhpModel) {
            this.model = iPhpModel;
        }

        public String getID() {
            return this.id;
        }

        public void initialize(IProject iProject) {
            this.id = iProject.getName();
            this.initListeners(iProject);
        }

        public void dispose() {
            PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener(this.id, this.listener);
        }

        private void initListeners(IProject iProject) {
            this.listener = new WorkspaceModelListener();
            PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener(iProject.getName(), this.listener);
        }

        private void updateModelWrapper(IPhpModel iPhpModel) {
            this.model = iPhpModel;
        }

        private class WorkspaceModelListener
        implements IWorkspaceModelListener {
            private WorkspaceModelListener() {
            }

            public void projectModelAdded(IProject iProject) {
                this.updateModel(iProject);
            }

            public void projectModelRemoved(IProject iProject) {
                PHPUserModel pHPUserModel = new PHPUserModel();
                ModelWrapper.this.updateModelWrapper(pHPUserModel);
            }

            public void projectModelChanged(IProject iProject) {
                this.updateModel(iProject);
            }

            private void updateModel(IProject iProject) {
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
                IPhpModel iPhpModel = pHPProjectModel == null ? new PHPUserModel() : pHPProjectModel.getModel(PHPUserModel.ID);
                ModelWrapper.this.updateModelWrapper(iPhpModel);
            }
        }
    }

    private class LimitedByteReader
    extends Reader {
        public static final int DEFAULT_BUFFER_SIZE = 8192;
        protected byte[] fBuffer;
        protected InputStream fInputStream;

        public LimitedByteReader(InputStream inputStream, int n) {
            this.fInputStream = inputStream;
            this.fBuffer = new byte[n];
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            int n = this.fInputStream.read();
            return n & 0xFF;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (n2 > this.fBuffer.length) {
                n2 = this.fBuffer.length;
            }
            int n3 = this.fInputStream.read(this.fBuffer, 0, n2);
            int n4 = 0;
            while (n4 < n3) {
                char c;
                byte by = this.fBuffer[n4];
                cArray[n + n4] = c = (char)(by & 0xFF);
                ++n4;
            }
            return n3;
        }

        public boolean ready() throws IOException {
            return this.fInputStream.available() > 0;
        }

        public long skip(long l) throws IOException {
            return this.fInputStream.skip(l);
        }
    }

    private class ProjectResourceChangeListener
    implements IResourceChangeListener {
        private ProjectResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (iResourceChangeEvent.getType() == 4) {
                this.handleProjectDeletion(iResourceChangeEvent.getResource());
            }
        }

        private void handleProjectDeletion(IResource iResource) {
            if (iResource == PHPIncludePathModelManager.this.project) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(PHPIncludePathModelManager.this.projectResourcesListener);
                PHPIncludePathModelManager.this.projectResourcesListener = null;
                PHPIncludePathModelManager.this.includeCacheManager.projectRemoved((IProject)iResource);
            }
        }
    }
}

