/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser.codeDataDB;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.php.core.phpModel.parser.codeDataDB.CodeDataDB;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;

public class TreeCodeDataDB
implements CodeDataDB {
    private final Map treeDatabase = new HashMap(1000);
    private final List flattenData = new ArrayList();
    private List chachedList = null;

    public synchronized void clear() {
        this.chachedList = null;
        this.treeDatabase.clear();
        this.flattenData.clear();
    }

    public synchronized List getCodeData(String string) {
        if (string == null) {
            return null;
        }
        return (List)this.treeDatabase.get(this.getCodeDataIdentifier(string));
    }

    public synchronized void addCodeData(CodeData codeData) {
        this.chachedList = null;
        String string = this.getCodeDataIdentifier(codeData.getName());
        ArrayList<CodeData> arrayList = (ArrayList<CodeData>)this.treeDatabase.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<CodeData>();
            this.treeDatabase.put(string, arrayList);
        } else {
            arrayList.remove(codeData);
        }
        arrayList.add(codeData);
        this.flattenData.add(codeData);
    }

    public synchronized void removeCodeData(CodeData codeData) {
        this.chachedList = null;
        String string = this.getCodeDataIdentifier(codeData.getName());
        ArrayList arrayList = (ArrayList)this.treeDatabase.get(string);
        if (arrayList == null) {
            return;
        }
        arrayList.remove(codeData);
        if (arrayList.isEmpty()) {
            this.treeDatabase.remove(arrayList);
        }
        this.flattenData.remove(codeData);
    }

    public synchronized List asList() {
        if (this.chachedList != null) {
            return this.chachedList;
        }
        this.chachedList = Collections.unmodifiableList(this.flattenData);
        return this.chachedList;
    }

    private String getCodeDataIdentifier(String string) {
        return string.trim().toLowerCase();
    }
}

