/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.server.apache.core.ApacheServer;
import org.eclipse.php.server.apache.ui.ApacheUIPlugin;
import org.eclipse.php.server.apache.ui.CompositeFragment;
import org.eclipse.php.server.apache.ui.IControlHandler;
import org.eclipse.php.server.apache.ui.Messages;
import org.eclipse.php.server.apache.ui.Trace;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class ServerCompositeFragment
extends CompositeFragment {
    protected ApacheServer server = null;
    protected Text name;
    protected Text url;
    protected Combo combo;
    protected Button publish;
    protected Text publishDir;
    protected Button browseButton;
    protected Button publishCheckBox;
    protected Label locationLabel;
    private ValuesCache originalValuesCache = new ValuesCache();
    private ValuesCache modifiedValuesCache;
    static /* synthetic */ Class class$0;

    public ServerCompositeFragment(Composite composite, IControlHandler iControlHandler, boolean bl) {
        super(composite, iControlHandler, bl);
        this.controlHandler.setTitle(Messages.wizardTitle);
        this.controlHandler.setDescription(Messages.wizardDescription);
        this.controlHandler.setImageDescriptor(ApacheUIPlugin.getImageDescriptor("wizServer"));
        this.setDisplayName(Messages.serverTabDisplayText);
        this.createControl();
    }

    public void setServerWorkingCopy(IServerWorkingCopy iServerWorkingCopy) {
        if (iServerWorkingCopy == null) {
            return;
        }
        super.setServerWorkingCopy(iServerWorkingCopy);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.server = (ApacheServer)iServerWorkingCopy.loadAdapter((Class)clazz, null);
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout gridLayout = new GridLayout(1, true);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.php.server.apache.ui.twnr0000");
        Label label = new Label(composite, 0);
        label.setText(Messages.runtimeName);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.name = new Text(composite, 2048);
        gridData = new GridData(768);
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ServerCompositeFragment.this.workingCopy != null) {
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.serverName = ServerCompositeFragment.this.name.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        this.createProjectLocationGroup(this);
        this.createURLGroup(this);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void init() {
        int n;
        Object object;
        String string;
        if (this.name == null || this.workingCopy == null || this.server == null) {
            return;
        }
        this.originalValuesCache.canPublish = this.server.canPublish();
        this.originalValuesCache.publishDir = this.server.getDocumentRoot();
        this.originalValuesCache.url = this.server.getBaseURL();
        this.originalValuesCache.serverName = this.workingCopy.getName();
        this.originalValuesCache.host = this.workingCopy.getHost();
        this.modifiedValuesCache = new ValuesCache(this.originalValuesCache);
        if (this.originalValuesCache.serverName != null) {
            boolean bl = false;
            string = this.originalValuesCache.serverName;
            object = string;
            if (!this.isForEditing()) {
                n = 0;
                while (n < 10) {
                    boolean bl2 = this.checkServerName(string);
                    if (bl2) {
                        this.name.setText(string);
                        this.modifiedValuesCache.serverName = string;
                        bl = true;
                        break;
                    }
                    string = String.valueOf(object) + " (" + Integer.toString(n + 2) + ")";
                    ++n;
                }
                if (!bl) {
                    this.name.setText("");
                    this.modifiedValuesCache.serverName = "";
                }
            } else {
                this.name.setText(string);
            }
        } else {
            this.name.setText("");
        }
        String string2 = this.originalValuesCache.publishDir;
        this.publishDir.setText(string2);
        string = this.originalValuesCache.url;
        if (!string.equals("")) {
            this.url.setText(string);
            try {
                object = new URL(string);
                this.originalValuesCache.port = n = ((URL)object).getPort();
                this.modifiedValuesCache.port = n;
            }
            catch (Exception exception) {
                this.setMessage(Messages.errorURL, 3);
            }
        } else {
            string = "http://" + this.workingCopy.getHost();
            this.url.setText(string);
            this.modifiedValuesCache.url = string;
            try {
                object = new URL(string);
                this.modifiedValuesCache.port = n = ((URL)object).getPort();
            }
            catch (Exception exception) {
                this.setMessage(Messages.errorURL, 3);
            }
        }
        boolean bl = this.originalValuesCache.canPublish;
        this.publishCheckBox.setSelection(bl);
        this.publishDir.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.locationLabel.setEnabled(bl);
        this.controlHandler.setTitle(String.valueOf(Messages.serverEditDialogTitle) + " [" + this.originalValuesCache.serverName + ']');
    }

    protected void validate() {
        String string;
        if (this.server == null) {
            this.setMessage("", 3);
            return;
        }
        this.setMessage("", 0);
        if (this.workingCopy != null) {
            string = this.modifiedValuesCache.serverName;
            if (string == null || string.trim().equals("")) {
                this.setMessage(Messages.wizardMissingServerName, 3);
            } else {
                boolean bl = this.checkServerName(string);
                if (!bl) {
                    this.setMessage(Messages.wizardDuplicateName, 3);
                }
            }
        }
        if ((string = this.url.getText()) == null || string.equals("")) {
            this.setMessage(Messages.errorURL, 3);
            return;
        }
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            this.modifiedValuesCache.host = string2;
            this.modifiedValuesCache.port = n;
        }
        catch (Exception exception) {
            this.setMessage(Messages.errorURL, 3);
            return;
        }
        this.controlHandler.update();
    }

    protected void setMessage(String string, int n) {
        this.controlHandler.setMessage(string, n);
        this.setComplete(n != 3);
        this.controlHandler.update();
    }

    protected void createURLGroup(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText("Enter the URL that points to the document root of this server");
        this.url = new Text((Composite)group, 2048);
        GridData gridData = new GridData(768);
        this.url.setLayoutData((Object)gridData);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ServerCompositeFragment.this.server != null) {
                    String string;
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.url = string = ServerCompositeFragment.this.url.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
    }

    private final void createProjectLocationGroup(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText("Publish Information");
        this.publishCheckBox = new Button((Composite)group, 131104);
        this.publishCheckBox.setText("Publish Projects to this Server");
        this.publishCheckBox.setFont(font);
        this.publishCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.getSource();
                boolean bl = button.getSelection();
                ServerCompositeFragment.this.publishDir.setEnabled(bl);
                ServerCompositeFragment.this.browseButton.setEnabled(bl);
                ServerCompositeFragment.this.locationLabel.setEnabled(bl);
                if (ServerCompositeFragment.this.server != null) {
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.canPublish = bl;
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.publishCheckBox.setLayoutData((Object)gridData);
        this.createUserSpecifiedProjectLocationGroup((Composite)group);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite composite) {
        Font font = composite.getFont();
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setFont(font);
        this.locationLabel.setText("Directory:");
        this.publishDir = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 305;
        this.publishDir.setLayoutData((Object)gridData);
        this.publishDir.setFont(font);
        this.publishDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ServerCompositeFragment.this.server != null) {
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.publishDir = ServerCompositeFragment.this.publishDir.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText(Messages.browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ServerCompositeFragment.this.getShell());
                directoryDialog.setMessage(Messages.selectInstallDir);
                directoryDialog.setFilterPath(ServerCompositeFragment.this.publishDir.getText());
                String string = directoryDialog.open();
                if (string != null) {
                    ServerCompositeFragment.this.publishDir.setText(string);
                }
            }
        });
    }

    private boolean checkServerName(String string) {
        if ((string = string.trim()).equals(this.originalValuesCache.serverName)) {
            return true;
        }
        IServer[] iServerArray = ServerCore.getServers();
        if (iServerArray != null) {
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer iServer = iServerArray[n2];
                if (string.equals(iServer.getName())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean performOk() {
        try {
            if (this.server != null) {
                this.server.setPort(String.valueOf(this.modifiedValuesCache.port));
                this.server.setBaseURL(this.modifiedValuesCache.url);
                this.server.setDocumentRoot(this.modifiedValuesCache.publishDir);
                this.server.setPublish(this.modifiedValuesCache.canPublish);
            }
            this.workingCopy.setHost(this.modifiedValuesCache.host);
            this.workingCopy.setName(this.modifiedValuesCache.serverName);
            this.getServerWorkingCopy().save(true, null);
        }
        catch (CoreException coreException) {
            Trace.trace(Trace.SEVERE, "Error while saving the new server settings", coreException);
            return false;
        }
        return true;
    }

    private class ValuesCache {
        boolean canPublish;
        String serverName;
        String publishDir;
        String url;
        String host;
        int port;

        public ValuesCache() {
        }

        public ValuesCache(ValuesCache valuesCache) {
            this.canPublish = valuesCache.canPublish;
            this.serverName = valuesCache.serverName;
            this.publishDir = valuesCache.publishDir;
            this.url = valuesCache.url;
            this.port = valuesCache.port;
            this.host = valuesCache.host;
        }
    }
}

