/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.Logger;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class DocBlockAutoEditStrategy
implements IAutoEditStrategy {
    private static final String lineStart = "* ";

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (TypingPreferences.closePhpdoc && documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoEditAfterNewLine((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoEditAfterNewLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        try {
            IRegion iRegion = iStructuredDocument.getLineInformationOfOffset(documentCommand.offset);
            int n = iRegion.getOffset();
            String string = iStructuredDocument.get(n, iRegion.getLength());
            String string2 = this.getBlanks(string);
            String string3 = string.trim();
            boolean bl = false;
            boolean bl2 = true;
            if (string3.startsWith("/**")) {
                bl = true;
            } else if (string3.startsWith("/*")) {
                bl = true;
                bl2 = false;
            }
            if (bl) {
                int n2;
                string2 = String.valueOf(string2) + ' ';
                documentCommand.text = String.valueOf(documentCommand.text) + string2;
                int n3 = string.indexOf("/*");
                String string4 = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + n3 - 1));
                if ((string4 == "org.eclipse.php.PHP_DEFAULT" || string4 == "org.eclipse.php.PHP_DOC" || string4 == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (n2 = this.handleDocBlockStart(iStructuredDocument, documentCommand, string2, bl2)) != -1) {
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    documentCommand.offset = n2;
                    documentCommand.length = 0;
                    documentCommand.text = "";
                    iStructuredDocument.getUndoManager().disableUndoManagement();
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    iStructuredDocument.getUndoManager().enableUndoManagement();
                }
                return;
            }
            boolean bl3 = iStructuredDocument.get(n, documentCommand.offset - n).endsWith("*/");
            if (!bl3 && string3.length() > 0 && string3.charAt(0) == '*') {
                documentCommand.text = String.valueOf(documentCommand.text) + string2 + lineStart;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private String getBlanks(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.charAt(n))) {
                return string.substring(0, n);
            }
            ++n;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int handleDocBlockStart(IStructuredDocument var1_1, DocumentCommand var2_2, String var3_3, boolean var4_4) {
        block19: {
            block18: {
                var5_5 = var4_4 != false ? "/**" : "/*";
                var6_6 = var5_5.length();
                var2_2.text = String.valueOf(var2_2.text) + "* ";
                var7_7 = var2_2.offset + var2_2.text.length();
                var8_8 = var2_2.offset + var2_2.length;
                if (this.isInsideExistingDocBlock(var1_1, var8_8)) {
                    return -1;
                }
                try {
                    try {
                        var9_9 = var1_1.getLineInformationOfOffset(var2_2.offset);
                        var10_11 = var9_9.getOffset();
                        var11_12 = var1_1.get(var10_11, var2_2.offset - var10_11);
                        var12_13 = var11_12.substring(var11_12.indexOf(var5_5) + var6_6).trim();
                        var7_7 = (var10_11 += var11_12.indexOf(var5_5)) + var6_6 + var2_2.text.length();
                        var13_14 = var8_8;
                        if (var8_8 < var9_9.getOffset() + var9_9.getLength() && (var14_15 = var1_1.get(var8_8, (var9_9 = var1_1.getLineInformationOfOffset(var8_8)).getOffset() + var9_9.getLength() - var8_8)).length() > 0) {
                            var15_16 = 0;
                            var16_18 = var14_15.charAt(0);
                            var15_16 = 0;
                            while (true) {
                                if (var15_16 >= var14_15.length() || !Character.isWhitespace(var16_18) || var16_18 == '\n') {
                                    var13_14 += var15_16;
                                    break;
                                }
                                var16_18 = var14_15.charAt(var15_16);
                                ++var2_2.length;
                                ++var15_16;
                            }
                        }
                        if (var4_4 && TypingPreferences.addDocTags) {
                            var1_1.getUndoManager().disableUndoManagement();
                            var1_1.replace(var10_11, var13_14 - var10_11, "");
                            var1_1.getUndoManager().enableUndoManagement();
                            var2_2.offset = var10_11;
                            var14_15 = (PHPEditorModel)StructuredModelManager.getModelManager().getModelForRead(var1_1);
                            var14_15.updateFileData();
                            if (var12_13.equals("")) {
                                var12_13 = null;
                            }
                            if ((var15_17 = this.getDocBlockStub((PHPEditorModel)var14_15, var1_1, var10_11, var12_13)) != null) {
                                var2_2.text = var15_17;
                                if (var12_13 == null) {
                                    var16_19 = var14_15.getFileData().getName();
                                    var17_20 = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(var16_19));
                                    try {
                                        var18_21 = EditorUtility.openInEditor(var17_20, true);
                                    }
                                    catch (PartInitException var19_22) {
                                        Logger.logException(var19_22);
                                        var2_2.text = String.valueOf(var5_5) + var2_2.text;
lbl49:
                                        // 2 sources

                                        while (true) {
                                            var20_24 = null;
                                            var1_1.getUndoManager().enableUndoManagement();
                                            return -1;
                                        }
                                    }
                                    var19_23 = (ITextEditor)var18_21;
                                    Display.getDefault().asyncExec((Runnable)new SelectText(var2_2.offset + var15_17.indexOf("E"), 25, var19_23));
                                    ** continue;
                                }
                                var22_28 = var7_7 + var12_13.length();
                                var20_25 = null;
                                break block18;
                            }
                            var2_2.text = String.valueOf(var5_5) + var2_2.text;
                        } else {
                            var2_2.length += var2_2.offset - (var10_11 += var6_6);
                            var2_2.offset = var10_11;
                        }
                        if (var12_13 != null && !var12_13.equals("")) {
                            var2_2.text = String.valueOf(var2_2.text) + var12_13;
                            var7_7 = var10_11 + var2_2.text.length();
                        }
                        break block19;
                    }
                    catch (BadLocationException var9_10) {
                        Logger.logException(var9_10);
                    }
                    break block19;
                }
                catch (Throwable var21_29) {
                    var20_26 = null;
                    var1_1.getUndoManager().enableUndoManagement();
                    throw var21_29;
                }
            }
            var1_1.getUndoManager().enableUndoManagement();
            return var22_28;
        }
        var20_27 = null;
        var1_1.getUndoManager().enableUndoManagement();
        var2_2.text = String.valueOf(var2_2.text) + var1_1.getLineDelimiter() + var3_3 + "*/";
        return var7_7;
    }

    private boolean isInsideExistingDocBlock(IStructuredDocument iStructuredDocument, int n) {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        while (iStructuredDocumentRegion != null) {
            String string = iStructuredDocumentRegion.getText();
            int n2 = string.length();
            if (n2 == 0) {
                iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
                continue;
            }
            char c = string.charAt(0);
            int n3 = 1;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c == '*' && c2 == '/') {
                    return true;
                }
                if (c == '/' && c2 == '*') {
                    return false;
                }
                c = c2;
                ++n3;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        return false;
    }

    private String getDocBlockStub(PHPEditorModel pHPEditorModel, IStructuredDocument iStructuredDocument, int n, String string) {
        PHPFileData pHPFileData = pHPEditorModel.getFileData();
        if (pHPFileData == null) {
            return null;
        }
        PHPCodeData pHPCodeData = this.getClosestCodeData(iStructuredDocument, pHPFileData, n);
        if (pHPCodeData == null) {
            return null;
        }
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc((CodeData)pHPCodeData, string, (IDocument)iStructuredDocument);
        return PHPDocBlockSerialezer.instance().createDocBlockText(iStructuredDocument, pHPDocBlock, n, false);
    }

    private PHPCodeData getClosestCodeData(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        int n2;
        int n3;
        int n4;
        PHPClassData pHPClassData = null;
        int n5 = iStructuredDocument.getLength();
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n6 = 0;
        while (n6 < pHPClassDataArray.length) {
            PHPClassData pHPClassData2 = pHPClassDataArray[n6];
            n4 = pHPClassData2.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPClassData2.getUserData().getEndPosition();
                if (n3 > n) {
                    return this.getClosestCodeDataFromClass(iStructuredDocument, pHPClassData2, n);
                }
            } else if (n4 < n5) {
                n5 = n4;
                pHPClassData = pHPClassData2;
            }
            ++n6;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n7 = 0;
        while (n7 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n7];
            n3 = pHPFunctionData.getUserData().getStartPosition();
            if (n3 < n) {
                n2 = pHPFunctionData.getUserData().getEndPosition();
                if (n2 > n) {
                    return null;
                }
            } else if (n3 < n5) {
                n5 = n3;
                pHPClassData = pHPFunctionData;
            }
            ++n7;
        }
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        n4 = 0;
        while (n4 < pHPConstantDataArray.length) {
            PHPConstantData pHPConstantData = pHPConstantDataArray[n4];
            n2 = pHPConstantData.getUserData().getStartPosition();
            if (n2 < n) {
                int n8 = pHPConstantData.getUserData().getEndPosition();
                if (n8 > n) {
                    return null;
                }
            } else if (n2 < n5) {
                n5 = n2;
                pHPClassData = pHPConstantData;
            }
            ++n4;
        }
        if (pHPClassData != null && this.isNoCodeBetween(iStructuredDocument, n, n5)) {
            return pHPClassData;
        }
        return null;
    }

    private PHPCodeData getClosestCodeDataFromClass(IStructuredDocument iStructuredDocument, PHPClassData pHPClassData, int n) {
        int n2;
        int n3;
        int n4;
        PHPFunctionData pHPFunctionData = null;
        int n5 = iStructuredDocument.getLength();
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        int n6 = 0;
        while (n6 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData2 = pHPFunctionDataArray[n6];
            n4 = pHPFunctionData2.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPFunctionData2.getUserData().getEndPosition();
                if (n3 > n) {
                    return null;
                }
            } else if (n4 < n5) {
                n5 = n4;
                pHPFunctionData = pHPFunctionData2;
            }
            ++n6;
        }
        PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
        int n7 = 0;
        while (n7 < pHPClassConstDataArray.length) {
            PHPClassConstData pHPClassConstData = pHPClassConstDataArray[n7];
            n3 = pHPClassConstData.getUserData().getStartPosition();
            if (n3 < n) {
                n2 = pHPClassConstData.getUserData().getEndPosition();
                if (n2 > n) {
                    return null;
                }
            } else if (n3 < n5) {
                n5 = n3;
                pHPFunctionData = pHPClassConstData;
            }
            ++n7;
        }
        PHPClassVarData[] pHPClassVarDataArray = pHPClassData.getVars();
        n4 = 0;
        while (n4 < pHPClassVarDataArray.length) {
            PHPClassVarData pHPClassVarData = pHPClassVarDataArray[n4];
            n2 = pHPClassVarData.getUserData().getStartPosition();
            if (n2 < n) {
                int n8 = pHPClassVarData.getUserData().getEndPosition();
                if (n8 > n) {
                    return null;
                }
            } else if (n2 < n5) {
                n5 = n2;
                pHPFunctionData = pHPClassVarData;
            }
            ++n4;
        }
        if (pHPFunctionData != null && this.isNoCodeBetween(iStructuredDocument, n, n5)) {
            return pHPFunctionData;
        }
        return null;
    }

    private boolean isNoCodeBetween(IStructuredDocument iStructuredDocument, int n, int n2) {
        int n3 = n;
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n3);
        while (iStructuredDocumentRegion != null && n3 < n2) {
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n3);
            String string = iTextRegion.getType();
            if (string == "PHP_LINE_COMMENT" || iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd() < n3) {
                n3 = iStructuredDocumentRegion.getStartOffset() + iTextRegion.getEnd() + 1;
                if (iStructuredDocumentRegion.getEndOffset() >= n3) continue;
                iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
                continue;
            }
            return false;
        }
        return true;
    }

    private class SelectText
    implements Runnable {
        int offset;
        int length;
        ITextEditor textEditor;

        public SelectText(int n, int n2, ITextEditor iTextEditor) {
            this.offset = n;
            this.length = n2;
            this.textEditor = iTextEditor;
        }

        public void run() {
            EditorUtility.revealInEditor((IEditorPart)this.textEditor, this.offset, this.length);
        }
    }
}

