/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.dialogs.openType.generic;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.php.ui.dialogs.openType.generic.ElementAddition;
import org.eclipse.php.ui.dialogs.openType.generic.ISorter;
import org.eclipse.php.ui.dialogs.openType.generic.filter.CompositeFilter;
import org.eclipse.php.ui.dialogs.openType.generic.filter.IFilter;
import org.eclipse.php.ui.dialogs.openType.generic.filter.IFilterChangeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HighLoadTableViewer
extends Composite {
    private TableViewer tableViewer;
    private Object[] elements = new Object[0];
    private Object[] sortedElements = this.elements;
    private Object[] tableElements = this.elements;
    private ISorter sorter = new ISorter(){

        public Object[] sort(Object[] objectArray) {
            return objectArray;
        }
    };
    private CompositeFilter compositeFilter = new CompositeFilter();
    private boolean defaultElementSelection = true;
    private ElementAddition elementAddition;

    public HighLoadTableViewer(Composite composite, int n) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer((Composite)this, n);
        this.compositeFilter.addFilterChangeListener(new IFilterChangeListener(){

            public void notifyFilterChanged() {
                HighLoadTableViewer.this.applyFilter2TableViewer();
            }
        });
    }

    public void setElements(Object[] objectArray) {
        this.elements = objectArray;
        this.sortedElements = this.sorter.sort(objectArray);
        this.tableElements = this.compositeFilter.filter(this.sortedElements);
        this.addElementsToTableInNewThread();
    }

    public void setSorter(ISorter iSorter) {
        this.sorter = iSorter;
        this.sortedElements = iSorter.sort(this.elements);
        this.tableElements = iSorter.sort(this.tableElements);
        this.addElementsToTableInNewThread();
    }

    public void addFilter(IFilter iFilter) {
        this.compositeFilter.addFilter(iFilter);
    }

    private void applyFilter2TableViewer() {
        this.tableElements = this.compositeFilter.filter(this.sortedElements);
        this.addElementsToTableInNewThread();
    }

    private void addElementsToTableInNewThread() {
        if (this.elementAddition == null) {
            this.elementAddition = new ElementAddition(this.tableViewer, this.defaultElementSelection);
            Thread thread = new Thread(this.elementAddition);
            thread.start();
        }
        this.elementAddition.setElements(this.tableElements);
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        this.tableViewer.setLabelProvider(iBaseLabelProvider);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public Object getElementAt(int n) {
        return this.tableViewer.getElementAt(n);
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.tableViewer.setSelection((ISelection)iStructuredSelection);
    }

    public Object[] getTableElements() {
        return this.tableElements;
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.tableViewer.addDoubleClickListener(iDoubleClickListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void setDefaultElementSelection(boolean bl) {
        this.defaultElementSelection = bl;
    }

    public void close() {
        this.stopTableUpdater();
    }

    private void stopTableUpdater() {
        this.elementAddition.stop();
    }
}

