/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.actions.BuildActionGroup;
import org.eclipse.php.internal.ui.actions.CCPActionGroup;
import org.eclipse.php.internal.ui.actions.ImportActionGroup;
import org.eclipse.php.internal.ui.actions.NavigateActionGroup;
import org.eclipse.php.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.php.internal.ui.actions.ProjectActionGroup;
import org.eclipse.php.internal.ui.actions.RefactorActionGroup;
import org.eclipse.php.ui.actions.CompositeActionGroup;
import org.eclipse.php.ui.actions.CustomFiltersActionGroup;
import org.eclipse.php.ui.explorer.CollapseAllAction;
import org.eclipse.php.ui.explorer.ExplorerFrameSource;
import org.eclipse.php.ui.explorer.ExplorerPart;
import org.eclipse.php.ui.explorer.ToggleLinkingAction;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.workingset.ExplorerViewActionGroup;
import org.eclipse.php.ui.workingset.WorkingSetModel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.UpAction;

public class ExplorerActionGroup
extends CompositeActionGroup {
    private ExplorerPart fPart;
    private CollapseAllAction fCollapseAllAction;
    private GoIntoAction fZoomInAction;
    private BackAction fBackAction;
    private ForwardAction fForwardAction;
    private UpAction fUpAction;
    private FrameList fFrameList;
    private ToggleLinkingAction fToggleLinkingAction;
    private RefactorActionGroup fRefactorActionGroup;
    private NavigateActionGroup fNavigateActionGroup;
    private ExplorerViewActionGroup fViewActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;

    public ExplorerActionGroup(ExplorerPart explorerPart) {
        this.fPart = explorerPart;
        TreeViewer treeViewer = explorerPart.getViewer();
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExplorerActionGroup.this.doWorkingSetChanged(propertyChangeEvent);
            }
        };
        IWorkbenchPartSite iWorkbenchPartSite = this.fPart.getSite();
        ActionGroup[] actionGroupArray = new ActionGroup[9];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)iWorkbenchPartSite);
        this.fNavigateActionGroup = new NavigateActionGroup((IViewPart)this.fPart);
        actionGroupArray[1] = this.fNavigateActionGroup;
        actionGroupArray[2] = new CCPActionGroup((IViewPart)this.fPart);
        this.fRefactorActionGroup = new RefactorActionGroup((IViewPart)this.fPart);
        actionGroupArray[3] = this.fRefactorActionGroup;
        actionGroupArray[4] = new ImportActionGroup((IViewPart)this.fPart);
        actionGroupArray[5] = new BuildActionGroup((IViewPart)this.fPart);
        actionGroupArray[6] = new ProjectActionGroup((IViewPart)this.fPart);
        this.fViewActionGroup = new ExplorerViewActionGroup(this.fPart.getRootMode(), iPropertyChangeListener, iWorkbenchPartSite);
        actionGroupArray[7] = this.fViewActionGroup;
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this.fPart, (StructuredViewer)treeViewer);
        actionGroupArray[8] = this.fCustomFiltersActionGroup;
        this.setGroups(actionGroupArray);
        this.fViewActionGroup.fillFilters((StructuredViewer)treeViewer);
        ExplorerFrameSource explorerFrameSource = new ExplorerFrameSource(this.fPart);
        this.fFrameList = new FrameList((IFrameSource)explorerFrameSource);
        explorerFrameSource.connectTo(this.fFrameList);
        this.fZoomInAction = new GoIntoAction(this.fFrameList);
        this.fBackAction = new BackAction(this.fFrameList);
        this.fForwardAction = new ForwardAction(this.fFrameList);
        this.fUpAction = new UpAction(this.fFrameList);
        this.fCollapseAllAction = new CollapseAllAction(this.fPart);
        this.fToggleLinkingAction = new ToggleLinkingAction(this.fPart);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
        this.fillToolBar(iActionBars.getToolBarManager());
        this.fillViewMenu(iActionBars.getMenuManager());
    }

    void updateActionBars(IActionBars iActionBars) {
        iActionBars.getToolBarManager().removeAll();
        iActionBars.getMenuManager().removeAll();
        this.fZoomInAction.setEnabled(true);
        this.fillActionBars(iActionBars);
        iActionBars.updateActionBars();
    }

    private void addGotoMenu(IMenuManager iMenuManager, Object object, int n) {
        boolean bl = n == 1 && this.fPart.getViewer().isExpandable(object) && (this.isGoIntoTarget(object) || object instanceof IContainer);
        this.fZoomInAction.setEnabled(bl);
        if (bl) {
            iMenuManager.appendToGroup("group.goto", (IAction)this.fZoomInAction);
        }
    }

    private boolean isGoIntoTarget(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof PHPProjectModel || object instanceof IFolder;
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.fZoomInAction);
        iActionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        iActionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        this.fRefactorActionGroup.retargetFileMenuActions(iActionBars);
    }

    void fillToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.fBackAction);
        iToolBarManager.add((IAction)this.fForwardAction);
        iToolBarManager.add((IAction)this.fUpAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.fCollapseAllAction);
        iToolBarManager.add((IAction)this.fToggleLinkingAction);
    }

    void fillViewMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.fToggleLinkingAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        iStructuredSelection.size();
        Object object = iStructuredSelection.getFirstElement();
        this.addOpenNewWindowAction(iMenuManager, object);
        super.fillContextMenu(iMenuManager);
    }

    private void addOpenNewWindowAction(IMenuManager iMenuManager, Object object) {
        if (object instanceof PHPCodeData || object instanceof PHPProjectModel) {
            object = PHPModelUtil.getResource((Object)object);
        }
        if (object instanceof IProject && !((IProject)object).isOpen()) {
            return;
        }
        if (!(object instanceof IContainer)) {
            return;
        }
        iMenuManager.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.fPart.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        Object object;
        TreeViewer treeViewer = this.fPart.getViewer();
        if (treeViewer.isExpandable(object = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement())) {
            if (this.doubleClickGoesInto()) {
                if (object instanceof PHPFileData) {
                    return;
                }
                if (object instanceof IContainer) {
                    this.fZoomInAction.run();
                }
            } else {
                IAction iAction = this.fNavigateActionGroup.getOpenAction();
                if (iAction != null && iAction.isEnabled() && OpenStrategy.getOpenMethod() == 0) {
                    return;
                }
                treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
            }
        }
    }

    void handleOpen(OpenEvent openEvent) {
        IAction iAction = this.fNavigateActionGroup.getOpenAction();
        if (iAction != null && iAction.isEnabled()) {
            iAction.run();
            return;
        }
    }

    void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.stateMask != 0) {
            return;
        }
        if (keyEvent.keyCode == 8 && this.fUpAction != null && this.fUpAction.isEnabled()) {
            this.fUpAction.run();
            keyEvent.doit = false;
        }
    }

    private boolean doubleClickGoesInto() {
        return "phpviewGointo".equals(PreferenceConstants.getPreferenceStore().getString("phpviewDoubleclick"));
    }

    public FrameAction getUpAction() {
        return this.fUpAction;
    }

    public FrameAction getBackAction() {
        return this.fBackAction;
    }

    public FrameAction getForwardAction() {
        return this.fForwardAction;
    }

    public ExplorerViewActionGroup getWorkingSetActionGroup() {
        return this.fViewActionGroup;
    }

    private void doWorkingSetChanged(PropertyChangeEvent propertyChangeEvent) {
        if (ExplorerViewActionGroup.MODE_CHANGED.equals(propertyChangeEvent.getProperty())) {
            this.fPart.rootModeChanged((Integer)propertyChangeEvent.getNewValue());
            WorkingSetModel workingSetModel = null;
            Object object = null;
            if (this.fPart.showProjects()) {
                workingSetModel = this.fPart.getWorkingSetModel();
                object = PHPWorkspaceModelManager.getInstance();
            } else if (this.fPart.showWorkingSets()) {
                workingSetModel = PHPWorkspaceModelManager.getInstance();
                object = this.fPart.getWorkingSetModel();
            }
            if (workingSetModel != null && object != null) {
                Frame frame;
                int n = 0;
                while ((frame = this.fFrameList.getFrame(n)) != null) {
                    TreeFrame treeFrame;
                    if (frame instanceof TreeFrame && workingSetModel.equals((treeFrame = (TreeFrame)frame).getInput())) {
                        treeFrame.setInput(object);
                    }
                    ++n;
                }
            }
        } else {
            IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
            String string = null;
            if (iWorkingSet != null) {
                string = iWorkingSet.getName();
            }
            this.fPart.setWorkingSetName(string);
            this.fPart.updateTitle();
            String string2 = propertyChangeEvent.getProperty();
            if ("workingSetContentChange".equals(string2)) {
                TreeViewer treeViewer = this.fPart.getViewer();
                treeViewer.getControl().setRedraw(false);
                treeViewer.refresh();
                treeViewer.getControl().setRedraw(true);
            }
        }
    }

    void restoreFilterAndSorterState(IMemento iMemento) {
        this.fViewActionGroup.restoreState(iMemento);
        this.fCustomFiltersActionGroup.restoreState(iMemento);
    }

    void saveFilterAndSorterState(IMemento iMemento) {
        this.fViewActionGroup.saveState(iMemento);
        this.fCustomFiltersActionGroup.saveState(iMemento);
    }
}

