/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class ApachePlugin
extends Plugin {
    protected static ApachePlugin singleton;
    public static final String PLUGIN_ID = "org.eclipse.php.server.apache.core";
    public static final String PROJECT_NAME = "project_name";
    public static final String FILE_NAME = "file_name";
    public static final String PORT = "port";
    public static final String CONTEXT_ROOT = "context_root";
    public static final String DEPLOYABLE = "deployable";
    public static final String URL = "url";
    public static final String APACHE_13 = "org.eclipse.php.server.apache.13";
    public static final String APACHE_20 = "org.eclipse.php.server.apache.20";
    public static final String ATTR_STOP = "stop-server";
    public static final String ATTR_START = "org.eclipse.php.server.apache.corestart-server";
    protected static final String VERIFY_INSTALL_FILE = "verifyInstall.properties";
    protected static String[] verify13;
    protected static String[] verify20;

    public ApachePlugin() {
        singleton = this;
    }

    public static ApachePlugin getInstance() {
        return singleton;
    }

    public static String getPreference(String string) {
        return ApachePlugin.getInstance().getPluginPreferences().getString(string);
    }

    public static void setPreference(String string, String string2) {
        ApachePlugin.getInstance().getPluginPreferences().setValue(string, string2);
        ApachePlugin.getInstance().savePluginPreferences();
    }

    public static void log(IStatus iStatus) {
        ApachePlugin.getInstance().getLog().log(iStatus);
    }

    protected static String getApacheStateLocation() {
        try {
            return ApachePlugin.getInstance().getStateLocation().toOSString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean verifyInstallPath(IPath iPath, String string) {
        if (iPath == null) {
            return false;
        }
        String string2 = iPath.toOSString();
        if (!string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        return true;
    }

    public static boolean verifyApacheVersionFromPath(IPath iPath, String string) {
        if (iPath == null || string == null) {
            return false;
        }
        String string2 = iPath.lastSegment();
        if (string2.indexOf("-1.3") > 0 || string2.indexOf(" 1.3") > 0) {
            return APACHE_13.equals(string);
        }
        if (string2.indexOf("-2.0") > 0 || string2.indexOf(" 2.0") > 0) {
            return APACHE_20.equals(string);
        }
        return true;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
    }

    protected static File getPlugin() {
        try {
            URL uRL = ApachePlugin.getInstance().getBundle().getEntry("/");
            URL uRL2 = Platform.asLocalURL((URL)uRL);
            return new File(uRL2.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void log(String string) {
        ApachePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, string, null));
    }

    public static void log(Throwable throwable) {
        ApachePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, throwable.getMessage(), throwable));
    }
}

