/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.server.apache.core.Trace;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class ApacheRuntimeLocator
extends RuntimeLocatorDelegate {
    protected static final String[] runtimeTypes = new String[]{"org.eclipse.php.server.apache.runtime.13", "org.eclipse.php.server.apache.runtime.20"};

    public void searchForRuntimes(IPath iPath, RuntimeLocatorDelegate.IRuntimeSearchListener iRuntimeSearchListener, IProgressMonitor iProgressMonitor) {
        ApacheRuntimeLocator.searchForRuntimes2(iPath, iRuntimeSearchListener, iProgressMonitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void searchForRuntimes2(IPath iPath, RuntimeLocatorDelegate.IRuntimeSearchListener iRuntimeSearchListener, IProgressMonitor iProgressMonitor) {
        File[] fileArray = null;
        if (iPath != null) {
            File file = iPath.toFile();
            if (!file.exists()) return;
            fileArray = file.listFiles();
        } else {
            fileArray = File.listRoots();
        }
        if (fileArray != null) {
            int n = fileArray.length;
            int n2 = 100 / n;
            int n3 = 100 - n2 * n;
            int n4 = 0;
            while (n4 < n) {
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                if (fileArray[n4] != null && fileArray[n4].isDirectory()) {
                    ApacheRuntimeLocator.searchDir(iRuntimeSearchListener, fileArray[n4], 4, iProgressMonitor);
                }
                iProgressMonitor.worked(n2);
                ++n4;
            }
            iProgressMonitor.worked(n3);
            return;
        } else {
            iProgressMonitor.worked(100);
        }
    }

    protected static void searchDir(RuntimeLocatorDelegate.IRuntimeSearchListener iRuntimeSearchListener, File file, int n, IProgressMonitor iProgressMonitor) {
        File[] fileArray;
        if ("conf".equals(file.getName()) && (fileArray = ApacheRuntimeLocator.getRuntimeFromDir(file.getParentFile(), iProgressMonitor)) != null) {
            iRuntimeSearchListener.runtimeFound((IRuntimeWorkingCopy)fileArray);
            return;
        }
        if (n == 0) {
            return;
        }
        fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray != null) {
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                ApacheRuntimeLocator.searchDir(iRuntimeSearchListener, fileArray[n3], n - 1, iProgressMonitor);
                ++n3;
            }
        }
    }

    protected static IRuntimeWorkingCopy getRuntimeFromDir(File file, IProgressMonitor iProgressMonitor) {
        int n = 0;
        while (n < runtimeTypes.length) {
            try {
                IRuntimeType iRuntimeType = ServerCore.findRuntimeType((String)runtimeTypes[n]);
                String string = file.getAbsolutePath();
                String string2 = string.replace(File.separatorChar, '_').replace(':', '-');
                IRuntimeWorkingCopy iRuntimeWorkingCopy = iRuntimeType.createRuntime(string2, iProgressMonitor);
                iRuntimeWorkingCopy.setName(file.getName());
                iRuntimeWorkingCopy.setLocation((IPath)new Path(string));
                IStatus iStatus = iRuntimeWorkingCopy.validate(iProgressMonitor);
                if (iStatus == null || iStatus.getSeverity() != 4) {
                    return iRuntimeWorkingCopy;
                }
                Trace.trace(Trace.FINER, "False runtime found at " + file.getAbsolutePath() + ": " + iStatus.getMessage());
            }
            catch (Exception exception) {
                Trace.trace(Trace.SEVERE, "Could not find runtime", exception);
            }
            ++n;
        }
        return null;
    }
}

