/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.php.server.apache.core.ApacheServerBehaviour;
import org.eclipse.php.server.apache.core.Trace;
import org.eclipse.wst.server.core.IServer;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings = 56;
    private boolean stop = false;
    private String url;
    private IServer server;
    private ApacheServerBehaviour behaviour;

    public PingThread(IServer iServer, String string, int n, ApacheServerBehaviour apacheServerBehaviour) {
        this.server = iServer;
        this.url = string;
        this.maxPings = n;
        this.behaviour = apacheServerBehaviour;
        Thread thread = new Thread(){

            public void run() {
                PingThread.this.ping();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected void ping() {
        int n = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (n == this.maxPings) {
                    try {
                        this.server.stop(false);
                    }
                    catch (Exception exception) {
                        Trace.trace(Trace.FINEST, "Ping: could not stop server");
                    }
                    this.stop = true;
                    break;
                }
                ++n;
                Trace.trace(Trace.FINEST, "Ping: pinging");
                URL uRL = new URL(this.url);
                URLConnection uRLConnection = uRL.openConnection();
                ((HttpURLConnection)uRLConnection).getResponseCode();
                if (!this.stop) {
                    Trace.trace(Trace.FINEST, "Ping: success");
                    Thread.sleep(200L);
                    this.behaviour.setServerStarted();
                }
                this.stop = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
                this.behaviour.setServerStarted();
                this.stop = true;
            }
            catch (Exception exception) {
                Trace.trace(Trace.FINEST, "Ping: failed");
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        Trace.trace(Trace.FINEST, "Ping: stopping");
        this.stop = true;
    }
}

