/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.debugger.DefaultExpression;
import org.eclipse.php.debug.core.debugger.DefaultExpressionsManager;
import org.eclipse.php.debug.core.debugger.Expression;
import org.eclipse.php.debug.core.model.PHPDebugElement;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.core.model.PHPValue;

public class PHPVariable
extends PHPDebugElement
implements IVariable {
    private Expression variable;
    private PHPValue pValue;
    private boolean hasChanged = false;
    private boolean global = false;

    public PHPVariable(PHPDebugTarget pHPDebugTarget, Expression expression) {
        super(pHPDebugTarget);
        this.variable = expression;
        this.global = false;
        this.pValue = new PHPValue(pHPDebugTarget, this.variable);
    }

    public PHPVariable(PHPDebugTarget pHPDebugTarget, Expression expression, boolean bl) {
        super(pHPDebugTarget);
        this.variable = expression;
        this.global = bl;
        this.pValue = new PHPValue(pHPDebugTarget, this.variable, bl);
    }

    public IValue getValue() throws DebugException {
        this.hasChanged = false;
        return this.pValue;
    }

    public String getName() throws DebugException {
        return this.variable.getLastName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.pValue.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.hasChanged;
    }

    public void setValue(String string) throws DebugException {
        boolean bl;
        PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)this.getDebugTarget();
        DefaultExpressionsManager defaultExpressionsManager = pHPDebugTarget.getExpressionManager();
        Expression expression = this.variable;
        if (this.global) {
            String string2 = "$GLOBALS[\"" + this.variable.getFullName().substring(1) + "\"]";
            expression = new DefaultExpression(string2);
        }
        if (!(bl = defaultExpressionsManager.assignValue(expression, string, 1))) {
            Logger.debugMSG("[" + (Object)((Object)this) + "] PHPValue: Problem changing variable value");
        }
        defaultExpressionsManager.update(expression, 1);
        this.pValue.updateValue(expression.getValue());
        this.fireChangeEvent(512);
    }

    public void setValue(IValue iValue) throws DebugException {
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String string) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue iValue) throws DebugException {
        return true;
    }
}

