/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.Logger;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class DocBlockAutoEditStrategy
implements IAutoEditStrategy {
    private static final String lineStart = "* ";

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (TypingPreferences.closePhpdoc && documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoEditAfterNewLine((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoEditAfterNewLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        try {
            Matcher matcher;
            IRegion iRegion = iStructuredDocument.getLineInformationOfOffset(documentCommand.offset);
            int n = iRegion.getOffset();
            String string = iStructuredDocument.get(n, iRegion.getLength());
            String string2 = this.getBlanks(string);
            String string3 = string.trim();
            boolean bl = false;
            boolean bl2 = true;
            int n2 = string3.indexOf("/*");
            if (n2 != -1) {
                if (documentCommand.offset + documentCommand.length < n + n2 + 2) {
                    return;
                }
                bl = true;
                if (string3.indexOf("/**") != n2) {
                    bl2 = false;
                }
            }
            if ((matcher = Pattern.compile("/\\*.*\\*/").matcher(string3)).find()) {
                return;
            }
            if (bl) {
                int n3;
                string2 = String.valueOf(string2) + ' ';
                documentCommand.text = String.valueOf(documentCommand.text) + string2;
                int n4 = string.indexOf("/*");
                String string4 = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + n4 - 1));
                if ((string4 == "org.eclipse.php.PHP_DEFAULT" || string4 == "org.eclipse.php.PHP_DOC" || string4 == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (n3 = this.handleDocBlockStart(iStructuredDocument, documentCommand, string2, bl2)) != -1) {
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    documentCommand.offset = n3;
                    documentCommand.length = 0;
                    documentCommand.text = "";
                    iStructuredDocument.getUndoManager().disableUndoManagement();
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    iStructuredDocument.getUndoManager().enableUndoManagement();
                }
                return;
            }
            boolean bl3 = iStructuredDocument.get(n, documentCommand.offset - n).endsWith("*/");
            if (!bl3 && string3.length() > 0 && string3.charAt(0) == '*') {
                documentCommand.text = String.valueOf(documentCommand.text) + string2 + lineStart;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private String getBlanks(String string) {
        int n = string.indexOf("/*");
        if (n < 0) {
            n = string.indexOf("*");
        }
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) == '\t') {
                    stringBuffer.append('\t');
                } else {
                    stringBuffer.append(' ');
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return " ";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int handleDocBlockStart(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, String string, boolean bl) {
        int n = 0;
        try {
            try {
                String string2;
                int n2;
                int n3;
                block17: {
                    block16: {
                        block18: {
                            block13: {
                                IEditorPart iEditorPart;
                                String string3;
                                int n4;
                                String string4;
                                String string5;
                                IRegion iRegion;
                                block15: {
                                    iRegion = iStructuredDocument.getLineInformationOfOffset(documentCommand.offset);
                                    n3 = iRegion.getOffset();
                                    string5 = iStructuredDocument.get(n3, documentCommand.offset - n3);
                                    Matcher matcher = Pattern.compile("\\/\\*+").matcher(string5);
                                    matcher.find();
                                    string4 = string5.substring(matcher.start(), matcher.end());
                                    n2 = string4.length();
                                    documentCommand.text = String.valueOf(documentCommand.text) + lineStart;
                                    n = documentCommand.offset + documentCommand.text.length();
                                    n4 = documentCommand.offset + documentCommand.length;
                                    if (!this.isInsideExistingDocBlock(iStructuredDocument, n4)) break block15;
                                    break block13;
                                }
                                string2 = string5.substring(string5.indexOf(string4) + n2).trim();
                                n = (n3 += string5.indexOf(string4)) + n2 + documentCommand.text.length();
                                int n5 = n4;
                                if (n4 < iRegion.getOffset() + iRegion.getLength() && (string3 = iStructuredDocument.get(n4, (iRegion = iStructuredDocument.getLineInformationOfOffset(n4)).getOffset() + iRegion.getLength() - n4)).length() > 0) {
                                    int n6 = 0;
                                    char c = string3.charAt(0);
                                    n6 = 0;
                                    while (true) {
                                        if (n6 >= string3.length() || !Character.isWhitespace(c) || c == '\n') {
                                            n5 += n6;
                                            break;
                                        }
                                        c = string3.charAt(n6);
                                        ++documentCommand.length;
                                        ++n6;
                                    }
                                }
                                if (!bl || !TypingPreferences.addDocTags) break block16;
                                iStructuredDocument.getUndoManager().disableUndoManagement();
                                iStructuredDocument.replace(n3, n5 - n3, "");
                                iStructuredDocument.getUndoManager().enableUndoManagement();
                                documentCommand.offset = n3;
                                string3 = (PHPEditorModel)StructuredModelManager.getModelManager().getModelForRead(iStructuredDocument);
                                string3.updateFileData();
                                if (string2.equals("")) {
                                    string2 = null;
                                }
                                String string6 = this.getDocBlockStub((PHPEditorModel)string3, iStructuredDocument, n3, string2);
                                documentCommand.offset += string4.length();
                                iStructuredDocument.getUndoManager().disableUndoManagement();
                                iStructuredDocument.replace(n3, 0, string4);
                                iStructuredDocument.getUndoManager().enableUndoManagement();
                                if (string6 == null) break block17;
                                documentCommand.text = string6.substring(3);
                                if (string2 != null) break block18;
                                String string7 = string3.getFileData().getName();
                                IFile iFile = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string7));
                                try {
                                    iEditorPart = EditorUtility.openInEditor(iFile, true);
                                }
                                catch (PartInitException partInitException) {
                                    Logger.logException(partInitException);
                                    documentCommand.text = String.valueOf(string4) + documentCommand.text;
                                    break block13;
                                }
                                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                                Display.getDefault().asyncExec((Runnable)new SelectText(documentCommand.offset + documentCommand.text.indexOf("E"), 25, iTextEditor));
                            }
                            Object var21_14 = null;
                            iStructuredDocument.getUndoManager().enableUndoManagement();
                            return -1;
                        }
                        int n7 = n + string2.length();
                        Object var21_15 = null;
                        iStructuredDocument.getUndoManager().enableUndoManagement();
                        return n7;
                    }
                    documentCommand.length += documentCommand.offset - n3 - n2;
                    documentCommand.offset = n3 + n2;
                }
                n3 += n2;
                if (string2 != null && !string2.equals("")) {
                    documentCommand.text = String.valueOf(documentCommand.text) + string2;
                    n = n3 + documentCommand.text.length();
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
            Object var21_17 = null;
        }
        catch (Throwable throwable) {
            Object var21_16 = null;
            iStructuredDocument.getUndoManager().enableUndoManagement();
            throw throwable;
        }
        iStructuredDocument.getUndoManager().enableUndoManagement();
        documentCommand.text = String.valueOf(documentCommand.text) + iStructuredDocument.getLineDelimiter() + string + "*/";
        return n;
    }

    private boolean isInsideExistingDocBlock(IStructuredDocument iStructuredDocument, int n) {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        boolean bl = true;
        while (iStructuredDocumentRegion != null) {
            int n2;
            String string = iStructuredDocumentRegion.getText();
            if (bl) {
                bl = false;
                string = string.substring(n - iStructuredDocumentRegion.getStartOffset());
            }
            if ((n2 = string.length()) == 0) {
                iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
                continue;
            }
            char c = string.charAt(0);
            int n3 = 1;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c == '*' && c2 == '/') {
                    return true;
                }
                if (c == '/' && c2 == '*') {
                    return false;
                }
                c = c2;
                ++n3;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        return false;
    }

    private String getDocBlockStub(PHPEditorModel pHPEditorModel, IStructuredDocument iStructuredDocument, int n, String string) {
        PHPFileData pHPFileData = pHPEditorModel.getFileData();
        if (pHPFileData == null) {
            return null;
        }
        PHPCodeData pHPCodeData = this.getClosestCodeData(iStructuredDocument, pHPFileData, n);
        if (pHPCodeData == null) {
            return null;
        }
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc((CodeData)pHPCodeData, string, (IDocument)iStructuredDocument);
        return PHPDocBlockSerialezer.instance().createDocBlockText(iStructuredDocument, pHPDocBlock, n, false);
    }

    private PHPCodeData getClosestCodeData(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        int n2;
        int n3;
        int n4;
        PHPClassData pHPClassData = null;
        int n5 = iStructuredDocument.getLength();
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n6 = 0;
        while (n6 < pHPClassDataArray.length) {
            PHPClassData pHPClassData2 = pHPClassDataArray[n6];
            n4 = pHPClassData2.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPClassData2.getUserData().getEndPosition();
                if (n3 > n) {
                    return this.getClosestCodeDataFromClass(iStructuredDocument, pHPClassData2, n);
                }
            } else if (n4 < n5) {
                n5 = n4;
                pHPClassData = pHPClassData2;
            }
            ++n6;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n7 = 0;
        while (n7 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n7];
            n3 = pHPFunctionData.getUserData().getStartPosition();
            if (n3 < n) {
                n2 = pHPFunctionData.getUserData().getEndPosition();
                if (n2 > n) {
                    return null;
                }
            } else if (n3 < n5) {
                n5 = n3;
                pHPClassData = pHPFunctionData;
            }
            ++n7;
        }
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        n4 = 0;
        while (n4 < pHPConstantDataArray.length) {
            PHPConstantData pHPConstantData = pHPConstantDataArray[n4];
            n2 = pHPConstantData.getUserData().getStartPosition();
            if (n2 < n) {
                int n8 = pHPConstantData.getUserData().getEndPosition();
                if (n8 > n) {
                    return null;
                }
            } else if (n2 < n5) {
                n5 = n2;
                pHPClassData = pHPConstantData;
            }
            ++n4;
        }
        if (pHPClassData != null && this.isNoCodeBetween(iStructuredDocument, n, n5)) {
            return pHPClassData;
        }
        return null;
    }

    private PHPCodeData getClosestCodeDataFromClass(IStructuredDocument iStructuredDocument, PHPClassData pHPClassData, int n) {
        int n2;
        int n3;
        int n4;
        PHPFunctionData pHPFunctionData = null;
        int n5 = iStructuredDocument.getLength();
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        int n6 = 0;
        while (n6 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData2 = pHPFunctionDataArray[n6];
            n4 = pHPFunctionData2.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPFunctionData2.getUserData().getEndPosition();
                if (n3 > n) {
                    return null;
                }
            } else if (n4 < n5) {
                n5 = n4;
                pHPFunctionData = pHPFunctionData2;
            }
            ++n6;
        }
        PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
        int n7 = 0;
        while (n7 < pHPClassConstDataArray.length) {
            PHPClassConstData pHPClassConstData = pHPClassConstDataArray[n7];
            n3 = pHPClassConstData.getUserData().getStartPosition();
            if (n3 < n) {
                n2 = pHPClassConstData.getUserData().getEndPosition();
                if (n2 > n) {
                    return null;
                }
            } else if (n3 < n5) {
                n5 = n3;
                pHPFunctionData = pHPClassConstData;
            }
            ++n7;
        }
        PHPClassVarData[] pHPClassVarDataArray = pHPClassData.getVars();
        n4 = 0;
        while (n4 < pHPClassVarDataArray.length) {
            PHPClassVarData pHPClassVarData = pHPClassVarDataArray[n4];
            n2 = pHPClassVarData.getUserData().getStartPosition();
            if (n2 < n) {
                int n8 = pHPClassVarData.getUserData().getEndPosition();
                if (n8 > n) {
                    return null;
                }
            } else if (n2 < n5) {
                n5 = n2;
                pHPFunctionData = pHPClassVarData;
            }
            ++n4;
        }
        if (pHPFunctionData != null && this.isNoCodeBetween(iStructuredDocument, n, n5)) {
            return pHPFunctionData;
        }
        return null;
    }

    private boolean isNoCodeBetween(IStructuredDocument iStructuredDocument, int n, int n2) {
        int n3 = n;
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n3);
        while (iStructuredDocumentRegion != null && n3 < n2) {
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n3);
            String string = iTextRegion.getType();
            if (string == "PHP_LINE_COMMENT" || iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd() < n3) {
                n3 = iStructuredDocumentRegion.getStartOffset() + iTextRegion.getEnd() + 1;
                if (iStructuredDocumentRegion.getEndOffset() >= n3) continue;
                iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
                continue;
            }
            return false;
        }
        return true;
    }

    private class SelectText
    implements Runnable {
        int offset;
        int length;
        ITextEditor textEditor;

        public SelectText(int n, int n2, ITextEditor iTextEditor) {
            this.offset = n;
            this.length = n2;
            this.textEditor = iTextEditor;
        }

        public void run() {
            EditorUtility.revealInEditor((IEditorPart)this.textEditor, this.offset, this.length);
        }
    }
}

