/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.php.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.editor.WorkspaceFileHyperlink;
import org.eclipse.php.internal.ui.util.CodeDataResolver;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.editor.hover.PHPCodeHyperLink;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;

public class PHPCodeHyperlinkDetector
implements IHyperlinkDetector {
    private static final Pattern QUOTES_PATTERN = Pattern.compile("^[\"']|[\"']$");
    private StructuredTextPartitioner fTextPartitioner = new PHPStructuredTextPartitioner();

    private boolean isIncludeType(String string) {
        return "PHP_INCLUDE".equals(string) || "PHP_INCLUDE_ONCE".equals(string) || "PHP_REQUIRE".equals(string) || "PHP_REQUIRE_ONCE".equals(string);
    }

    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, IRegion iRegion, boolean bl) {
        if (iRegion == null || bl) {
            return null;
        }
        try {
            IDocument iDocument = iTextViewer.getDocument();
            if (iDocument instanceof IStructuredDocument) {
                CodeData codeData;
                IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
                IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(iRegion.getOffset());
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iRegion.getOffset());
                if ("org.eclipse.php.PHP_QUOTED_STRING".equals(this.fTextPartitioner.getPartitionType(iTextRegion, iRegion.getOffset()))) {
                    ITextRegion iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset() + iTextRegion.getStart() - 1);
                    if (iTextRegion2 != null && (iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset() + iTextRegion2.getStart() - 1)) != null && this.isIncludeType(iTextRegion2.getType())) {
                        Object object;
                        IFile iFile;
                        IProject iProject;
                        IFile iFile2;
                        IWorkspace iWorkspace;
                        String string = iStructuredDocumentRegion.getText(iTextRegion);
                        Matcher matcher = QUOTES_PATTERN.matcher(string);
                        string = matcher.replaceAll("");
                        Path path = new Path(string);
                        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
                        if (iWorkbenchPage != null && (iWorkspace = iWorkbenchPage.getActiveEditor()) != null && iWorkspace instanceof PHPStructuredEditor && (iFile2 = (iProject = (iFile = ((PHPStructuredEditor)((Object)(object = (PHPStructuredEditor)iWorkspace))).getFile()).getProject()).getFile((IPath)path)) != null && iFile2.exists()) {
                            return new IHyperlink[]{new WorkspaceFileHyperlink((IRegion)new Region(iStructuredDocumentRegion.getStartOffset(iTextRegion), iTextRegion.getTextLength()), iFile2)};
                        }
                        iWorkspace = ResourcesPlugin.getWorkspace();
                        object = iWorkspace.getRoot();
                        iFile = object.getProjects();
                        int n = 0;
                        while (n < ((IFile)iFile).length) {
                            iFile2 = iFile[n].getFile((IPath)path);
                            if (iFile2 != null && iFile2.exists()) {
                                return new IHyperlink[]{new WorkspaceFileHyperlink((IRegion)new Region(iStructuredDocumentRegion.getStartOffset(iTextRegion), iTextRegion.getTextLength()), iFile2)};
                            }
                            ++n;
                        }
                    }
                } else if (iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd() >= iRegion.getOffset() && (codeData = CodeDataResolver.getCodeData(iTextViewer, iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd())) != null && codeData.isUserCode()) {
                    return new IHyperlink[]{new PHPCodeHyperLink(this.selectWord(iDocument, iRegion.getOffset()), codeData)};
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private IRegion selectWord(IDocument iDocument, int n) {
        try {
            char c;
            int n2 = n;
            while (n2 >= 0) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                --n2;
            }
            int n3 = n2;
            n2 = n;
            int n4 = iDocument.getLength();
            while (n2 < n4) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++n2;
            }
            int n5 = n2;
            if (n3 == n5) {
                return new Region(n3, 0);
            }
            return new Region(n3 + 1, n5 - n3 - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

