/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.dialogs.saveFiles;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.util.ListContentProvider;
import org.eclipse.php.ui.dialogs.saveFiles.SaveFilesHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListDialog;

public class SaveFilesDialog
extends ListDialog {
    boolean promptAutoSave;
    SaveFilesHandler.SaveFilesResult result;

    public SaveFilesDialog(Shell shell, SaveFilesHandler.SaveFilesResult saveFilesResult, boolean bl) {
        super(shell);
        this.promptAutoSave = bl;
        this.result = saveFilesResult;
        this.setTitle("Save All Modified Resources");
        this.setAddCancelButton(true);
        this.setLabelProvider(this.createDialogLabelProvider());
        this.setMessage("All modified resources must be saved before this operation.");
        this.setContentProvider(new ListContentProvider());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.promptAutoSave) {
            final Button button = new Button(composite2, 32);
            button.setText("&Save all modified resources automatically");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SaveFilesDialog.this.result.setAutoSave(button.getSelection());
                }
            });
            SaveFilesDialog.applyDialogFont((Control)composite2);
        }
        return composite2;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object object) {
                return ((IEditorPart)object).getTitleImage();
            }

            public String getText(Object object) {
                return ((IEditorPart)object).getTitle();
            }
        };
    }
}

