/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.dialogs.saveFiles;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.ui.dialogs.saveFiles.SaveFilesDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SaveFilesHandler {
    public static SaveFilesResult handle(IProject iProject, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) {
        SaveFilesResult saveFilesResult = new SaveFilesResult();
        IEditorPart[] iEditorPartArray = SaveFilesHandler.getDirtyEditors(iProject);
        if (iEditorPartArray == null || iEditorPartArray.length == 0) {
            saveFilesResult.setSaved(true);
            return saveFilesResult;
        }
        if (!bl) {
            Display.getDefault().syncExec((Runnable)new SaveFilesDialogRunnable(iEditorPartArray, saveFilesResult, bl2));
        } else {
            saveFilesResult.setSaved(true);
        }
        if (saveFilesResult.isSaved()) {
            Display.getDefault().syncExec((Runnable)new SaveFilesRunnable(iEditorPartArray, iProgressMonitor));
        }
        if (iProgressMonitor.isCanceled()) {
            saveFilesResult.setSaved(false);
        }
        return saveFilesResult;
    }

    public static IEditorPart[] getDirtyEditors(IProject iProject) {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IFileEditorInput iFileEditorInput;
                    IFile iFile;
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)iEditorInput).getFile()).getProject() == iProject) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    protected static class SaveFilesRunnable
    implements Runnable {
        IEditorPart[] dirtyEditors;
        IProgressMonitor monitor;

        public SaveFilesRunnable(IEditorPart[] iEditorPartArray, IProgressMonitor iProgressMonitor) {
            this.dirtyEditors = iEditorPartArray;
            this.monitor = iProgressMonitor;
        }

        public void run() {
            int n = this.dirtyEditors.length;
            this.monitor.beginTask("Saving edited files", n);
            int n2 = 0;
            while (n2 < n) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                this.dirtyEditors[n2].doSave(this.monitor);
                this.monitor.worked(1);
                ++n2;
            }
            this.monitor.done();
        }
    }

    protected static class SaveFilesDialogRunnable
    implements Runnable {
        IEditorPart[] dirtyEditors;
        SaveFilesResult result;
        boolean promptAutoSave;

        public SaveFilesDialogRunnable(IEditorPart[] iEditorPartArray, SaveFilesResult saveFilesResult, boolean bl) {
            this.dirtyEditors = iEditorPartArray;
            this.result = saveFilesResult;
            this.promptAutoSave = bl;
        }

        public void run() {
            SaveFilesDialog saveFilesDialog = new SaveFilesDialog(Display.getCurrent().getActiveShell(), this.result, this.promptAutoSave);
            if (saveFilesDialog.open() == 0) {
                this.result.setSaved(true);
            }
        }
    }

    public static class SaveFilesResult {
        boolean autoSave;
        boolean saved;

        public boolean isAutoSave() {
            return this.autoSave;
        }

        public boolean isSaved() {
            return this.saved;
        }

        public void setAutoSave(boolean bl) {
            this.autoSave = bl;
        }

        public void setSaved(boolean bl) {
            this.saved = bl;
        }

        public SaveFilesResult() {
        }

        public SaveFilesResult(boolean bl) {
            this();
            this.setSaved(bl);
        }

        public SaveFilesResult(boolean bl, boolean bl2) {
            this(bl);
            this.setAutoSave(bl2);
        }
    }
}

