/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.hover;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.ui.IEditorPart;

public class PHPTextHoverProxy
extends AbstractPHPTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private PHPEditorTextHoverDescriptor fHoverDescriptor;
    private IPHPTextHover fHover;

    public PHPTextHoverProxy(PHPEditorTextHoverDescriptor pHPEditorTextHoverDescriptor, IEditorPart iEditorPart) {
        this.fHoverDescriptor = pHPEditorTextHoverDescriptor;
        if (iEditorPart != null) {
            this.setEditorPart(iEditorPart);
        }
    }

    public void setEditorPart(IEditorPart iEditorPart) {
        super.setEditorPart(iEditorPart);
        if (this.fHover != null && this.getEditorPart() != null) {
            this.fHover.setEditorPart(this.getEditorPart());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverRegion(iTextViewer, n);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverInfo(iTextViewer, iRegion);
        }
        return null;
    }

    private boolean ensureHoverCreated() {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return false;
        }
        return this.isCreated() || this.createHover();
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        if (this.fHover != null && this.getEditorPart() != null) {
            this.fHover.setEditorPart(this.getEditorPart());
        }
        return this.isCreated();
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

