/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.functions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPLanguageModel;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;

public class PHPFunctionsContentProvider
implements ITreeContentProvider {
    public static final String CONSTANTS_NODE_NAME = "constants";
    protected static final Object[] NO_CHILDREN = new Object[0];
    private PHPLanguageModel model;

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PHPFileData) {
            return true;
        }
        if (object instanceof PHPProjectModel) {
            PHPProjectModel pHPProjectModel = (PHPProjectModel)object;
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
            return iProject.isOpen();
        }
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            return PHPModelUtil.hasChildren((PHPCodeData)pHPCodeData);
        }
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object object) {
        return PHPModelUtil.getParent((Object)object);
    }

    private Object[] getClassChildren(PHPClassData pHPClassData) {
        PHPClassVarData[] pHPClassVarDataArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        if (pHPFunctionDataArray != null) {
            int n = 0;
            while (n < pHPFunctionDataArray.length) {
                arrayList.add(pHPFunctionDataArray[n]);
                ++n;
            }
        }
        if ((pHPClassVarDataArray = pHPClassData.getVars()) != null) {
            int n = 0;
            while (n < pHPClassVarDataArray.length) {
                arrayList.add(pHPClassVarDataArray[n]);
                ++n;
            }
        }
        return arrayList.toArray();
    }

    public Object[] getChildren(Object object) {
        if (!this.exists(object)) {
            return NO_CHILDREN;
        }
        if (object instanceof PHPLanguageModel) {
            PHPLanguageModel pHPLanguageModel = (PHPLanguageModel)object;
            CodeData[] codeDataArray = pHPLanguageModel.getFunctions();
            CodeData[] codeDataArray2 = pHPLanguageModel.getClasses();
            Object[] objectArray = NO_CHILDREN;
            if (codeDataArray.length > 0 && codeDataArray2.length > 0) {
                objectArray = new Object[codeDataArray2.length + codeDataArray.length + 1];
                objectArray[0] = CONSTANTS_NODE_NAME;
                System.arraycopy(codeDataArray2, 0, objectArray, 1, codeDataArray2.length);
                System.arraycopy(codeDataArray, 0, objectArray, codeDataArray2.length + 1, codeDataArray.length);
            }
            return objectArray;
        }
        if (object instanceof PHPClassData) {
            return this.getClassChildren((PHPClassData)object);
        }
        if (object.equals(CONSTANTS_NODE_NAME)) {
            return this.model.getConstants();
        }
        return NO_CHILDREN;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        this.model = (PHPLanguageModel)object2;
    }
}

