/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.ListContentProvider;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.IPListElement;
import org.eclipse.php.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.ui.preferences.includepath.IPListElementSorter;
import org.eclipse.php.ui.preferences.includepath.IPListLabelProvider;
import org.eclipse.php.ui.preferences.includepath.IncludePathBasePage;
import org.eclipse.php.ui.util.PHPElementSorter;
import org.eclipse.php.ui.util.PHPUILabelProvider;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.php.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.php.ui.wizards.fields.TreeListDialogField;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ProjectsWorkbookPage
extends IncludePathBasePage {
    private final int IDX_ADDPROJECT = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private ListDialogField fIncludePathList;
    private IProject fCurrPHPProject;
    private TreeListDialogField fProjectsList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public ProjectsWorkbookPage(ListDialogField listDialogField, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        this.fIncludePathList = listDialogField;
        this.fPageContainer = iWorkbenchPreferenceContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = PHPUIMessages.ProjectsWorkbookPage_projects_add_button;
        stringArray[2] = PHPUIMessages.ProjectsWorkbookPage_projects_edit_button;
        stringArray[3] = PHPUIMessages.ProjectsWorkbookPage_projects_remove_button;
        String[] stringArray2 = stringArray;
        ProjectsAdapter projectsAdapter = new ProjectsAdapter();
        this.fProjectsList = new TreeListDialogField(projectsAdapter, stringArray2, (ILabelProvider)new IPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(projectsAdapter);
        this.fProjectsList.setLabelText(PHPUIMessages.ProjectsWorkbookPage_projects_label);
        this.fProjectsList.enableButton(3, false);
        this.fProjectsList.enableButton(2, false);
        this.fProjectsList.setViewerSorter(new IPListElementSorter());
    }

    public void init(IProject iProject) {
        this.updateProjectsList(iProject);
    }

    private void updateProjectsList(IProject iProject) {
        List list = this.fIncludePathList.getElements();
        ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            IPListElement iPListElement = (IPListElement)list.get(n);
            if (this.isEntryKind(iPListElement.getEntryKind())) {
                arrayList.add(iPListElement);
            }
            --n;
        }
        this.fProjectsList.setElements(arrayList);
        this.fCurrPHPProject = iProject;
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fProjectsList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(n);
        this.fSWTControl = composite2;
        return composite2;
    }

    private void updateIncludePathList() {
        List list = this.fProjectsList.getElements();
        boolean bl = false;
        List list2 = this.fIncludePathList.getElements();
        int n = list2.size() - 1;
        while (n >= 0) {
            IPListElement iPListElement = (IPListElement)list2.get(n);
            if (this.isEntryKind(iPListElement.getEntryKind()) && !list.remove(iPListElement)) {
                list2.remove(n);
                bl = true;
            }
            --n;
        }
        n = 0;
        while (n < list.size()) {
            list2.add(list.get(n));
            ++n;
        }
        if (bl || list.size() > 0) {
            this.fIncludePathList.setElements(list2);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List list, boolean bl) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(list));
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                this.fProjectsList.expandElement(list.get(n), 1);
                ++n;
            }
        }
    }

    public boolean isEntryKind(int n) {
        return n == 2;
    }

    private void projectPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 0: {
                objectArray = this.openProjectDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fProjectsList.getElements();
            ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>(n2);
            int n3 = 0;
            while (n3 < n2) {
                IPListElement iPListElement = objectArray[n3];
                if (!list.contains(iPListElement) && !arrayList.contains(iPListElement)) {
                    arrayList.add(iPListElement);
                }
                ++n3;
            }
            this.fProjectsList.addElements(arrayList);
            if (n == 0) {
                this.fProjectsList.refresh();
            }
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    private void removeEntry() {
        List list = this.fProjectsList.getSelectedElements();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof IPListElementAttribute) {
                IPListElementAttribute iPListElementAttribute = (IPListElementAttribute)e;
                String string = iPListElementAttribute.getKey();
                Object var6_6 = null;
                iPListElementAttribute.getParent().setAttribute(string, var6_6);
                list.remove(n);
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fProjectsList.refresh();
            this.fIncludePathList.dialogFieldChanged();
        } else {
            this.fProjectsList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            Object e = list.get(n3);
            if (e instanceof IPListElementAttribute) {
                IPListElementAttribute iPListElementAttribute = (IPListElementAttribute)e;
                if (iPListElementAttribute.getValue() == null) {
                    return false;
                }
                ++n2;
            } else if (e instanceof IPListElement) {
                ++n;
            }
            ++n3;
        }
        return n2 == list.size() || n == list.size();
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof IPListElement) {
            return false;
        }
        return e instanceof IPListElementAttribute;
    }

    private void editEntry() {
        List list = this.fProjectsList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fProjectsList.getIndexOfElement(e) != -1) {
            this.editElementEntry((IPListElement)e);
        } else if (e instanceof IPListElementAttribute) {
            this.editAttributeEntry((IPListElementAttribute)e);
        }
    }

    private void editAttributeEntry(IPListElementAttribute iPListElementAttribute) {
        iPListElementAttribute.getKey();
    }

    private void editElementEntry(IPListElement iPListElement) {
        IPListElement[] iPListElementArray = this.openProjectDialog(iPListElement);
        if (iPListElementArray != null && iPListElementArray.length > 0) {
            IPListElement iPListElement2 = iPListElementArray[0];
            iPListElement2.setExported(iPListElement.isExported());
            this.fProjectsList.replaceElement(iPListElement, iPListElement2);
        }
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private IPListElement[] openProjectDialog(IPListElement iPListElement) {
        IPListElement iPListElement2;
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        arrayList.addAll(Arrays.asList(PHPWorkspaceModelManager.getInstance().listProjects()));
        arrayList.remove(this.fCurrPHPProject);
        List list = this.fProjectsList.getElements();
        int n = 0;
        while (n < list.size()) {
            iPListElement2 = (IPListElement)list.get(0);
            arrayList.remove(iPListElement2.getResource());
            ++n;
        }
        Object[] objectArray = arrayList.toArray();
        new PHPElementSorter().sort(null, objectArray);
        iPListElement2 = new ListSelectionDialog(this.getShell(), Arrays.asList(objectArray), (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new PHPUILabelProvider(), PHPUIMessages.ProjectsWorkbookPage_chooseProjects_message);
        iPListElement2.setTitle(PHPUIMessages.ProjectsWorkbookPage_chooseProjects_title);
        if (iPListElement2.open() == 0) {
            Object[] objectArray2 = iPListElement2.getResult();
            IPListElement[] iPListElementArray = new IPListElement[objectArray2.length];
            int n2 = 0;
            while (n2 < objectArray2.length) {
                IProject iProject = (IProject)objectArray2[n2];
                iPListElementArray[n2] = new IPListElement(this.fCurrPHPProject, 2, 1, iProject.getFullPath(), (IResource)iProject);
                ++n2;
            }
            return iPListElementArray;
        }
        return null;
    }

    protected void projectPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fProjectsList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void projectPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fProjectsList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void projectPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrPHPProject != null) {
            this.updateIncludePathList();
        }
    }

    private void projectPageSelectionChanged(DialogField dialogField) {
        List list = this.fProjectsList.getSelectedElements();
        this.fProjectsList.enableButton(2, this.canEdit(list));
        this.fProjectsList.enableButton(3, this.canRemove(list));
        boolean bl = this.containsOnlyTopLevelEntries(list);
        this.fProjectsList.enableButton(0, bl);
    }

    private class ProjectsAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private ProjectsAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            ProjectsWorkbookPage.this.projectPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            ProjectsWorkbookPage.this.projectPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            ProjectsWorkbookPage.this.projectPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            ProjectsWorkbookPage.this.projectPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof IPListElement) {
                return ((IPListElement)object).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof IPListElementAttribute) {
                return ((IPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.getChildren(treeListDialogField, object).length > 0;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            ProjectsWorkbookPage.this.projectPageDialogFieldChanged(dialogField);
        }
    }
}

