/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.Logger;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CurlyOpenAutoEditStrategy
extends IndentLineAutoEditStrategy
implements IAutoEditStrategy {
    private StringBuffer helpBuffer = new StringBuffer();

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text != null && documentCommand.text.endsWith("{")) {
            this.autoIndentBeforeCurlyOpen((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoIndentBeforeCurlyOpen(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        int n = documentCommand.offset;
        int n2 = n + documentCommand.length;
        this.helpBuffer.setLength(0);
        try {
            IRegion iRegion = iStructuredDocument.getLineInformationOfOffset(n);
            IRegion iRegion2 = null;
            iRegion2 = iRegion.getOffset() + iRegion.getLength() < n2 ? iStructuredDocument.getLineInformationOfOffset(n2) : iRegion;
            int n3 = iStructuredDocument.getLineOfOffset(n);
            if (CurlyOpenAutoEditStrategy.isBlanks((IStructuredDocument)iStructuredDocument, (int)iRegion.getOffset(), (int)(iRegion2.getOffset() + iRegion2.getLength()), (int)n)) {
                this.placeMatchingBlanks(iStructuredDocument, this.helpBuffer, n3, n);
                int n4 = documentCommand.offset + documentCommand.length;
                documentCommand.offset = iRegion.getOffset();
                documentCommand.length = documentCommand.length == 0 ? n2 - documentCommand.offset : n4 - documentCommand.offset;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        documentCommand.text = String.valueOf(this.helpBuffer.toString()) + documentCommand.text;
    }
}

