/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.dialogs.saveFiles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.ui.dialogs.saveFiles.SaveFilesDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SaveFilesHandler {
    public static SaveFilesResult handle(IProject iProject, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) {
        SaveFilesResult saveFilesResult = new SaveFilesResult();
        List list = SaveFilesHandler.getDirtyEditors(iProject);
        if (list == null || list.size() == 0) {
            saveFilesResult.setAccepted(true);
            return saveFilesResult;
        }
        if (!bl) {
            Display.getDefault().syncExec((Runnable)new SaveFilesDialogRunnable(list, saveFilesResult, bl2));
        } else {
            saveFilesResult.setAccepted(true);
            saveFilesResult.setSaved(list);
        }
        List list2 = saveFilesResult.getSaved();
        if (list2.size() > 0) {
            Display.getDefault().syncExec((Runnable)new SaveFilesRunnable(list2, iProgressMonitor));
        }
        if (iProgressMonitor.isCanceled()) {
            saveFilesResult.setAccepted(false);
        }
        return saveFilesResult;
    }

    public static List getDirtyEditors(IProject iProject) {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                        IFile iFile = iFileEditorInput.getFile();
                        if (iProject == null || iFile.getProject() == iProject) {
                            arrayList.add(iEditorPart);
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    protected static class SaveFilesRunnable
    implements Runnable {
        List dirtyEditors;
        IProgressMonitor monitor;

        public SaveFilesRunnable(List list, IProgressMonitor iProgressMonitor) {
            this.dirtyEditors = list;
            this.monitor = iProgressMonitor;
        }

        public void run() {
            this.monitor.beginTask("Saving edited files", this.dirtyEditors.size());
            Iterator iterator = this.dirtyEditors.iterator();
            while (iterator.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                ((IEditorPart)iterator.next()).doSave(this.monitor);
                this.monitor.worked(1);
            }
            this.monitor.done();
        }
    }

    protected static class SaveFilesDialogRunnable
    implements Runnable {
        List dirtyEditors;
        SaveFilesResult result;
        boolean promptAutoSave;

        public SaveFilesDialogRunnable(List list, SaveFilesResult saveFilesResult, boolean bl) {
            this.dirtyEditors = list;
            this.result = saveFilesResult;
            this.promptAutoSave = bl;
        }

        public void run() {
            SaveFilesDialog saveFilesDialog = new SaveFilesDialog(Display.getCurrent().getActiveShell(), this.dirtyEditors, this.result, this.promptAutoSave);
            if (saveFilesDialog.open() == 0) {
                this.result.setAccepted(true);
                this.result.setSaved(Arrays.asList(saveFilesDialog.getResult()));
            }
        }
    }

    public static class SaveFilesResult {
        boolean autoSave;
        boolean accepted;
        List saved = new ArrayList();

        public boolean isAutoSave() {
            return this.autoSave;
        }

        public void setAutoSave(boolean bl) {
            this.autoSave = bl;
        }

        public void setSaved(List list) {
            this.saved = list;
        }

        public void setAccepted(boolean bl) {
            this.accepted = bl;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public List getSaved() {
            return this.saved;
        }

        public SaveFilesResult() {
        }

        public SaveFilesResult(List list, boolean bl) {
            this();
            this.setSaved(list);
            this.setAccepted(bl);
        }

        public SaveFilesResult(List list, boolean bl, boolean bl2) {
            this(list, bl);
            this.setAutoSave(bl2);
            this.setAccepted(bl);
        }
    }
}

