/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.ModelListener;
import org.eclipse.php.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocBlockImp;
import org.eclipse.php.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.StandardPHPElementContentProvider;
import org.eclipse.php.ui.explorer.ExplorerPart;
import org.eclipse.swt.widgets.Control;

public class ExplorerContentProvider
extends StandardPHPElementContentProvider
implements ITreeContentProvider,
ModelListener,
IResourceChangeListener {
    ExplorerPart fPart;
    private Object fInput;
    TreeViewer fViewer;
    private int fPendingChanges;
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;

    public ExplorerContentProvider(ExplorerPart explorerPart, boolean bl) {
        super(bl);
        this.fPart = explorerPart;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private boolean inputDeleted() {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        this.postRefresh(this.fInput);
        return true;
    }

    public void dispose() {
        super.dispose();
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    private Object[] rootsAndContainers(PHPProjectModel pHPProjectModel, Object[] objectArray) {
        new ArrayList(objectArray.length);
        new HashSet(objectArray.length);
        new HashSet(objectArray.length);
        return objectArray;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.fViewer = (TreeViewer)viewer;
        if (object == null && object2 != null) {
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        } else if (object != null && object2 == null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        }
        this.fInput = object2;
    }

    private void postRefresh(Object object) {
        if (object instanceof IWorkspaceRoot) {
            object = PHPWorkspaceModelManager.getInstance();
        }
        if (this.isParent(object, this.fInput)) {
            object = this.fInput;
        }
        this.postRefresh(object, true);
    }

    boolean isParent(Object object, Object object2) {
        Object object3 = this.getParent(object2);
        if (object3 == null) {
            return false;
        }
        if (object3.equals(object)) {
            return true;
        }
        return this.isParent(object, object3);
    }

    private void postRefresh(final Object object, final boolean bl) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = ExplorerContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ExplorerContentProvider.this.fViewer.refresh(object, bl);
                }
            }
        });
    }

    private void postRunnable(final Runnable runnable) {
        Control control = this.fViewer.getControl();
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    ExplorerContentProvider.this.removePendingChange();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    ExplorerContentProvider.this.removePendingChange();
                    return;
                }
            }
        };
        if (control != null && !control.isDisposed()) {
            this.addPendingChange();
            try {
                control.getDisplay().asyncExec(runnable2);
            }
            catch (RuntimeException runtimeException) {
                this.removePendingChange();
                throw runtimeException;
            }
            catch (Error error) {
                this.removePendingChange();
                throw error;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            IResource iResource = iResourceDelta.getResource();
            this.processResourceDeltas(iResourceDelta.getAffectedChildren(), iResource);
        }
    }

    private boolean processResourceDeltas(IResourceDelta[] iResourceDeltaArray, Object object) {
        if (iResourceDeltaArray == null) {
            return false;
        }
        if (iResourceDeltaArray.length > 1) {
            this.postRefresh(object);
            return true;
        }
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            if (this.processResourceDelta(iResourceDeltaArray[n], object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean processResourceDelta(IResourceDelta iResourceDelta, Object object) {
        PHPFileData pHPFileData;
        IResource iResource;
        int n = iResourceDelta.getKind();
        int n2 = iResourceDelta.getFlags();
        IResource iResource2 = iResourceDelta.getResource();
        if (iResource2 == null) {
            return false;
        }
        if ((n & 2) != 0) {
            if (object instanceof IFolder) {
                this.postRefresh(this.internalGetParent(object));
                return true;
            }
            iResource = iResource2;
            if (iResource2 instanceof IFile && (pHPFileData = PHPModelUtil.getPHPFile((IFile)((IFile)iResource2))) != null) {
                iResource = pHPFileData;
            }
            this.postRemove(object, iResource);
        }
        if ((n & 1) != 0) {
            iResource = iResource2;
            if (iResource2 instanceof IFile && PHPModelUtil.isPhpFile((IFile)((IFile)iResource2))) {
                pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile((IFile)iResource2, false);
                if (pHPFileData == null) {
                    pHPFileData = PHPCodeDataFactory.createPHPFileData((String)((IFile)iResource2).getFullPath().toString(), (UserData)PHPCodeDataFactory.createUserData((String)((IFile)iResource2).getFullPath().toString(), (int)0, (int)0, (int)0, (int)0), (PHPClassData[])PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY, (PHPFunctionData[])PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY, (PHPVariablesTypeManager)VariableContextBuilder.createPHPVariablesTypeManager(new HashMap(), new HashMap()), (PHPIncludeFileData[])PHPCodeDataFactory.EMPTY_INCLUDE_DATA_ARRAY, (PHPConstantData[])PHPCodeDataFactory.EMPTY_CONSTANT_DATA_ARRAY, (IPHPMarker[])PHPCodeDataFactory.EMPTY_MARKERS_DATA_ARRAY, (PHPBlock[])PHPCodeDataFactory.EMPTY_PHP_BLOCK_ARRAY, (PHPDocBlock)new PHPDocBlockImp("", "", new PHPDocTag[0], 0), (long)System.currentTimeMillis());
                }
                if (pHPFileData != null) {
                    iResource = pHPFileData;
                }
            }
            this.postAdd(object, iResource);
        }
        if ((n2 & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(object));
            return true;
        }
        this.processResourceDeltas(iResourceDelta.getAffectedChildren(), iResource2);
        return false;
    }

    private void postAdd(final Object object, final Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = ExplorerContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed() && ExplorerContentProvider.this.fViewer.testFindItem(object2) == null) {
                    ExplorerContentProvider.this.fViewer.add(object, object2);
                }
            }
        });
    }

    private void postRemove(final Object object, final Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = ExplorerContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ExplorerContentProvider.this.fViewer.remove(object, new Object[]{object2});
                }
            }
        });
    }

    private void postProjectStateChanged(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fPart.projectStateChanged(object);
            }
        });
    }

    private void postUpdateIcon(final PHPCodeData pHPCodeData) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = ExplorerContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ExplorerContentProvider.this.fViewer.update((Object)pHPCodeData, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        ArrayList<PHPFileData> arrayList = new ArrayList<PHPFileData>();
        arrayList.add(pHPFileData);
        this.postRefresh(arrayList, true);
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    public void dataCleared() {
    }

    void postRefresh(final List list, final boolean bl) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = ExplorerContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExplorerContentProvider.this.fViewer.refresh(iterator.next(), bl);
                    }
                }
            }
        });
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public Object[] getChildrenInternal(Object object) {
        if (object instanceof PHPWorkspaceModelManager) {
            return this.getAllProjects();
        }
        return super.getChildrenInternal(object);
    }

    private Object[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }
}

