/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.IPListElement;
import org.eclipse.php.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.ui.preferences.includepath.IPListElementSorter;
import org.eclipse.php.ui.preferences.includepath.IPListLabelProvider;
import org.eclipse.php.ui.preferences.includepath.IncludePathBasePage;
import org.eclipse.php.ui.preferences.includepath.IncludePathDialogAccess;
import org.eclipse.php.ui.preferences.includepath.NewContainerDialog;
import org.eclipse.php.ui.util.ExceptionHandler;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.php.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.php.ui.wizards.fields.TreeListDialogField;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LibrariesWorkbookPage
extends IncludePathBasePage {
    private ListDialogField fIncludePathList;
    private IProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDVAR = 0;
    private final int IDX_ADDZIP = 1;
    private final int IDX_ADDEXT = 2;
    private final int IDX_ADDFOL = 3;
    private final int IDX_EDIT = 4;
    private final int IDX_REMOVE = 5;

    public LibrariesWorkbookPage(ListDialogField listDialogField, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        this.fIncludePathList = listDialogField;
        this.fPageContainer = iWorkbenchPreferenceContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[]{PHPUIMessages.LibrariesWorkbookPage_libraries_addvariable_button, PHPUIMessages.LibrariesWorkbookPage_libraries_addzip_button, PHPUIMessages.LibrariesWorkbookPage_libraries_addextzip_button, PHPUIMessages.LibrariesWorkbookPage_libraries_addincludepathfolder_button, PHPUIMessages.LibrariesWorkbookPage_libraries_edit_button, PHPUIMessages.LibrariesWorkbookPage_libraries_remove_button};
        LibrariesAdapter librariesAdapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(librariesAdapter, stringArray, (ILabelProvider)new IPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(librariesAdapter);
        this.fLibrariesList.setLabelText(PHPUIMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(5, false);
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.setViewerSorter(new IPListElementSorter());
    }

    public void init(IProject iProject) {
        this.fCurrJProject = iProject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List list = this.fIncludePathList.getElements();
        ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>(list.size());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            IPListElement iPListElement = (IPListElement)list.get(n2);
            if (this.isEntryKind(iPListElement.getEntryKind())) {
                arrayList.add(iPListElement);
            }
            ++n2;
        }
        this.fLibrariesList.setElements(arrayList);
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(n);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new IPListElementSorter());
        this.fSWTControl = composite2;
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 1: {
                objectArray = this.openZipFileDialog(null);
                break;
            }
            case 2: {
                objectArray = this.openExtZIPFileDialog(null);
                break;
            }
            case 0: {
                objectArray = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                objectArray = this.openIncludeFolderDialog(null);
                break;
            }
            case 4: {
                this.editEntry();
                return;
            }
            case 5: {
                this.removeEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fLibrariesList.getElements();
            ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>(n2);
            int n3 = 0;
            while (n3 < n2) {
                IPListElement iPListElement = objectArray[n3];
                if (!list.contains(iPListElement) && !arrayList.contains(iPListElement)) {
                    arrayList.add(iPListElement);
                }
                ++n3;
            }
            if (!arrayList.isEmpty() && n == 3) {
                this.askForAddingExclusionPatternsDialog(arrayList);
            }
            this.fLibrariesList.addElements(arrayList);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    private void askForAddingExclusionPatternsDialog(List list) {
        HashSet hashSet = new HashSet();
        LibrariesWorkbookPage.fixNestingConflicts(list, this.fIncludePathList.getElements(), hashSet);
        if (!hashSet.isEmpty()) {
            String string = PHPUIMessages.LibrariesWorkbookPage_exclusion_added_title;
            String string2 = PHPUIMessages.LibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fLibrariesList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        IPListElementAttribute iPListElementAttribute;
        Object object;
        List list = this.fLibrariesList.getSelectedElements();
        HashSet<IPListElement> hashSet = new HashSet<IPListElement>();
        int n = list.size() - 1;
        while (n >= 0) {
            object = list.get(n);
            if (object instanceof IPListElementAttribute) {
                iPListElementAttribute = (IPListElementAttribute)object;
                String string = iPListElementAttribute.getKey();
                Object var7_8 = null;
                iPListElementAttribute.getParent().setAttribute(string, var7_8);
                list.remove(n);
                if (iPListElementAttribute.getParent().getParentContainer() instanceof IPListElement) {
                    hashSet.add(iPListElementAttribute.getParent());
                }
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fIncludePathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(list);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (IPListElement)iterator.next();
            iPListElementAttribute = ((IPListElement)object).getIncludePathEntry();
            this.updateContainerEntry((IIncludePathEntry)iPListElementAttribute, this.fCurrJProject, ((IPListElement)((IPListElement)object).getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object object;
            Object e = list.get(n);
            if (e instanceof IPListElementAttribute) {
                object = (IPListElementAttribute)e;
                if (((IPListElementAttribute)object).isInNonModifiableContainer()) {
                    return false;
                }
                if (((IPListElementAttribute)object).getValue() == null) {
                    return false;
                }
            } else if (e instanceof IPListElement) {
                object = (IPListElement)e;
                if (((IPListElement)object).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void editEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fLibrariesList.getIndexOfElement(e) != -1) {
            this.editElementEntry((IPListElement)e);
        } else if (e instanceof IPListElementAttribute) {
            this.editAttributeEntry((IPListElementAttribute)e);
        }
    }

    private void editAttributeEntry(IPListElementAttribute iPListElementAttribute) {
        iPListElementAttribute.getKey();
        iPListElementAttribute.getParent();
    }

    private void attributeUpdated(IPListElement iPListElement) {
        Object object = iPListElement.getParentContainer();
        if (object instanceof IPListElement) {
            IIncludePathEntry iIncludePathEntry = iPListElement.getIncludePathEntry();
            this.updateContainerEntry(iIncludePathEntry, this.fCurrJProject, ((IPListElement)object).getPath());
        }
    }

    private void updateContainerEntry(final IIncludePathEntry iIncludePathEntry, final IProject iProject, final IPath iPath) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
                    pHPProjectOptions.modifyIncludePathEntry(iIncludePathEntry, iProject, iPath, iProgressMonitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = PHPUIMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String string2 = PHPUIMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(IPListElement iPListElement) {
        Object object;
        IPListElement[] iPListElementArray = null;
        switch (iPListElement.getEntryKind()) {
            case 5: {
                iPListElementArray = this.openContainerSelectionDialog(iPListElement);
                break;
            }
            case 1: {
                object = iPListElement.getResource();
                if (object == null) {
                    if (iPListElement.getContentKind() == 2) {
                        iPListElementArray = this.openExtZIPFileDialog(iPListElement);
                        break;
                    }
                    iPListElementArray = this.openIncludeFolderDialog(iPListElement);
                    break;
                }
                if (object.getType() == 2) {
                    if (object.exists()) {
                        iPListElementArray = this.openFolderDialog(iPListElement);
                        break;
                    }
                    iPListElementArray = this.openNewFolderDialog(iPListElement);
                    break;
                }
                if (object.getType() != 1) break;
                iPListElementArray = this.openZipFileDialog(iPListElement);
                break;
            }
            case 4: {
                iPListElementArray = this.openVariableSelectionDialog(iPListElement);
            }
        }
        if (iPListElementArray != null && iPListElementArray.length > 0) {
            object = iPListElementArray[0];
            ((IPListElement)object).setExported(iPListElement.isExported());
            this.fLibrariesList.replaceElement(iPListElement, object);
        }
    }

    private void libaryPageSelectionChanged(DialogField dialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(4, this.canEdit(list));
        this.fLibrariesList.enableButton(5, this.canRemove(list));
        boolean bl = this.containsOnlyTopLevelEntries(list);
        this.fLibrariesList.enableButton(2, bl);
        this.fLibrariesList.enableButton(3, bl);
        this.fLibrariesList.enableButton(1, bl);
        this.fLibrariesList.enableButton(0, bl);
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof IPListElement) {
            IPListElement iPListElement = (IPListElement)e;
            return !(iPListElement.getResource() instanceof IFolder) && iPListElement.getParentContainer() == null;
        }
        if (e instanceof IPListElementAttribute) {
            IPListElementAttribute iPListElementAttribute = (IPListElementAttribute)e;
            return !iPListElementAttribute.isInNonModifiableContainer();
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrJProject != null) {
            this.updateIncludePathList();
        }
    }

    private void updateIncludePathList() {
        int n;
        List list = this.fLibrariesList.getElements();
        List list2 = this.fIncludePathList.getElements();
        int n2 = n = list2.size();
        int n3 = n - 1;
        while (n3 >= 0) {
            IPListElement iPListElement = (IPListElement)list2.get(n3);
            int n4 = iPListElement.getEntryKind();
            if (this.isEntryKind(n4) && !list.remove(iPListElement)) {
                list2.remove(n3);
                n2 = n3;
            }
            --n3;
        }
        list2.addAll(n2, list);
        if (n2 != n || !list.isEmpty()) {
            this.fIncludePathList.setElements(list2);
        }
    }

    private IPListElement[] openNewFolderDialog(IPListElement iPListElement) {
        String string = iPListElement == null ? PHPUIMessages.LibrariesWorkbookPage_NewIncludePathDialog_new_title : PHPUIMessages.LibrariesWorkbookPage_NewIncludePathDialog_edit_title;
        IProject iProject = this.fCurrJProject.getProject();
        NewContainerDialog newContainerDialog = new NewContainerDialog(this.getShell(), string, iProject, this.getUsedContainers(iPListElement), iPListElement);
        IPath iPath = iProject.getFullPath();
        newContainerDialog.setMessage(MessageFormat.format(PHPUIMessages.LibrariesWorkbookPage_NewIncludePathDialog_description, iPath.toString()));
        if (newContainerDialog.open() == 0) {
            IFolder iFolder = newContainerDialog.getFolder();
            return new IPListElement[]{this.newCPLibraryElement((IResource)iFolder)};
        }
        return null;
    }

    private IPListElement[] openFolderDialog(IPListElement iPListElement) {
        IPath[] iPathArray;
        if (iPListElement == null && (iPathArray = IncludePathDialogAccess.chooseFolderEntries(this.getShell(), this.fCurrJProject.getLocation(), this.getUsedContainers(iPListElement))) != null) {
            IWorkspaceRoot iWorkspaceRoot = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>();
            int n = 0;
            while (n < iPathArray.length) {
                IPath iPath = iPathArray[n];
                IResource iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource instanceof IContainer) {
                    arrayList.add(this.newCPLibraryElement(iResource));
                }
                ++n;
            }
            return arrayList.toArray(new IPListElement[arrayList.size()]);
        }
        return null;
    }

    private IPListElement[] openIncludeFolderDialog(IPListElement iPListElement) {
        if (iPListElement == null) {
            IPath[] iPathArray = IncludePathDialogAccess.chooseIncludePathFoldersEntries(this.getShell());
            if (iPathArray != null) {
                ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>();
                int n = 0;
                while (n < iPathArray.length) {
                    arrayList.add(new IPListElement(this.fCurrJProject, 1, 1, iPathArray[n], null));
                    ++n;
                }
                return arrayList.toArray(new IPListElement[arrayList.size()]);
            }
        } else {
            IPath iPath = IncludePathDialogAccess.configureIncludePathFolderEntry(this.getShell(), iPListElement.getPath());
            if (iPath != null) {
                IPListElement iPListElement2 = new IPListElement(this.fCurrJProject, 1, 1, iPath, null);
                return new IPListElement[]{iPListElement2};
            }
        }
        return null;
    }

    private IPListElement[] openZipFileDialog(IPListElement iPListElement) {
        IWorkspaceRoot iWorkspaceRoot = this.fCurrJProject.getProject().getWorkspace().getRoot();
        if (iPListElement == null) {
            IPath[] iPathArray = IncludePathDialogAccess.chooseZIPEntries(this.getShell(), this.fCurrJProject.getLocation(), this.getUsedZipFiles(iPListElement));
            if (iPathArray != null) {
                ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>();
                int n = 0;
                while (n < iPathArray.length) {
                    IPath iPath = iPathArray[n];
                    IResource iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource instanceof IFile) {
                        arrayList.add(this.newCPLibraryElement(iResource));
                    }
                    ++n;
                }
                return arrayList.toArray(new IPListElement[arrayList.size()]);
            }
        } else {
            IResource iResource;
            IPath iPath = IncludePathDialogAccess.configureZIPEntry(this.getShell(), iPListElement.getPath(), this.getUsedZipFiles(iPListElement));
            if (iPath != null && (iResource = iWorkspaceRoot.findMember(iPath)) instanceof IFile) {
                return new IPListElement[]{this.newCPLibraryElement(iResource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(IPListElement iPListElement) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        List list = this.fLibrariesList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            IPListElement iPListElement2 = (IPListElement)list.get(n);
            if (iPListElement2.getEntryKind() == 1 && iPListElement2 != iPListElement && (iResource = iPListElement2.getResource()) instanceof IContainer && !iResource.equals((Object)iPListElement)) {
                arrayList.add(iResource.getFullPath());
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private IPath[] getUsedZipFiles(IPListElement iPListElement) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        List list = this.fLibrariesList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            IPListElement iPListElement2 = (IPListElement)list.get(n);
            if (iPListElement2.getEntryKind() == 1 && iPListElement2 != iPListElement && (iResource = iPListElement2.getResource()) instanceof IFile) {
                arrayList.add(iResource.getFullPath());
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }

    private IPListElement newCPLibraryElement(IResource iResource) {
        return new IPListElement(this.fCurrJProject, 1, 2, iResource.getFullPath(), iResource);
    }

    private IPListElement[] openExtZIPFileDialog(IPListElement iPListElement) {
        if (iPListElement == null) {
            IPath[] iPathArray = IncludePathDialogAccess.chooseExternalZIPEntries(this.getShell());
            if (iPathArray != null) {
                ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>();
                int n = 0;
                while (n < iPathArray.length) {
                    arrayList.add(new IPListElement(this.fCurrJProject, 1, 2, iPathArray[n], null));
                    ++n;
                }
                return arrayList.toArray(new IPListElement[arrayList.size()]);
            }
        } else {
            IPath iPath = IncludePathDialogAccess.configureExternalZIPEntry(this.getShell(), iPListElement.getPath());
            if (iPath != null) {
                return new IPListElement[]{new IPListElement(this.fCurrJProject, 1, 2, iPath, null)};
            }
        }
        return null;
    }

    private IPListElement[] openVariableSelectionDialog(IPListElement iPListElement) {
        IPath iPath;
        List list = this.fLibrariesList.getElements();
        ArrayList<IPath> arrayList = new ArrayList<IPath>(list.size());
        int n = 0;
        while (n < list.size()) {
            iPath = (IPath)list.get(n);
            if (iPath.getEntryKind() == 4) {
                arrayList.add(iPath.getPath());
            }
            ++n;
        }
        IPath[] iPathArray = arrayList.toArray(new IPath[arrayList.size()]);
        if (iPListElement == null) {
            iPath = IncludePathDialogAccess.chooseVariableEntries(this.getShell(), iPathArray);
            if (iPath != null) {
                ArrayList<IPListElement> arrayList2 = new ArrayList<IPListElement>();
                int n2 = 0;
                while (n2 < ((IPath)iPath).length) {
                    IPListElement iPListElement2 = new IPListElement(this.fCurrJProject, 4, 1, iPath[n2], null);
                    IPath iPath2 = PHPProjectOptions.getResolvedVariablePath((IPath)iPath[n2]);
                    iPListElement2.setIsMissing(iPath2 == null || !iPath2.toFile().exists());
                    if (!list.contains(iPListElement2)) {
                        arrayList2.add(iPListElement2);
                    }
                    ++n2;
                }
                return arrayList2.toArray(new IPListElement[arrayList2.size()]);
            }
        } else {
            iPath = IncludePathDialogAccess.configureVariableEntry(this.getShell(), iPListElement.getPath(), iPathArray);
            if (iPath != null) {
                IPListElement iPListElement3 = new IPListElement(this.fCurrJProject, 4, 1, iPath, null);
                return new IPListElement[]{iPListElement3};
            }
        }
        return null;
    }

    private IPListElement[] openContainerSelectionDialog(IPListElement iPListElement) {
        if (iPListElement == null) {
            IIncludePathEntry[] iIncludePathEntryArray = IncludePathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawIncludePath());
            if (iIncludePathEntryArray != null) {
                IPListElement[] iPListElementArray = new IPListElement[iIncludePathEntryArray.length];
                int n = 0;
                while (n < iPListElementArray.length) {
                    iPListElementArray[n] = new IPListElement(this.fCurrJProject, 5, 1, iIncludePathEntryArray[n].getPath(), null);
                    ++n;
                }
                return iPListElementArray;
            }
        } else {
            IIncludePathEntry iIncludePathEntry = IncludePathDialogAccess.configureContainerEntry(this.getShell(), iPListElement.getIncludePathEntry(), this.fCurrJProject, this.getRawIncludePath());
            if (iIncludePathEntry != null) {
                IPListElement iPListElement2 = new IPListElement(this.fCurrJProject, 5, 1, iIncludePathEntry.getPath(), null);
                return new IPListElement[]{iPListElement2};
            }
        }
        return null;
    }

    private IIncludePathEntry[] getRawIncludePath() {
        IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[this.fIncludePathList.getSize()];
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            IPListElement iPListElement = (IPListElement)this.fIncludePathList.getElement(n);
            iIncludePathEntryArray[n] = iPListElement.getIncludePathEntry();
            ++n;
        }
        return iIncludePathEntryArray;
    }

    public boolean isEntryKind(int n) {
        return n == 1 || n == 4 || n == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List list, boolean bl) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(list));
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                this.fLibrariesList.expandElement(list.get(n), 1);
                ++n;
            }
        }
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof IPListElement) {
                return ((IPListElement)object).getChildren(false);
            }
            if (object instanceof IPListElementAttribute) {
                IPListElementAttribute cfr_ignored_0 = (IPListElementAttribute)object;
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof IPListElementAttribute) {
                return ((IPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.getChildren(treeListDialogField, object).length > 0;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(dialogField);
        }
    }
}

