/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.core.project.operation.PHPCreationDataModelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.ui.preferences.IStatusChangeListener;
import org.eclipse.php.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.util.ValuedCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPVersionConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_PHP_VERSION = PHPVersionConfigurationBlock.getPHPCoreKey("phpVersion");
    private static final OptionsConfigurationBlock.Key PREF_ASP_TAGS = PHPVersionConfigurationBlock.getPHPCoreKey("use_asp_tags_as_php");
    private IStatus fTaskTagsStatus;
    protected ValuedCombo versionCombo;
    protected Button useAspTagsButton;
    protected Label nameLabel;

    public PHPVersionConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, PHPVersionConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
    }

    public void setEnabled(boolean bl) {
        this.versionCombo.setEnabled(bl);
        this.useAspTagsButton.setEnabled(bl);
        this.nameLabel.setEnabled(bl);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_PHP_VERSION, PREF_ASP_TAGS};
    }

    public Control createContents(Composite composite) {
        this.setShell(composite.getShell());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.createVersionContent(composite2);
        this.createUseAspTagsContent(composite2);
        this.unpackPHPVersion();
        this.unpackUseAspTags();
        this.validateSettings(null, null, null);
        return composite2;
    }

    private void createUseAspTagsContent(Composite composite) {
        this.useAspTagsButton = new Button(composite, 32);
        this.useAspTagsButton.setText(PHPUIMessages.Preferences_php_editor_useAspTagsAsPhp_label);
        this.useAspTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PHPVersionConfigurationBlock.this.setUseAspTagsValue(Boolean.toString(PHPVersionConfigurationBlock.this.useAspTagsButton.getSelection()));
            }
        });
    }

    private Composite createVersionContent(Composite composite) {
        Composite composite2 = new Composite(composite, 16);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.nameLabel = new Label(composite2, 0);
        this.nameLabel.setText(PHPUIMessages.PHPVersionComboName);
        GC gC = new GC((Drawable)this.nameLabel);
        gC.setFont(this.nameLabel.getFont());
        gC.dispose();
        List list = this.prepareVersionEntryList();
        this.versionCombo = new ValuedCombo(composite2, 8, list);
        this.versionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = PHPVersionConfigurationBlock.this.versionCombo.getSelectionValue();
                PHPVersionConfigurationBlock.this.setPhpVersionValue(string);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        return composite2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
        if (key != null) {
            if (PREF_PHP_VERSION.equals(key)) {
                this.fTaskTagsStatus = this.validatePHPVersion();
            } else {
                if (!PREF_ASP_TAGS.equals(key)) return;
                this.fTaskTagsStatus = this.validatePHPVersion();
            }
        } else {
            this.fTaskTagsStatus = this.validatePHPVersion();
        }
        this.fContext.statusChanged(this.fTaskTagsStatus);
    }

    private IStatus validatePHPVersion() {
        return new StatusInfo();
    }

    private List prepareVersionEntryList() {
        ArrayList<ValuedCombo.Entry> arrayList = new ArrayList<ValuedCombo.Entry>();
        int n = 0;
        while (n < PHPCreationDataModelProvider.PHP_VERSION_DESCRIPTIONS.length) {
            String string = PHPCreationDataModelProvider.PHP_VERSION_DESCRIPTIONS[n];
            String string2 = PHPCreationDataModelProvider.PHP_VERSION_VALUES[n];
            ValuedCombo.Entry entry = new ValuedCombo.Entry(string2, string);
            arrayList.add(entry);
            ++n;
        }
        return arrayList;
    }

    private void setPhpVersionValue(String string) {
        String[] stringArray = PHPCreationDataModelProvider.PHP_VERSION_VALUES;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                this.versionCombo.setText(PHPCreationDataModelProvider.PHP_VERSION_DESCRIPTIONS[n]);
                this.setValue(PREF_PHP_VERSION, stringArray[n]);
                this.validateSettings(PREF_PHP_VERSION, null, null);
                return;
            }
            ++n;
        }
    }

    private void setUseAspTagsValue(String string) {
        this.setValue(PREF_ASP_TAGS, string);
        this.validateSettings(PREF_ASP_TAGS, null, null);
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        String string = PHPUIMessages.PHPVersionConfigurationBlock_needsbuild_title;
        String string2 = bl ? PHPUIMessages.PHPVersionConfigurationBlock_needsfullbuild_message : PHPUIMessages.PHPVersionConfigurationBlock_needsprojectbuild_message;
        return new String[]{string, string2};
    }

    protected void updateControls() {
        this.unpackPHPVersion();
        this.unpackUseAspTags();
    }

    private void unpackPHPVersion() {
        String string = this.getValue(PREF_PHP_VERSION);
        this.versionCombo.selectValue(string);
    }

    private void unpackUseAspTags() {
        String string = this.getValue(PREF_ASP_TAGS);
        this.useAspTagsButton.setSelection(Boolean.valueOf(string).booleanValue());
    }

    public String getPHPVersionValue() {
        return this.getValue(PREF_PHP_VERSION);
    }

    public boolean getUseAspTagsValue() {
        return this.getBooleanValue(PREF_ASP_TAGS);
    }
}

