/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.daemon;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.debug.daemon.communication.CommunicationDaemonRegistry;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.osgi.framework.BundleContext;

public class DaemonPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.daemon";
    private static final int INTERNAL_ERROR = 10001;
    public static final boolean isDebugMode;
    private static DaemonPlugin plugin;
    private ICommunicationDaemon daemon;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.php.debug.daemon/debug");
        isDebugMode = string != null && string.equalsIgnoreCase("true");
    }

    public DaemonPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.daemon = CommunicationDaemonRegistry.getBestMatchCommunicationDaemon();
        if (this.daemon != null) {
            this.daemon.init();
            this.daemon.startListen();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
        if (this.daemon != null) {
            this.daemon.stopListen();
            this.daemon = null;
        }
    }

    public static String getID() {
        return ID;
    }

    public static DaemonPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus iStatus) {
        DaemonPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        DaemonPlugin.log((IStatus)new Status(4, ID, 10001, "Debug Daemon plugin internal error", throwable));
    }

    public static void logErrorMessage(String string) {
        DaemonPlugin.log((IStatus)new Status(4, ID, 10001, string, null));
    }
}

