/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.php.debug.core.debugger.Breakpoint;

public class CommunicationUtilities {
    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public static void writeBreakpoint(DataOutputStream dataOutputStream, Breakpoint breakpoint) throws IOException {
        dataOutputStream.writeShort(breakpoint.getType());
        dataOutputStream.writeShort(breakpoint.getLifeTime());
        if (breakpoint.getConditionalFlag()) {
            CommunicationUtilities.writeString(dataOutputStream, breakpoint.getExpression());
            if (!breakpoint.getStaticFlag()) {
                return;
            }
        }
        CommunicationUtilities.writeString(dataOutputStream, breakpoint.getFileName());
        if (breakpoint.getStaticFlag()) {
            int n = breakpoint.getLineNumber();
            dataOutputStream.writeInt(n);
        }
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        return new String(CommunicationUtilities.readStringAsBytes(dataInputStream));
    }

    public static byte[] readStringAsBytes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static Breakpoint readBreakpoint(DataInputStream dataInputStream) throws IOException {
        Breakpoint breakpoint = new Breakpoint();
        breakpoint.setType(dataInputStream.readShort());
        breakpoint.setLifeTime(dataInputStream.readShort());
        if (breakpoint.getType() == 2) {
            breakpoint.setExpression(CommunicationUtilities.readString(dataInputStream));
        }
        breakpoint.setFileName(CommunicationUtilities.readString(dataInputStream));
        if (breakpoint.getType() == 1) {
            breakpoint.setLineNumber(dataInputStream.readInt());
        }
        return breakpoint;
    }
}

