/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.containers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.util.Messages;

public class LocalFileStorage
extends PlatformObject
implements IStorage {
    private File fFile;
    private IProject fProject;
    private String fIncBaseDirName;

    public LocalFileStorage(File file) {
        this.setFile(file);
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PHPCorePlugin.getPluginId(), 10001, Messages.zipEntryStorage_error, (Throwable)iOException));
        }
    }

    public IPath getFullPath() {
        try {
            return new Path(this.getFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
            return null;
        }
    }

    public String getName() {
        return this.getFile().getName();
    }

    public boolean isReadOnly() {
        return true;
    }

    private void setFile(File file) {
        this.fFile = file;
    }

    public File getFile() {
        return this.fFile;
    }

    public boolean equals(Object object) {
        return object instanceof LocalFileStorage && this.getFile().equals(((LocalFileStorage)((Object)object)).getFile());
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setIncBaseDirName(String string) {
        if (string == null) {
            return;
        }
        try {
            this.fIncBaseDirName = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
        }
    }

    public String getIncBaseDirName() {
        return this.fIncBaseDirName;
    }
}

