/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.ui.outline.PHPOutlineContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RefreshStructureJob
extends Job {
    static final boolean DEBUG;
    private static final long UPDATE_DELAY = 250L;
    private final List fRequests;
    List fViewers = new ArrayList(3);

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/refreshStructure");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public RefreshStructureJob() {
        super(XMLUIMessages.refreshoutline_0);
        this.setPriority(30);
        this.setSystem(true);
        this.fRequests = new ArrayList(2);
    }

    private synchronized void addRequest(Node node) {
        int n = this.fRequests.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node2 = (Node)this.fRequests.get(n2);
                if (this.contains(node2, node)) {
                    return;
                }
                if (this.contains(node, node2)) {
                    this.fRequests.set(n2, node);
                    return;
                }
                ++n2;
            }
        } else {
            this.fRequests.add(node);
        }
    }

    private synchronized void addViewer(StructuredViewer structuredViewer) {
        if (!this.fViewers.contains(structuredViewer)) {
            this.fViewers.add(structuredViewer);
        }
    }

    private boolean contains(Node node, Node node2) {
        if (DEBUG) {
            System.out.println("==============================================================================================================");
            System.out.println("recursive call w/ root: " + node.getNodeName() + " and possible: " + node2);
            System.out.println("--------------------------------------------------------------------------------------------------------------");
        }
        if (node == null) {
            if (DEBUG) {
                System.out.println("returning false: root is null");
            }
            return false;
        }
        if (node2 instanceof Document) {
            if (DEBUG) {
                System.out.println("returning false: possible is Document node");
            }
            return false;
        }
        if (node instanceof Document) {
            if (DEBUG) {
                System.out.println("returning true: root is Document node");
            }
            return true;
        }
        Node node3 = node;
        while (node3 != null) {
            if (DEBUG) {
                System.out.println("   -> iterating sibling (" + node3.getNodeName() + ")");
            }
            if (node2.equals(node3)) {
                if (DEBUG) {
                    System.out.println("   !!! found: " + node2.getNodeName() + " in subtree for: " + node.getNodeName());
                }
                return true;
            }
            if (node3.getFirstChild() != null) {
                return this.contains(node3.getFirstChild(), node2);
            }
            node3 = node3.getNextSibling();
        }
        return false;
    }

    private void doRefresh(final Node node, final StructuredViewer[] structuredViewerArray) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (DEBUG) {
                    System.out.println("refresh on: [" + node.getNodeName() + "]");
                }
                int n = 0;
                while (n < structuredViewerArray.length) {
                    if (!structuredViewerArray[n].getControl().isDisposed()) {
                        StructuredViewer structuredViewer = structuredViewerArray[n];
                        if (node.getNodeType() == 9 || node.getNodeType() == 1 && ((IDOMNode)node).getFirstStructuredDocumentRegion().getType() == "PHP_CONTENT" && structuredViewer.getContentProvider() instanceof PHPOutlineContentProvider && ((PHPOutlineContentProvider)structuredViewer.getContentProvider()).getMode() == 1) {
                            structuredViewerArray[n].refresh(true);
                        } else {
                            structuredViewerArray[n].refresh((Object)node, true);
                        }
                    } else if (DEBUG) {
                        System.out.println("   !!! skipped refreshing disposed viewer: " + structuredViewerArray[n]);
                    }
                    ++n;
                }
            }
        });
    }

    private synchronized Object[] getRequests() {
        Node[] nodeArray = this.fRequests.toArray(new Node[this.fRequests.size()]);
        this.fRequests.clear();
        StructuredViewer[] structuredViewerArray = this.fViewers.toArray(new StructuredViewer[this.fViewers.size()]);
        this.fViewers.clear();
        return new Object[]{nodeArray, structuredViewerArray};
    }

    public void refresh(StructuredViewer structuredViewer, Node node) {
        if (node == null) {
            return;
        }
        this.addViewer(structuredViewer);
        this.addRequest(node);
        this.schedule(250L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        try {
            Object[] objectArray = this.getRequests();
            Node[] nodeArray = (Node[])objectArray[0];
            StructuredViewer[] structuredViewerArray = (StructuredViewer[])objectArray[1];
            int n = 0;
            while (n < nodeArray.length) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.doRefresh(nodeArray[n], structuredViewerArray);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        iProgressMonitor.done();
        return iStatus;
    }
}

