/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.core.IncludePathContainerInitializer;
import org.eclipse.php.core.project.IIncludePathContainer;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.IPListElement;
import org.eclipse.php.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.ui.preferences.includepath.IPUserLibraryElement;
import org.eclipse.php.ui.preferences.includepath.ZipFileFilter;
import org.eclipse.php.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class IPListLabelProvider
extends LabelProvider {
    private String fNewLabel = PHPUIMessages.CPListLabelProvider_new;
    private String fClassLabel = PHPUIMessages.CPListLabelProvider_container;
    private String fCreateLabel = PHPUIMessages.CPListLabelProvider_willbecreated;
    private ImageDescriptor fZipIcon;
    private ImageDescriptor fExtZipIcon;
    private ImageDescriptor fJarWSrcIcon;
    private ImageDescriptor fExtZipWSrcIcon;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor fVariableImage;
    private ImageDescriptor fContainerImage;
    private ImageDescriptorRegistry fRegistry = PHPUiPlugin.getImageDescriptorRegistry();

    public IPListLabelProvider() {
        this.fZipIcon = PHPPluginImages.DESC_OBJS_ZIP;
        this.fExtZipIcon = PHPPluginImages.DESC_OBJS_EXTZIP;
        this.fFolderImage = PHPPluginImages.DESC_OBJS_PHP_FOLDER;
        this.fContainerImage = PHPPluginImages.DESC_OBJS_LIBRARY;
        this.fVariableImage = PHPPluginImages.DESC_OBJS_ENV_VAR;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        this.fProjectImage = iWorkbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public String getText(Object object) {
        if (object instanceof IPListElement) {
            return this.getCPListElementText((IPListElement)object);
        }
        if (object instanceof IPListElementAttribute) {
            IPListElementAttribute iPListElementAttribute = (IPListElementAttribute)object;
            String string = this.getCPListElementAttributeText(iPListElementAttribute);
            if (iPListElementAttribute.isInNonModifiableContainer()) {
                return MessageFormat.format(PHPUIMessages.CPListLabelProvider_non_modifiable_attribute, string);
            }
            return string;
        }
        if (object instanceof IPUserLibraryElement) {
            return this.getCPUserLibraryText((IPUserLibraryElement)object);
        }
        return super.getText(object);
    }

    public String getCPUserLibraryText(IPUserLibraryElement iPUserLibraryElement) {
        String string = iPUserLibraryElement.getName();
        if (iPUserLibraryElement.isSystemLibrary()) {
            string = MessageFormat.format(PHPUIMessages.CPListLabelProvider_systemlibrary, string);
        }
        return string;
    }

    public String getCPListElementAttributeText(IPListElementAttribute iPListElementAttribute) {
        String string = PHPUIMessages.CPListLabelProvider_none;
        iPListElementAttribute.getKey();
        return string;
    }

    public String getCPListElementText(IPListElement iPListElement) {
        IPath iPath = iPListElement.getPath();
        switch (iPListElement.getEntryKind()) {
            case 1: {
                IResource iResource = iPListElement.getResource();
                if (iResource instanceof IContainer) {
                    StringBuffer stringBuffer = new StringBuffer(iPath.makeRelative().toString());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.fClassLabel);
                    if (!iResource.exists()) {
                        stringBuffer.append(' ');
                        if (iPListElement.isMissing()) {
                            stringBuffer.append(this.fCreateLabel);
                        } else {
                            stringBuffer.append(this.fNewLabel);
                        }
                    }
                    return stringBuffer.toString();
                }
                if (ZipFileFilter.isZipPath(iPath)) {
                    return this.getPathString(iPath, iResource == null);
                }
                return iPath.makeRelative().toString();
            }
            case 4: {
                return this.getVariableString(iPath);
            }
            case 2: {
                return iPath.lastSegment();
            }
            case 5: {
                IIncludePathContainer iIncludePathContainer = PHPProjectOptions.getIncludePathContainer((IPath)iPath, (IProject)iPListElement.getProject());
                if (iIncludePathContainer != null) {
                    return iIncludePathContainer.getDescription();
                }
                IncludePathContainerInitializer includePathContainerInitializer = PHPProjectOptions.getIncludePathContainerInitializer((String)iPath.segment(0));
                if (includePathContainerInitializer != null) {
                    String string = includePathContainerInitializer.getDescription(iPath, iPListElement.getProject());
                    return MessageFormat.format(PHPUIMessages.CPListLabelProvider_unbound_library, string);
                }
                return iPath.toString();
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer(iPath.makeRelative().toString());
                IResource iResource = iPListElement.getResource();
                if (iResource != null && !iResource.exists()) {
                    stringBuffer.append(' ');
                    if (iPListElement.isMissing()) {
                        stringBuffer.append(this.fCreateLabel);
                    } else {
                        stringBuffer.append(this.fNewLabel);
                    }
                }
                return stringBuffer.toString();
            }
        }
        return PHPUIMessages.CPListLabelProvider_unknown_element_label;
    }

    private String getPathString(IPath iPath, boolean bl) {
        if (ZipFileFilter.isZipPath(iPath)) {
            IPath iPath2 = iPath.removeLastSegments(1);
            String string = bl ? iPath2.toOSString() : iPath2.makeRelative().toString();
            return MessageFormat.format(PHPUIMessages.CPListLabelProvider_twopart, iPath.lastSegment(), string);
        }
        return bl ? iPath.toOSString() : iPath.makeRelative().toString();
    }

    private String getVariableString(IPath iPath) {
        String string = iPath.makeRelative().toString();
        IPath iPath2 = PHPProjectOptions.getIncludePathVariable((String)iPath.segment(0));
        if (iPath2 != null) {
            String string2 = iPath2.append(iPath.removeFirstSegments(1)).toOSString();
            return MessageFormat.format(PHPUIMessages.CPListLabelProvider_twopart, string, string2);
        }
        return string;
    }

    private ImageDescriptor getCPListElementBaseImage(IPListElement iPListElement) {
        switch (iPListElement.getEntryKind()) {
            case 3: {
                if (iPListElement.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: {
                IResource iResource = iPListElement.getResource();
                if (iResource == null) {
                    if (iPListElement.getContentKind() == 2) {
                        return this.fExtZipIcon;
                    }
                    return this.fContainerImage;
                }
                if (iResource instanceof IFile) {
                    return this.fZipIcon;
                }
                return this.fFolderImage;
            }
            case 2: {
                return this.fProjectImage;
            }
            case 4: {
                return this.fVariableImage;
            }
            case 5: {
                return this.fContainerImage;
            }
        }
        return null;
    }

    public Image getImage(Object object) {
        if (object instanceof IPListElement) {
            IPListElement iPListElement = (IPListElement)object;
            Object object2 = this.getCPListElementBaseImage(iPListElement);
            if (object2 != null) {
                if (iPListElement.isMissing()) {
                    object2 = new PHPElementImageDescriptor((ImageDescriptor)object2, 32, PHPElementImageDescriptor.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)object2);
            }
        } else {
            if (object instanceof IPListElementAttribute) {
                ((IPListElementAttribute)object).getKey();
                return this.fRegistry.get(this.fVariableImage);
            }
            if (object instanceof IPUserLibraryElement) {
                return this.fRegistry.get(PHPPluginImages.DESC_OBJS_LIBRARY);
            }
        }
        return null;
    }
}

