/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.ui.preferences.includepath.IIncludePathContainerPage;
import org.eclipse.php.ui.preferences.includepath.IIncludePathContainerPageExtension;
import org.eclipse.php.ui.preferences.includepath.IIncludePathContainerPageExtension2;
import org.eclipse.php.ui.preferences.includepath.IncludePathContainerDefaultPage;
import org.eclipse.php.ui.preferences.includepath.IncludePathContainerDescriptor;
import org.eclipse.php.ui.preferences.includepath.IncludePathContainerSelectionPage;
import org.eclipse.php.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class IncludePathContainerWizard
extends Wizard {
    private IncludePathContainerDescriptor fPageDesc;
    private IIncludePathEntry fEntryToEdit;
    private IIncludePathEntry[] fNewEntries;
    private IIncludePathContainerPage fContainerPage;
    private IProject fCurrProject;
    private PHPProjectOptions fCurrOptions;
    private IIncludePathEntry[] fCurrIncludePath;
    private IncludePathContainerSelectionPage fSelectionWizardPage;

    public IncludePathContainerWizard(IIncludePathEntry iIncludePathEntry, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        this(iIncludePathEntry, null, iProject, iIncludePathEntryArray);
    }

    public IncludePathContainerWizard(IncludePathContainerDescriptor includePathContainerDescriptor, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        this(null, includePathContainerDescriptor, iProject, iIncludePathEntryArray);
    }

    private IncludePathContainerWizard(IIncludePathEntry iIncludePathEntry, IncludePathContainerDescriptor includePathContainerDescriptor, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        this.fEntryToEdit = iIncludePathEntry;
        this.fPageDesc = includePathContainerDescriptor;
        this.fNewEntries = null;
        this.fCurrProject = iProject;
        this.fCurrIncludePath = iIncludePathEntryArray;
        String string = iIncludePathEntry == null ? PHPUIMessages.IncludePathContainerWizard_new_title : PHPUIMessages.IncludePathContainerWizard_edit_title;
        this.setWindowTitle(string);
    }

    public IIncludePathEntry getNewEntry() {
        IIncludePathEntry[] iIncludePathEntryArray = this.getNewEntries();
        if (iIncludePathEntryArray != null) {
            return iIncludePathEntryArray[0];
        }
        return null;
    }

    public IIncludePathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof IIncludePathContainerPageExtension2) {
                this.fNewEntries = ((IIncludePathContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                IIncludePathEntry[] iIncludePathEntryArray;
                IIncludePathEntry iIncludePathEntry = this.fContainerPage.getSelection();
                if (iIncludePathEntry != null) {
                    IIncludePathEntry[] iIncludePathEntryArray2 = new IIncludePathEntry[1];
                    iIncludePathEntryArray = iIncludePathEntryArray2;
                    iIncludePathEntryArray2[0] = iIncludePathEntry;
                } else {
                    iIncludePathEntryArray = null;
                }
                this.fNewEntries = iIncludePathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            IncludePathContainerDescriptor[] includePathContainerDescriptorArray = IncludePathContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new IncludePathContainerSelectionPage(includePathContainerDescriptorArray);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new IncludePathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            IncludePathContainerDescriptor[] includePathContainerDescriptorArray = IncludePathContainerDescriptor.getDescriptors();
            IncludePathContainerDescriptor includePathContainerDescriptor = this.findDescriptorPage(includePathContainerDescriptorArray, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(includePathContainerDescriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IIncludePathContainerPage getContainerPage(IncludePathContainerDescriptor includePathContainerDescriptor) {
        IIncludePathContainerPage iIncludePathContainerPage = null;
        if (includePathContainerDescriptor != null) {
            IIncludePathContainerPage iIncludePathContainerPage2 = includePathContainerDescriptor.getPage();
            if (iIncludePathContainerPage2 != null) {
                return iIncludePathContainerPage2;
            }
            try {
                iIncludePathContainerPage = includePathContainerDescriptor.createPage();
            }
            catch (CoreException coreException) {
                this.handlePageCreationFailed(coreException);
                iIncludePathContainerPage = null;
            }
        }
        if (iIncludePathContainerPage == null) {
            iIncludePathContainerPage = new IncludePathContainerDefaultPage();
            if (includePathContainerDescriptor != null) {
                includePathContainerDescriptor.setPage(iIncludePathContainerPage);
            }
        }
        if (iIncludePathContainerPage instanceof IIncludePathContainerPageExtension) {
            ((IIncludePathContainerPageExtension)((Object)iIncludePathContainerPage)).initialize(this.fCurrProject, this.fCurrIncludePath);
        }
        iIncludePathContainerPage.setSelection(this.fEntryToEdit);
        iIncludePathContainerPage.setWizard((IWizard)this);
        return iIncludePathContainerPage;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.fSelectionWizardPage) {
            IncludePathContainerDescriptor includePathContainerDescriptor = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(includePathContainerDescriptor);
            return this.fContainerPage;
        }
        return super.getNextPage(iWizardPage);
    }

    private void handlePageCreationFailed(CoreException coreException) {
        String string = PHPUIMessages.IncludePathContainerWizard_pagecreationerror_title;
        String string2 = PHPUIMessages.IncludePathContainerWizard_pagecreationerror_message;
        ExceptionHandler.handle(coreException, this.getShell(), string, string2);
    }

    private IncludePathContainerDescriptor findDescriptorPage(IncludePathContainerDescriptor[] includePathContainerDescriptorArray, IIncludePathEntry iIncludePathEntry) {
        int n = 0;
        while (n < includePathContainerDescriptorArray.length) {
            if (includePathContainerDescriptorArray[n].canEdit(iIncludePathEntry)) {
                return includePathContainerDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            IncludePathContainerDescriptor[] includePathContainerDescriptorArray = this.fSelectionWizardPage.getContainers();
            int n = 0;
            while (n < includePathContainerDescriptorArray.length) {
                includePathContainerDescriptorArray[n].dispose();
                ++n;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, IncludePathContainerWizard includePathContainerWizard) {
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)includePathContainerWizard);
        PixelConverter pixelConverter = new PixelConverter((Control)shell);
        wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
        wizardDialog.create();
        return wizardDialog.open();
    }
}

