/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.ui.preferences.includepath.IPVariableElementLabelProvider;
import org.eclipse.php.ui.preferences.includepath.ZipFileSelectionDialog;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IListAdapter;
import org.eclipse.php.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.php.ui.wizards.fields.SelectionButtonDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewVariableEntryDialog
extends StatusDialog {
    private final int IDX_EXTEND = 0;
    private ListDialogField fVariablesList;
    private boolean fCanExtend;
    private boolean fIsValidSelection;
    private IPath[] fResultPaths;
    private SelectionButtonDialogField fConfigButton;

    public NewVariableEntryDialog(Shell shell) {
        super(shell);
        this.setTitle(PHPUIMessages.NewVariableEntryDialog_title);
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
        this.updateStatus((IStatus)new StatusInfo(4, ""));
        String[] stringArray = new String[]{PHPUIMessages.NewVariableEntryDialog_vars_extend};
        VariablesAdapter variablesAdapter = new VariablesAdapter();
        IPVariableElementLabelProvider iPVariableElementLabelProvider = new IPVariableElementLabelProvider(false);
        this.fVariablesList = new ListDialogField(variablesAdapter, stringArray, (ILabelProvider)iPVariableElementLabelProvider);
        this.fVariablesList.setDialogFieldListener(variablesAdapter);
        this.fVariablesList.setLabelText(PHPUIMessages.NewVariableEntryDialog_vars_label);
        this.fVariablesList.enableButton(0, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof IPVariableElement && object2 instanceof IPVariableElement) {
                    return ((IPVariableElement)object).getName().compareTo(((IPVariableElement)object2).getName());
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.fConfigButton = new SelectionButtonDialogField(8);
        this.fConfigButton.setLabelText(PHPUIMessages.NewVariableEntryDialog_configbutton_label);
        this.fConfigButton.setDialogFieldListener(variablesAdapter);
        this.initializeElements();
        this.fCanExtend = false;
        this.fIsValidSelection = false;
        this.fResultPaths = null;
    }

    private void initializeElements() {
        String[] stringArray = PHPProjectOptions.getIncludePathVariableNames();
        ArrayList<IPVariableElement> arrayList = new ArrayList<IPVariableElement>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            IPath iPath = PHPProjectOptions.getIncludePathVariable((String)string);
            if (iPath != null) {
                arrayList.add(new IPVariableElement(string, iPath, false));
            }
            ++n;
        }
        this.fVariablesList.setElements(arrayList);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.php.ui.new_variable_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        this.fVariablesList.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fVariablesList.getLabelControl(null), 2);
        GridData gridData = (GridData)this.fVariablesList.getListControl(null).getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(256));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fConfigButton.doFillIntoGrid(composite3, 1);
        NewVariableEntryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public IPath[] getResult() {
        return this.fResultPaths;
    }

    private void doDoubleClick() {
        if (this.fIsValidSelection) {
            this.okPressed();
        } else if (this.fCanExtend) {
            this.extendButtonPressed();
        }
    }

    private void doSelectionChanged() {
        boolean bl = true;
        boolean bl2 = false;
        StatusInfo statusInfo = new StatusInfo();
        List list = this.fVariablesList.getSelectedElements();
        int n = list.size();
        if (n > 0) {
            this.fResultPaths = new Path[n];
            int n2 = 0;
            while (n2 < n) {
                IPVariableElement iPVariableElement = (IPVariableElement)list.get(n2);
                this.fResultPaths[n2] = new Path(iPVariableElement.getName());
                if (!iPVariableElement.getPath().toFile().isFile()) {
                    statusInfo.setInfo(PHPUIMessages.NewVariableEntryDialog_info_isfolder);
                    bl2 = true;
                }
                ++n2;
            }
        } else {
            bl = false;
            statusInfo.setInfo(PHPUIMessages.NewVariableEntryDialog_info_noselection);
        }
        if (bl && n > 1) {
            String string = MessageFormat.format(PHPUIMessages.NewVariableEntryDialog_info_selected, String.valueOf(n));
            statusInfo.setInfo(string);
        }
        this.fCanExtend = n == 1 && bl2;
        this.fVariablesList.enableButton(0, this.fCanExtend);
        this.updateStatus((IStatus)statusInfo);
        this.fIsValidSelection = bl;
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(bl);
        }
    }

    private IPath[] chooseExtensions(IPVariableElement iPVariableElement) {
        File file = iPVariableElement.getPath().toFile();
        ZipFileSelectionDialog zipFileSelectionDialog = new ZipFileSelectionDialog(this.getShell(), true, false);
        zipFileSelectionDialog.setTitle(PHPUIMessages.NewVariableEntryDialog_ExtensionDialog_title);
        zipFileSelectionDialog.setMessage(MessageFormat.format(PHPUIMessages.NewVariableEntryDialog_ExtensionDialog_description, iPVariableElement.getName()));
        zipFileSelectionDialog.setInput(file);
        if (zipFileSelectionDialog.open() == 0) {
            Object[] objectArray = zipFileSelectionDialog.getResult();
            IPath[] iPathArray = new IPath[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                IPath iPath = Path.fromOSString((String)((File)objectArray[n]).getPath());
                Path path = new Path(iPVariableElement.getName());
                int n2 = iPVariableElement.getPath().segmentCount();
                while (n2 < iPath.segmentCount()) {
                    path = path.append(iPath.segment(n2));
                    ++n2;
                }
                iPathArray[n] = path;
                ++n;
            }
            return iPathArray;
        }
        return null;
    }

    protected final void extendButtonPressed() {
        IPath[] iPathArray;
        List list = this.fVariablesList.getSelectedElements();
        if (list.size() == 1 && (iPathArray = this.chooseExtensions((IPVariableElement)list.get(0))) != null) {
            this.fResultPaths = iPathArray;
            super.buttonPressed(0);
        }
    }

    protected final void configButtonPressed() {
        String string = "org.eclipse.php.ui.preferences.IncludePathVariables";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, null).open();
        this.initializeElements();
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            switch (n) {
                case 0: {
                    NewVariableEntryDialog.this.extendButtonPressed();
                }
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
            NewVariableEntryDialog.this.doSelectionChanged();
        }

        public void doubleClicked(ListDialogField listDialogField) {
            NewVariableEntryDialog.this.doDoubleClick();
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == NewVariableEntryDialog.this.fConfigButton) {
                NewVariableEntryDialog.this.configButtonPressed();
            }
        }
    }
}

