/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.includepath;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.ui.preferences.includepath.VariableBlock;
import org.eclipse.php.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class VariablePathDialogField
extends StringButtonDialogField {
    private Button fBrowseVariableButton;
    private String fVariableButtonLabel;

    public VariablePathDialogField(IStringButtonAdapter iStringButtonAdapter) {
        super(iStringButtonAdapter);
    }

    public void setVariableButtonLabel(String string) {
        this.fVariableButtonLabel = string;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)VariablePathDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)VariablePathDialogField.gridDataForText(n - 3));
        Button button = this.getBrowseVariableControl(composite);
        button.setLayoutData((Object)VariablePathDialogField.gridDataForButton(button, 1));
        Button button2 = this.getChangeControl(composite);
        button2.setLayoutData((Object)VariablePathDialogField.gridDataForButton(button2, 1));
        return new Control[]{label, text, button, button2};
    }

    public int getNumberOfControls() {
        return 4;
    }

    public Button getBrowseVariableControl(Composite composite) {
        if (this.fBrowseVariableButton == null) {
            this.assertCompositeNotNull(composite);
            this.fBrowseVariableButton = new Button(composite, 8);
            this.fBrowseVariableButton.setText(this.fVariableButtonLabel);
            this.fBrowseVariableButton.setEnabled(this.isEnabled());
            this.fBrowseVariableButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    VariablePathDialogField.this.chooseVariablePressed();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    VariablePathDialogField.this.chooseVariablePressed();
                }
            });
        }
        return this.fBrowseVariableButton;
    }

    public IPath getPath() {
        return new Path(this.getText());
    }

    public String getVariable() {
        IPath iPath = this.getPath();
        if (!iPath.isEmpty()) {
            return iPath.segment(0);
        }
        return null;
    }

    public IPath getPathExtension() {
        return new Path(this.getText()).removeFirstSegments(1).setDevice(null);
    }

    public IPath getResolvedPath() {
        IPath iPath;
        String string = this.getVariable();
        if (string != null && (iPath = PHPProjectOptions.getIncludePathVariable((String)string)) != null) {
            return iPath.append(this.getPathExtension());
        }
        return null;
    }

    private Shell getShell() {
        if (this.fBrowseVariableButton != null) {
            return this.fBrowseVariableButton.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private void chooseVariablePressed() {
        String string = this.getVariable();
        ChooseVariableDialog chooseVariableDialog = new ChooseVariableDialog(this.getShell(), string);
        if (chooseVariableDialog.open() == 0) {
            IPath iPath = new Path(chooseVariableDialog.getSelectedVariable()).append(this.getPathExtension());
            this.setText(iPath.toString());
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseVariableButton)) {
            this.fBrowseVariableButton.setEnabled(this.isEnabled());
        }
    }

    public static class ChooseVariableDialog
    extends StatusDialog
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private VariableBlock fVariableBlock;

        public ChooseVariableDialog(Shell shell, String string) {
            super(shell);
            int n = this.getShellStyle();
            this.setShellStyle(n | 0x400 | 0x10);
            this.setTitle(PHPUIMessages.VariablePathDialogField_variabledialog_title);
            this.fVariableBlock = new VariableBlock(false, string);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Control control = this.fVariableBlock.createContents(composite2);
            GridData gridData = new GridData(1808);
            gridData.widthHint = this.convertWidthInCharsToPixels(80);
            gridData.heightHint = this.convertHeightInCharsToPixels(15);
            control.setLayoutData((Object)gridData);
            this.fVariableBlock.addDoubleClickListener(this);
            this.fVariableBlock.addSelectionChangedListener(this);
            ChooseVariableDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        protected void okPressed() {
            this.fVariableBlock.performOk();
            super.okPressed();
        }

        public String getSelectedVariable() {
            List list = this.fVariableBlock.getSelectedElements();
            return ((IPVariableElement)list.get(0)).getName();
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            if (this.getStatus().isOK()) {
                this.okPressed();
            }
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            List list = this.fVariableBlock.getSelectedElements();
            StatusInfo statusInfo = new StatusInfo();
            if (list.size() != 1) {
                statusInfo.setError("");
            }
            this.updateStatus((IStatus)statusInfo);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.php.ui.choose_variable_dialog_context");
        }
    }
}

