/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.sourcelookup.containers;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.debug.core.sourcelookup.containers.PHPDirectorySourceContainer;
import org.eclipse.php.debug.core.sourcelookup.containers.PHPExternalArchiveSourceContainer;
import org.eclipse.php.debug.core.sourcelookup.containers.PHPFileSourceContainer;

public class PHPVariableSourceContainer
extends CompositeSourceContainer {
    private IPath fPath;
    private String[] validExtensions;
    private IProject project;

    public PHPVariableSourceContainer(IPath iPath, IProject iProject) {
        this.fPath = iPath;
        this.project = iProject;
        this.updateExtentionList();
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        String string = this.fPath.toString();
        File file = this.getVriableFile(string);
        ISourceContainer[] iSourceContainerArray = new ISourceContainer[1];
        if (file.isDirectory()) {
            iSourceContainerArray[0] = new PHPDirectorySourceContainer(file, false, this.project);
        } else {
            String string2 = file.getName();
            if (string2.toLowerCase().endsWith(".zip")) {
                iSourceContainerArray[0] = new PHPExternalArchiveSourceContainer(file.getPath(), false, this.project);
            } else if (this.isPhpFile(string2)) {
                iSourceContainerArray[0] = new PHPFileSourceContainer(file, this.project);
            }
        }
        return iSourceContainerArray;
    }

    public String getName() {
        return this.fPath.toString();
    }

    public ISourceContainerType getType() {
        return null;
    }

    private File getVriableFile(String string) {
        int n = string.indexOf(47);
        String string2 = "";
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        IPath iPath = PHPProjectOptions.getIncludePathVariable((String)string);
        iPath = iPath.append(string2);
        return iPath.toFile();
    }

    private boolean isPhpFile(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        int n2 = 0;
        while (n2 < this.validExtensions.length) {
            if (string2.equals(this.validExtensions[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void updateExtentionList() {
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.validExtensions = iContentType.getFileSpecs(8);
    }
}

