/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.preferences;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.core.util.UnixChmodUtil;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPexeItem;

public class PHPexes {
    PHPexeItem defaultItem;
    HashMap items = new HashMap();
    public static final String SEPARATOR = ";";
    private static final String EXTENSION_POINT_NAME = "phpExe";
    private static final String PHPEXE_TAG = "phpExe";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String OS_ATTRIBUTE = "os";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.debug.core.preferences.PHPexes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void load(Preferences preferences) {
        String[] stringArray;
        this.items = new HashMap();
        this.loadExtensions();
        String string = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES);
        if (string == null) {
            string = "";
        }
        String[] stringArray2 = string.length() > 0 ? string.split(SEPARATOR) : new String[]{};
        String string2 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS);
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray3 = stringArray = string2.length() > 0 ? string2.split(SEPARATOR) : new String[]{};
        if (!$assertionsDisabled && stringArray2.length != stringArray.length) {
            throw new AssertionError();
        }
        int n = 0;
        while (n < stringArray.length) {
            PHPexeItem pHPexeItem = new PHPexeItem(stringArray2[n], stringArray[n]);
            this.items.put(stringArray2[n], pHPexeItem);
            ++n;
        }
        String string3 = preferences.getString(PHPDebugCorePreferenceNames.DEFAULT_PHP);
        if (string3 != null && string3.length() > 0) {
            this.defaultItem = (PHPexeItem)this.items.get(string3);
        }
        if (this.defaultItem == null && this.items.size() > 0) {
            this.defaultItem = this.getItems()[0];
        }
    }

    public void store(Preferences preferences) {
        PHPexeItem[] pHPexeItemArray = this.getEditableItems();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            PHPexeItem pHPexeItem = pHPexeItemArray[n];
            if (n > 0) {
                stringBuffer.append(SEPARATOR);
                stringBuffer2.append(SEPARATOR);
            }
            stringBuffer.append(pHPexeItem.getLocation().toString());
            stringBuffer2.append(pHPexeItem.getName());
            ++n;
        }
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES, stringBuffer2.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS, stringBuffer.toString());
        String string = this.defaultItem != null ? this.defaultItem.name : "";
        preferences.setValue(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
    }

    public void addItem(PHPexeItem pHPexeItem) {
        this.items.put(pHPexeItem.getName(), pHPexeItem);
    }

    public void removeItem(PHPexeItem pHPexeItem) {
        this.items.remove(pHPexeItem.getName());
    }

    public PHPexeItem getItem(String string) {
        return (PHPexeItem)this.items.get(string);
    }

    public PHPexeItem[] getItems() {
        int n = 0;
        PHPexeItem[] pHPexeItemArray = new PHPexeItem[this.items.size()];
        Iterator iterator = this.items.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PHPexeItem pHPexeItem = this.getItem(string);
            pHPexeItemArray[n++] = pHPexeItem;
        }
        return pHPexeItemArray;
    }

    public PHPexeItem[] getEditableItems() {
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        Iterator iterator = this.items.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PHPexeItem pHPexeItem = this.getItem(string);
            if (!pHPexeItem.isEditable()) continue;
            arrayList.add(pHPexeItem);
        }
        return arrayList.toArray(new PHPexeItem[arrayList.size()]);
    }

    public PHPexeItem getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(PHPexeItem pHPexeItem) {
        this.defaultItem = pHPexeItem;
    }

    public PHPexeItem getItemForLocation(String string) {
        Iterator iterator = this.items.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            PHPexeItem pHPexeItem = this.getItem(string2);
            if (!string.equals(pHPexeItem.location)) continue;
            return pHPexeItem;
        }
        return null;
    }

    public PHPexeItem getItemForFile(String string) {
        Iterator iterator = this.items.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            PHPexeItem pHPexeItem = this.getItem(string2);
            if (!string.equals(pHPexeItem.getPhpEXE().toString())) continue;
            return pHPexeItem;
        }
        return null;
    }

    private void loadExtensions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "phpExe");
        String string = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.startsWith("windows")) {
            string = "Windows";
        } else if (string2.startsWith("linux")) {
            string = "Linux";
        } else if (string2.startsWith("mac")) {
            string = "Mac";
        }
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if ("phpExe".equals(iConfigurationElement.getName())) {
                String string3;
                String string4 = iConfigurationElement.getAttribute(NAME_ATTRIBUTE);
                String string5 = iConfigurationElement.getAttribute(LOCATION_ATTRIBUTE);
                String string6 = iConfigurationElement.getAttribute(VERSION_ATTRIBUTE);
                boolean bl = "true".equalsIgnoreCase(iConfigurationElement.getAttribute(DEFAULT_ATTRIBUTE));
                if (string == null || (string3 = iConfigurationElement.getAttribute(OS_ATTRIBUTE)) == null || string3.equals(string)) {
                    string3 = iConfigurationElement.getDeclaringExtension().getNamespaceIdentifier();
                    StringBuffer stringBuffer = new StringBuffer("platform:/plugin/");
                    stringBuffer.append(string3);
                    if (!string5.startsWith("/")) {
                        stringBuffer.append('/');
                    }
                    stringBuffer.append(string5);
                    try {
                        URL uRL = new URL(stringBuffer.toString());
                        uRL = FileLocator.resolve((URL)uRL);
                        String string7 = uRL.getFile();
                        File file = new File(string7);
                        if (file.exists()) {
                            PHPexeItem pHPexeItem = new PHPexeItem(string4, file, false);
                            pHPexeItem.setVersion(string6);
                            this.items.put(string4, pHPexeItem);
                            if (bl) {
                                this.defaultItem = pHPexeItem;
                            }
                            if (!"Windows".equals(string)) {
                                UnixChmodUtil.chmod((String)string7, (int)493);
                            }
                        } else {
                            PHPDebugPlugin.getDefault().getLog().log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + string5 + " not found in plugin " + string3, null));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        PHPDebugPlugin.getDefault().getLog().log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + string5 + " not found in plugin " + string3, (Throwable)malformedURLException));
                    }
                    catch (IOException iOException) {
                        PHPDebugPlugin.getDefault().getLog().log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + string5 + " not found in plugin " + string3, (Throwable)iOException));
                    }
                }
            }
            ++n;
        }
    }
}

