/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.highlighter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.util.PHPColorHelper;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class PHPLineStyleProvider
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private static Map fColorTypes;

    static {
        PHPLineStyleProvider.initColorTypes();
    }

    private static void initColorTypes() {
        fColorTypes = new HashMap();
        fColorTypes.put("PHP_STRING", "codeStyleNormal");
        fColorTypes.put("PHP_TOKEN", "codeStyleNormal");
        fColorTypes.put("PHP_SEMICOLON", "codeStyleNormal");
        fColorTypes.put("PHP_OPERATOR", "codeStyleNormal");
        fColorTypes.put("PHP_OPENTAG", "editorColorBoundarymaker");
        fColorTypes.put("PHP_CLOSETAG", "editorColorBoundarymaker");
        fColorTypes.put("PHP_LOGICAL_AND", "editorColorKeyword");
        fColorTypes.put("PHP_ARRAY", "editorColorKeyword");
        fColorTypes.put("PHP_AS", "editorColorKeyword");
        fColorTypes.put("PHP_BREAK", "editorColorKeyword");
        fColorTypes.put("PHP_CASE", "editorColorKeyword");
        fColorTypes.put("PHP_CATCH", "editorColorKeyword");
        fColorTypes.put("PHP_CLASS", "editorColorKeyword");
        fColorTypes.put("PHP_CONTINUE", "editorColorKeyword");
        fColorTypes.put("PHP_DECLARE", "editorColorKeyword");
        fColorTypes.put("PHP_DEFAULT", "editorColorKeyword");
        fColorTypes.put("PHP_DO", "editorColorKeyword");
        fColorTypes.put("PHP_ECHO", "editorColorKeyword");
        fColorTypes.put("PHP_ELSE", "editorColorKeyword");
        fColorTypes.put("PHP_ELSEIF", "editorColorKeyword");
        fColorTypes.put("PHP_EMPTY", "editorColorKeyword");
        fColorTypes.put("PHP_ENDDECLARE", "editorColorKeyword");
        fColorTypes.put("PHP_ENDFOR", "editorColorKeyword");
        fColorTypes.put("PHP_ENDFOREACH", "editorColorKeyword");
        fColorTypes.put("PHP_ENDIF", "editorColorKeyword");
        fColorTypes.put("PHP_ENDSWITCH", "editorColorKeyword");
        fColorTypes.put("PHP_EVAL", "editorColorKeyword");
        fColorTypes.put("PHP_EXIT", "editorColorKeyword");
        fColorTypes.put("PHP_EXTENDS", "editorColorKeyword");
        fColorTypes.put("PHP_FOR", "editorColorKeyword");
        fColorTypes.put("PHP_FOREACH", "editorColorKeyword");
        fColorTypes.put("PHP_FUNCTION", "editorColorKeyword");
        fColorTypes.put("PHP_IF", "editorColorKeyword");
        fColorTypes.put("PHP_HALT_COMPILER", "editorColorKeyword");
        fColorTypes.put("PHP_INCLUDE", "editorColorKeyword");
        fColorTypes.put("PHP_INCLUDE_ONCE", "editorColorKeyword");
        fColorTypes.put("PHP_GLOBAL", "editorColorKeyword");
        fColorTypes.put("PHP_LIST", "editorColorKeyword");
        fColorTypes.put("PHP_NEW", "editorColorKeyword");
        fColorTypes.put("PHP_NOT", "editorColorKeyword");
        fColorTypes.put("PHP_LOGICAL_OR", "editorColorKeyword");
        fColorTypes.put("PHP_PRINT", "editorColorKeyword");
        fColorTypes.put("PHP_PUBLIC", "editorColorKeyword");
        fColorTypes.put("PHP_PRIVATE", "editorColorKeyword");
        fColorTypes.put("PHP_PROTECTED", "editorColorKeyword");
        fColorTypes.put("PHP_REQUIRE", "editorColorKeyword");
        fColorTypes.put("PHP_REQUIRE_ONCE", "editorColorKeyword");
        fColorTypes.put("PHP_RETURN", "editorColorKeyword");
        fColorTypes.put("PHP_STATIC", "editorColorKeyword");
        fColorTypes.put("PHP_SWITCH", "editorColorKeyword");
        fColorTypes.put("PHP_TRY", "editorColorKeyword");
        fColorTypes.put("PHP_THROW", "editorColorKeyword");
        fColorTypes.put("PHP_VAR", "editorColorKeyword");
        fColorTypes.put("PHP_WHILE", "editorColorKeyword");
        fColorTypes.put("PHP_LOGICAL_XOR", "editorColorKeyword");
        fColorTypes.put("PHP_ABSTRACT", "editorColorKeyword");
        fColorTypes.put("PHP_CLONE", "editorColorKeyword");
        fColorTypes.put("PHP_FALSE", "editorColorKeyword");
        fColorTypes.put("PHP_FINAL", "editorColorKeyword");
        fColorTypes.put("PHP_DIE", "editorColorKeyword");
        fColorTypes.put("PHP_TRUE", "editorColorKeyword");
        fColorTypes.put("PHP_INSTANCEOF", "editorColorKeyword");
        fColorTypes.put("PHP_UNSET", "editorColorKeyword");
        fColorTypes.put("PHP_SELF", "editorColorKeyword");
        fColorTypes.put("PHP_ISSET", "editorColorKeyword");
        fColorTypes.put("PHP_PARENT", "editorColorKeyword");
        fColorTypes.put("PHP_ENDWHILE", "editorColorKeyword");
        fColorTypes.put("PHP_FROM", "editorColorKeyword");
        fColorTypes.put("PHP_IMPLEMENTS", "editorColorKeyword");
        fColorTypes.put("PHP_INTERFACE", "editorColorKeyword");
        fColorTypes.put("PHP_CONST", "editorColorKeyword");
        fColorTypes.put("PHP_VARIABLE", "editorColorVariable");
        fColorTypes.put("PHP_CONSTANT_ENCAPSED_STRING", "editorColorString");
        fColorTypes.put("PHP_COMMENT", "editorColorComment");
        fColorTypes.put("PHP_COMMENT_START", "editorColorComment");
        fColorTypes.put("PHP_COMMENT_END", "editorColorComment");
        fColorTypes.put("PHP_LINE_COMMENT", "editorColorComment");
        fColorTypes.put("PHP_NUMBER", "editorColorNumber");
        fColorTypes.put("PHP_HEREDOC_TAG", "editorColorHeredoc");
        fColorTypes.put("PHPDOC_VAR", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_SEE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_NAME", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_DESC", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_TODO", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_LINK", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_EXAMPLE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_LICENSE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_PACKAGE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_VERSION", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_ABSTRACT", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_INTERNAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_TUTORIAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_CATEGORY", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_FINAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_SINCE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_PARAM", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_MAGIC", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_RETURN", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_AUTHOR", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_ACCESS", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_IGNORE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_THROWS", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_STATIC", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_GLOBAL", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_SUBPACKAGE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_FILESOURCE", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_EXCEPTION", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_COPYRIGHT", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_STATICVAR", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_DEPRECATED", "editorColorPhpdoc");
        fColorTypes.put("PHPDOC_COMMENT", "editorColorComment");
        fColorTypes.put("PHPDOC_COMMENT_START", "editorColorComment");
        fColorTypes.put("PHPDOC_COMMENT_END", "editorColorComment");
        fColorTypes.put("TASK", "editorColorTask");
    }

    public PHPLineStyleProvider() {
        this.loadColors();
    }

    protected TextAttribute getAttributeFor(ITextRegion iTextRegion) {
        String string;
        TextAttribute textAttribute = null;
        if (iTextRegion != null && (string = iTextRegion.getType()) != null) {
            textAttribute = this.getAttributeFor(string);
        }
        if (textAttribute == null) {
            textAttribute = (TextAttribute)this.getTextAttributes().get("codeStyleNormal");
        }
        return textAttribute;
    }

    protected TextAttribute getAttributeFor(String string) {
        return (TextAttribute)this.getTextAttributes().get(fColorTypes.get(string));
    }

    protected void addTextAttribute(String string) {
        String string2;
        String[] stringArray;
        if (this.getColorPreferences() != null && (stringArray = PHPColorHelper.unpackStylePreferences(string2 = this.getColorPreferences().getString(string))) != null) {
            this.getTextAttributes().put(string, PHPColorHelper.createTextAttribute(stringArray));
        }
    }

    public TextAttribute getTextAttributeForColor(String string) {
        return (TextAttribute)this.getTextAttributes().get(string);
    }

    protected StyleRange createStyleRange(ITextRegionCollection iTextRegionCollection, ITextRegion iTextRegion, TextAttribute textAttribute, int n, int n2) {
        int n3 = iTextRegionCollection.getStartOffset(iTextRegion);
        if (n3 < n) {
            n3 = n;
        }
        int n4 = n + n2;
        int n5 = iTextRegionCollection.getEndOffset(iTextRegion);
        if (n5 > n4) {
            n5 = n4;
        }
        StyleRange styleRange = new StyleRange(n3, n5 - n3, textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle());
        if ((textAttribute.getStyle() & 0x40000000) != 0) {
            styleRange.underline = true;
            styleRange.fontStyle &= 0xBFFFFFFF;
        }
        return styleRange;
    }

    public boolean prepareRegions(ITypedRegion iTypedRegion, int n, int n2, Collection collection) {
        int n3 = iTypedRegion.getOffset();
        int n4 = iTypedRegion.getLength();
        IStructuredDocumentRegion iStructuredDocumentRegion = this.getDocument().getRegionAtCharacterOffset(n3);
        boolean bl = false;
        bl = this.prepareTextRegions(iStructuredDocumentRegion, n3, n4, collection);
        return bl;
    }

    protected boolean prepareTextRegion(ITextRegionCollection iTextRegionCollection, int n, int n2, Collection collection) {
        boolean bl = false;
        int n3 = n + n2 - 1;
        ITextRegion iTextRegion = null;
        ITextRegionList iTextRegionList = iTextRegionCollection.getRegions();
        int n4 = iTextRegionList.size();
        StyleRange styleRange = null;
        int n5 = 0;
        while (n5 < n4) {
            iTextRegion = iTextRegionList.get(n5);
            TextAttribute textAttribute = null;
            TextAttribute textAttribute2 = null;
            if (iTextRegionCollection.getStartOffset(iTextRegion) > n3) break;
            if (iTextRegionCollection.getEndOffset(iTextRegion) > n) {
                if (iTextRegion instanceof ITextRegionCollection) {
                    bl = this.prepareTextRegion((ITextRegionCollection)iTextRegion, n, n2, collection);
                } else {
                    textAttribute = this.getAttributeFor(iTextRegion);
                    if (textAttribute != null) {
                        bl = true;
                        if (styleRange != null && textAttribute2 != null && textAttribute2.equals((Object)textAttribute)) {
                            styleRange.length += iTextRegion.getLength();
                        } else {
                            styleRange = this.createStyleRange(iTextRegionCollection, iTextRegion, textAttribute, n, n2);
                            collection.add(styleRange);
                            textAttribute2 = textAttribute;
                        }
                    } else {
                        textAttribute2 = null;
                    }
                }
            }
            ++n5;
        }
        return bl;
    }

    protected boolean prepareTextRegions(IStructuredDocumentRegion iStructuredDocumentRegion, int n, int n2, Collection collection) {
        boolean bl = false;
        int n3 = n + n2 - 1;
        while (iStructuredDocumentRegion != null && iStructuredDocumentRegion.getStartOffset() <= n3) {
            ITextRegion iTextRegion = null;
            ITextRegionList iTextRegionList = iStructuredDocumentRegion.getRegions();
            int n4 = iTextRegionList.size();
            StyleRange styleRange = null;
            int n5 = 0;
            while (n5 < n4) {
                iTextRegion = iTextRegionList.get(n5);
                TextAttribute textAttribute = null;
                TextAttribute textAttribute2 = null;
                if (iStructuredDocumentRegion.getStartOffset(iTextRegion) > n3) break;
                if (iStructuredDocumentRegion.getEndOffset(iTextRegion) > n) {
                    if (iTextRegion instanceof ITextRegionCollection) {
                        bl = this.prepareTextRegion((ITextRegionCollection)iTextRegion, n, n2, collection);
                    } else {
                        textAttribute = this.getAttributeFor(iTextRegion);
                        if (textAttribute != null) {
                            bl = true;
                            if (styleRange != null && textAttribute2 != null && textAttribute2.equals((Object)textAttribute)) {
                                styleRange.length += iTextRegion.getLength();
                            } else {
                                styleRange = this.createStyleRange((ITextRegionCollection)iStructuredDocumentRegion, iTextRegion, textAttribute, n, n2);
                                collection.add(styleRange);
                                textAttribute2 = textAttribute;
                            }
                        } else {
                            textAttribute2 = null;
                        }
                    }
                }
                ++n5;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        return bl;
    }

    public Map getColorTypesMap() {
        return fColorTypes;
    }

    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            String string = propertyChangeEvent.getProperty();
            if ("codeStyleNormal".equals(string) || "editorColorBoundarymaker".equals(string) || "editorColorKeyword".equals(string) || "editorColorVariable".equals(string) || "editorColorString".equals(string) || "editorColorComment".equals(string) || "editorColorPhpdoc".equals(string) || "editorColorNumber".equals(string) || "editorColorHeredoc".equals(string) || "editorColorTask".equals(string)) {
                this.addTextAttribute(string);
            }
        } else {
            this.loadColors();
        }
        super.handlePropertyChange(propertyChangeEvent);
    }

    public void release() {
        super.release();
    }

    public void loadColors() {
        this.clearColors();
        this.addTextAttribute("codeStyleNormal");
        this.addTextAttribute("editorColorBoundarymaker");
        this.addTextAttribute("editorColorKeyword");
        this.addTextAttribute("editorColorVariable");
        this.addTextAttribute("editorColorString");
        this.addTextAttribute("editorColorComment");
        this.addTextAttribute("editorColorPhpdoc");
        this.addTextAttribute("editorColorNumber");
        this.addTextAttribute("editorColorHeredoc");
        this.addTextAttribute("editorColorTask");
    }

    protected void clearColors() {
        this.getTextAttributes().clear();
    }

    protected IPreferenceStore getColorPreferences() {
        return PreferenceConstants.getPreferenceStore();
    }
}

