/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.preferences.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Assert;
import org.eclipse.php.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.ui.preferences.ui.IPreferenceConfigurationBlock;
import org.eclipse.php.ui.util.ScrolledPageContent;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.util.StatusUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class TypingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private PreferencePage fMainPreferencePage;
    private String autoIndentDetails = "";
    private Link formatterPageLink;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            TypingConfigurationBlock.this.fStore.setValue((String)TypingConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private ArrayList fMasterSlaveListeners = new ArrayList();
    protected static final int INDENT = 20;
    private Map fTextFields = new HashMap();

    public TypingConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)preferencePage);
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fMainPreferencePage = preferencePage;
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fStore = overlayPreferenceStore;
    }

    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        String string;
        Button button;
        Iterator<Object> iterator = this.fCheckBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            button = (Button)iterator.next();
            string = (String)this.fCheckBoxes.get(button);
            button.setSelection(this.fStore.getBoolean(string));
        }
        iterator = this.fTextFields.keySet().iterator();
        while (iterator.hasNext()) {
            button = (Text)iterator.next();
            string = (String)this.fTextFields.get(button);
            button.setText(this.fStore.getString(string));
        }
        iterator = this.fMasterSlaveListeners.iterator();
        while (iterator.hasNext()) {
            button = (SelectionListener)iterator.next();
            button.widgetSelected(null);
        }
        this.updateStatus(new StatusInfo());
    }

    protected void updateStatus(IStatus iStatus) {
        if (this.fMainPreferencePage == null) {
            return;
        }
        this.fMainPreferencePage.setValid(iStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, iStatus);
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.initializeFields();
    }

    public void dispose() {
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closeStrings"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closeBraces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closeBrackets"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closePhpDocsAndComments"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "autoAddPhpDocTags"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "smart_tab"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite, 768);
        scrolledPageContent.setExpandHorizontal(true);
        scrolledPageContent.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledPageContent, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createSubsection(composite2, PHPUIMessages.typingPage_autoClose_title);
        this.addAutoclosingSection(composite3);
        Composite composite4 = this.createSubsection(composite2, PHPUIMessages.typingPage_smartTab_title);
        this.addSmartTabSection(composite4);
        scrolledPageContent.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledPageContent.setMinSize(point.x, point.y);
        return scrolledPageContent;
    }

    private void addSmartTabSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        String string = PHPUIMessages.PHPEditorPreferencePage_typing_smartTab;
        this.addCheckBox(composite, string, "smart_tab", 0);
        this.createAutoIndentMessage(composite);
    }

    private void createAutoIndentMessage(Composite composite) {
        String string = PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_tooltip;
        char c = FormatPreferencesSupport.getInstance().getIndentationChar(null);
        if (c == '\t') {
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, new String[]{Integer.toString(4)});
        } else {
            int n = FormatPreferencesSupport.getInstance().getIndentationSize(null);
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_others_text, new String[]{Integer.toString(4), Integer.toString(n), "space"});
        }
        this.formatterPageLink = new Link(composite, 0);
        this.formatterPageLink.setText(this.autoIndentDetails);
        this.formatterPageLink.setToolTipText(string);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 300;
        this.formatterPageLink.setLayoutData((Object)gridData);
        this.formatterPageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)TypingConfigurationBlock.this.formatterPageLink.getShell(), (String)"org.eclipse.php.internal.ui.preferences.PHPFormatterPreferencePage", null, null);
            }
        });
    }

    private Composite createSubsection(Composite composite, String string) {
        Group group = new Group(composite, 32);
        group.setText(string);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)gridData);
        return group;
    }

    private void addAutoclosingSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        String string = PHPUIMessages.typingPage_autoClose_string;
        this.addCheckBox(composite, string, "closeStrings", 0);
        string = PHPUIMessages.typingPage_autoClose_brackets;
        this.addCheckBox(composite, string, "closeBrackets", 0);
        string = PHPUIMessages.typingPage_autoClose_braces;
        this.addCheckBox(composite, string, "closeBraces", 0);
        string = PHPUIMessages.typingPage_autoClose_phpDoc_and_commens;
        Button button = this.addCheckBox(composite, string, "closePhpDocsAndComments", 0);
        string = PHPUIMessages.typingPage_autoAdd_phpDoc_tags;
        Button button2 = this.addCheckBox(composite, string, "autoAddPhpDocTags", 0);
        this.createDependency(button, (Control)button2);
    }

    protected Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.makeScrollableCompositeAware((Control)button);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite(control);
        if (scrolledPageContent != null) {
            scrolledPageContent.adaptChild(control);
        }
    }

    protected final ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    protected void createDependency(Button button, Control control) {
        this.createDependency(button, new Control[]{control});
    }

    protected void createDependency(final Button button, final Control[] controlArray) {
        Assert.isTrue((controlArray.length > 0 ? 1 : 0) != 0);
        TypingConfigurationBlock.indent(controlArray[0]);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                int n = 0;
                while (n < controlArray.length) {
                    controlArray[n].setEnabled(bl);
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        button.addSelectionListener(selectionListener);
        this.fMasterSlaveListeners.add(selectionListener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    public void refreshValues() {
        char c = FormatPreferencesSupport.getInstance().getIndentationChar(null);
        if (c == '\t') {
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, new String[]{Integer.toString(4)});
        } else {
            int n = FormatPreferencesSupport.getInstance().getIndentationSize(null);
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_others_text, new String[]{Integer.toString(4), Integer.toString(n), "space"});
        }
        this.formatterPageLink.setText(this.autoIndentDetails);
    }
}

