/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.launching.LaunchUtil;
import org.eclipse.php.server.ui.ServerTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PHPServerTab
extends ServerTab {
    protected Button runWithDebugger;
    protected Button openBrowser;
    protected boolean isRunWithDebugInfo;
    protected boolean isOpenInBrowser;
    private String mode;

    public void createExtensionControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(256);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.openBrowser = new Button(composite2, 32);
        this.openBrowser.setText(PHPDebugUIMessages.PHPdebug_open_in_browser);
        GridData gridData2 = new GridData(768);
        this.openBrowser.setLayoutData((Object)gridData2);
        this.openBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.getSource();
                PHPServerTab.this.isOpenInBrowser = button.getSelection();
                PHPServerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.mode = this.getLaunchConfigurationDialog().getMode();
        if ("run".equals(this.mode)) {
            this.runWithDebugger = new Button(composite2, 32);
            this.runWithDebugger.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
            gridData2 = new GridData(768);
            this.runWithDebugger.setLayoutData((Object)gridData2);
            this.runWithDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.getSource();
                    PHPServerTab.this.isRunWithDebugInfo = button.getSelection();
                    PHPServerTab.this.updateLaunchConfigurationDialog();
                }
            });
        }
    }

    protected void initializeExtensionControls(ILaunchConfiguration iLaunchConfiguration) {
        try {
            this.isOpenInBrowser = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            this.openBrowser.setSelection(this.isOpenInBrowser);
            if (this.runWithDebugger != null) {
                this.isRunWithDebugInfo = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
                this.runWithDebugger.setSelection(this.isRunWithDebugInfo);
            }
        }
        catch (Exception exception) {
            Logger.log(4, "Error reading configuration", exception);
        }
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", this.isOpenInBrowser);
        if (this.runWithDebugger != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", this.isRunWithDebugInfo);
        }
    }

    protected boolean isValidExtension(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    protected void createServerSelectionControl(Composite composite) {
        PHPDebugPlugin.createDefaultPHPServer();
        super.createServerSelectionControl(composite);
    }

    protected void initializeURLControl(String string, String string2) {
        if (this.server == null) {
            return;
        }
        if (this.server.getName().equals("Default PHP Web Server")) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource iResource = iWorkspaceRoot.findMember(string2);
            if (iResource == null) {
                super.initializeURLControl(string, string2);
                return;
            }
            IProject iProject = iResource.getProject();
            String string3 = "";
            string3 = iProject == null ? PHPDebugPlugin.getWorkspaceURL() : PHPProjectPreferences.getDefaultServerURL((IProject)iProject);
            if (string3.equals("")) {
                string3 = "http://localhost";
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append("/");
            stringBuffer.append(string);
            if (string != "") {
                stringBuffer.append("/");
            }
            stringBuffer.append(string2);
            this.fURL.setText(stringBuffer.toString());
        } else {
            super.initializeURLControl(string, string2);
        }
    }

    public String[] getRequiredNatures() {
        return LaunchUtil.getRequiredNatures();
    }

    public String[] getFileExtensions() {
        return LaunchUtil.getFileExtensions();
    }
}

