/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.debug.ui.launching.LaunchUtil;
import org.eclipse.php.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.debug.ui.preferences.phps.PHPsComboBlock;
import org.eclipse.php.server.ui.ServerUtilities;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    public static final String FIRST_EDIT = "editedByPHPExecutableLaunchTab";
    private Text argumentField;
    private Button argumentVariablesButton;
    private boolean enableDebugInfoOption;
    private boolean enableFileSelection = true;
    private final ISelectionChangedListener fCheckListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    private Button fileLocationButton;
    protected WidgetListener fListener = new WidgetListener();
    private Text locationField;
    protected PHPsComboBlock phpsComboBlock = new PHPsComboBlock();
    protected Button overrideBreakpiontSettings;
    protected Button breakOnFirstLine;
    private Button runWithDebugInfo;
    protected SelectionAdapter selectionAdapter;

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    protected void createArgumentComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPDebugUIMessages.Arguments;
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setFont(composite.getFont());
        this.argumentField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.argumentField.setLayoutData((Object)gridData);
        this.argumentField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentField, group.getText());
        Composite composite2 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridData = new GridData(128);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.argumentVariablesButton = this.createPushButton(composite2, PHPDebugUIMessages.Variables, null);
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    private void createBreakControl(Composite composite) {
        String string = this.getLaunchConfigurationDialog().getMode();
        if ("debug".equals(string)) {
            Group group = new Group(composite, 0);
            group.setText("Breakpoint");
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            GridData gridData = new GridData(768);
            group.setLayout((Layout)gridLayout);
            group.setLayoutData((Object)gridData);
            this.overrideBreakpiontSettings = this.createCheckButton((Composite)group, "Override project/workspace 'Break at First Line' setting");
            this.breakOnFirstLine = this.createCheckButton((Composite)group, "Break at First Line");
            GridData gridData2 = (GridData)this.breakOnFirstLine.getLayoutData();
            gridData2.horizontalIndent = 20;
            this.overrideBreakpiontSettings.addSelectionListener((SelectionListener)this.fListener);
            this.breakOnFirstLine.addSelectionListener((SelectionListener)this.fListener);
        }
    }

    public void createControl(Composite composite) {
        if (this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.setEnableDebugInfoOption(true);
        }
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.createLocationComponent(composite2);
        if (this.enableFileSelection) {
            this.createArgumentComponent(composite2);
        }
        if (this.enableDebugInfoOption) {
            this.createDebugInfoComponent(composite2);
        }
        this.createBreakControl(composite2);
        this.createVerticalSpacer(composite2, 1);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createDebugInfoComponent(Composite composite) {
        this.runWithDebugInfo = new Button(composite, 32);
        this.runWithDebugInfo.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.runWithDebugInfo.setLayoutData((Object)gridData);
        this.runWithDebugInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createLocationComponent(Composite composite) {
        this.phpsComboBlock.setSpecificPHPexeDescriptor(this.getSpecificPHPexeDescriptor());
        this.phpsComboBlock.createControl(composite);
        Control control = this.phpsComboBlock.getControl();
        this.phpsComboBlock.addSelectionChangedListener(this.fCheckListener);
        GridData gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    private boolean fileExists(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        Path path = new Path(string);
        boolean bl = ResourcesPlugin.getWorkspace().getRoot().exists((IPath)path);
        return bl;
    }

    protected PHPexeDescriptor getDefaultPHPexeDescriptor() {
        return null;
    }

    public String getName() {
        return "PHP Executable";
    }

    protected PHPexeDescriptor getSpecificPHPexeDescriptor() {
        return null;
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String string = fileDialog.open();
        if (string != null) {
            this.locationField.setText(string);
        }
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateLaunchConfigurationDialog();
    }

    private void handleVariablesButtonSelected(Text text) {
        IFile iFile = null;
        IResource iResource = ServerUtilities.getFileFromDialog(null, (Shell)this.getShell(), (String[])LaunchUtil.getFileExtensions(), (String[])LaunchUtil.getRequiredNatures());
        if (iResource instanceof IFile) {
            iFile = (IFile)iResource;
        }
        if (iFile != null) {
            text.setText(iFile.getFullPath().toString());
        }
    }

    protected void handleBreakpointOverride() {
        this.breakOnFirstLine.setEnabled(this.overrideBreakpiontSettings.getSelection());
        this.updateLaunchConfigurationDialog();
    }

    protected void handleBreakButtonSelected() {
        this.updateLaunchConfigurationDialog();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.updateLocation(iLaunchConfiguration);
        if (this.enableDebugInfoOption) {
            this.updateDebugInfoOption(iLaunchConfiguration);
        }
        if (this.enableFileSelection) {
            this.updateArgument(iLaunchConfiguration);
        }
        try {
            boolean bl = iLaunchConfiguration.getAttribute("overrideFirstLineBreakpoint", false);
            if (this.overrideBreakpiontSettings != null) {
                this.overrideBreakpiontSettings.setSelection(bl);
            }
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setEnabled(bl);
                this.breakOnFirstLine.setSelection(iLaunchConfiguration.getAttribute("firstLineBreakpoint", false));
            }
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        this.isValid(iLaunchConfiguration);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        Object object;
        block8: {
            this.setErrorMessage(null);
            try {
                String string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
                boolean bl = true;
                try {
                    object = new File(string);
                    if (!((File)object).exists()) {
                        bl = false;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    bl = false;
                }
                if (bl) break block8;
                this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                return false;
            }
            catch (CoreException coreException) {}
        }
        if (this.enableFileSelection && !this.fileExists((String)(object = iLaunchConfiguration.getAttribute("ATTR_FILE", "")))) {
            this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.phpsComboBlock.getSelectedLocation();
        if (string.length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string);
        }
        String string2 = null;
        if (!this.enableFileSelection || (string2 = this.argumentField.getText().trim()).length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string2);
        }
        boolean bl = this.enableDebugInfoOption ? this.runWithDebugInfo.getSelection() : true;
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        if (this.overrideBreakpiontSettings != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("overrideFirstLineBreakpoint", this.overrideBreakpiontSettings.getSelection());
        }
        if (this.breakOnFirstLine != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        try {
            String string = iLaunchConfigurationWorkingCopy.getAttribute("ATTR_LOCATION", "");
            if (string.equals("")) {
                PHPexes pHPexes = new PHPexes();
                pHPexes.load(PHPDebugUIPlugin.getDefault().getPluginPreferences());
                PHPexeItem pHPexeItem = pHPexes.getDefaultItem();
                if (pHPexeItem == null) {
                    return;
                }
                string = pHPexeItem.getPhpEXE().toString();
                iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string);
                iLaunchConfigurationWorkingCopy.setAttribute("overrideFirstLineBreakpoint", false);
            }
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error setting default configuration", coreException);
        }
    }

    public void setEnableDebugInfoOption(boolean bl) {
        if (bl == this.enableDebugInfoOption) {
            return;
        }
        this.enableDebugInfoOption = true;
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setVisible(bl);
        }
    }

    public void setEnableFileSelection(boolean bl) {
        if (bl == this.enableFileSelection) {
            return;
        }
        this.enableFileSelection = bl;
        if (this.argumentVariablesButton != null) {
            this.argumentVariablesButton.setVisible(bl);
        }
        if (this.argumentField != null) {
            this.argumentField.setVisible(bl);
        }
    }

    protected void updateArgument(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        if (this.argumentField != null) {
            this.argumentField.setText(string);
        }
    }

    protected void updateDebugInfoOption(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = PHPDebugPlugin.getDebugInfoOption();
        try {
            bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setSelection(bl);
        }
    }

    protected void updateLocation(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        PHPexes pHPexes = this.phpsComboBlock.getPHPs(true);
        PHPexeItem pHPexeItem = string != null && string.length() > 0 ? pHPexes.getItemForFile(string) : pHPexes.getDefaultItem();
        this.phpsComboBlock.setPHPexe(pHPexeItem);
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (object == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleVariablesButtonSelected(PHPExecutableLaunchTab.this.argumentField);
            } else if (object == PHPExecutableLaunchTab.this.overrideBreakpiontSettings) {
                PHPExecutableLaunchTab.this.handleBreakpointOverride();
            } else if (object == PHPExecutableLaunchTab.this.breakOnFirstLine) {
                PHPExecutableLaunchTab.this.handleBreakButtonSelected();
            }
        }
    }
}

