/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.presentation;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.core.containers.LocalFileStorage;
import org.eclipse.php.core.containers.ZipEntryStorage;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.debug.core.model.PHPStackFrame;
import org.eclipse.php.debug.core.model.PHPThread;
import org.eclipse.php.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.debug.ui.sourcelookup.PHPSourceNotFoundEditorInput;
import org.eclipse.php.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.ui.containers.ZipEntryStorageEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PHPModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public void setAttribute(String string, Object object) {
    }

    public Image getImage(Object object) {
        return null;
    }

    public String getText(Object object) {
        if (object instanceof PHPDebugTarget) {
            return this.getTargetText((PHPDebugTarget)object);
        }
        if (object instanceof PHPThread) {
            return this.getThreadText((PHPThread)object);
        }
        if (object instanceof PHPStackFrame) {
            return this.getStackFrameText((PHPStackFrame)object);
        }
        if (object instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)object;
            IMarker iMarker = pHPLineBreakpoint.getMarker();
            IResource iResource = iMarker.getResource();
            if (iResource instanceof IFile) {
                return null;
            }
            if (iResource instanceof IWorkspaceRoot) {
                try {
                    String string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Include_Storage");
                    Integer n = (Integer)iMarker.getAttribute("lineNumber");
                    return String.valueOf(string) + " [line: " + n.toString() + "]";
                }
                catch (CoreException coreException) {
                    Logger.logException("Unexpected error in PHPModelPresentation", coreException);
                }
            }
        }
        return null;
    }

    private String getTargetText(PHPDebugTarget pHPDebugTarget) {
        String string = "";
        if (pHPDebugTarget.isTerminated()) {
            string = MessageFormat.format(PHPDebugUIMessages.MPresentation_Terminated_1, new Object[0]);
        }
        return String.valueOf(string) + PHPDebugUIMessages.MPresentation_PHP_APP_1;
    }

    private String getThreadText(PHPThread pHPThread) {
        PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)pHPThread.getDebugTarget();
        String string = "";
        try {
            string = pHPDebugTarget.getName();
        }
        catch (DebugException debugException) {
            Logger.logException("PHPModelPresentation error getting target name", debugException);
        }
        if (pHPThread.isStepping()) {
            string = String.valueOf(string) + PHPDebugUIMessages.MPresentation_Stepping_1;
        } else if (pHPThread.isSuspended()) {
            IBreakpoint[] iBreakpointArray = pHPThread.getBreakpoints();
            if (iBreakpointArray.length == 0) {
                string = String.valueOf(string) + PHPDebugUIMessages.MPresentation_Suspended_1;
            } else {
                IBreakpoint iBreakpoint = iBreakpointArray[0];
                if (iBreakpoint instanceof PHPLineBreakpoint) {
                    string = String.valueOf(string) + PHPDebugUIMessages.MPresentation_SLineBreakpoint_1;
                }
            }
        } else if (pHPThread.isTerminated()) {
            string = String.valueOf(PHPDebugUIMessages.MPresentation_Terminated_1) + string;
        }
        return string;
    }

    private String getStackFrameText(PHPStackFrame pHPStackFrame) {
        try {
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(PHPDebugUIMessages.MPresentation_File_1) + pHPStackFrame.getSourceName());
            stringBuffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + pHPStackFrame.getLineNumber());
            return stringBuffer.toString();
        }
        catch (DebugException debugException) {
            Logger.logException("Unexpected error in PHPModelPresentation", debugException);
            return null;
        }
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        String string = "";
        try {
            string = iValue.getValueString();
        }
        catch (DebugException debugException) {}
        iValueDetailListener.detailComputed(iValue, string);
    }

    public IEditorInput getEditorInput(Object object) {
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)object;
            IMarker iMarker = pHPLineBreakpoint.getMarker();
            IResource iResource = iMarker.getResource();
            if (iResource instanceof IFile) {
                return new FileEditorInput((IFile)iResource);
            }
            if (iResource instanceof IWorkspaceRoot) {
                try {
                    String string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Include_Storage");
                    String string2 = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Include_Storage_Type");
                    String string3 = (String)iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
                    String string4 = iMarker.getAttribute("org.eclipse.php.debug.core.project", "");
                    IProject iProject = PHPDebugUIPlugin.getProject(string4);
                    if ("org.eclipse.php.debug.core.lfile".equals(string2)) {
                        File file = new File(string3);
                        LocalFileStorage localFileStorage = new LocalFileStorage(file);
                        localFileStorage.setProject(iProject);
                        return new LocalFileStorageEditorInput(localFileStorage);
                    }
                    if ("org.eclipse.php.debug.core.zip".equals(string2)) {
                        int n = string3.lastIndexOf(string);
                        String string5 = string3.substring(0, n - 1);
                        ZipFile zipFile = new ZipFile(string5);
                        ZipEntry zipEntry = new ZipEntry(string);
                        ZipEntryStorage zipEntryStorage = new ZipEntryStorage(zipFile, zipEntry);
                        zipEntryStorage.setProject(iProject);
                        return new ZipEntryStorageEditorInput(zipEntryStorage);
                    }
                }
                catch (CoreException coreException) {
                    Logger.logException("Unexpected error in PHPModelPresentation", coreException);
                }
                catch (IOException iOException) {
                    Logger.logException("Unexpected error in PHPModelPresentation", iOException);
                }
            }
        }
        if (object instanceof ZipEntryStorage) {
            return new ZipEntryStorageEditorInput((ZipEntryStorage)object);
        }
        if (object instanceof LocalFileStorage) {
            return new LocalFileStorageEditorInput((LocalFileStorage)object);
        }
        if (object instanceof PHPSourceNotFoundInput) {
            return new PHPSourceNotFoundEditorInput((PHPSourceNotFoundInput)object);
        }
        return null;
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        if (iEditorInput instanceof PHPSourceNotFoundEditorInput) {
            return "org.eclipse.php.debug.SourceNotFoundEditor";
        }
        if (object instanceof IFile || object instanceof ILineBreakpoint || object instanceof ZipEntryStorage || object instanceof LocalFileStorage) {
            return "org.eclipse.php.editor";
        }
        return null;
    }
}

