/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.projectOutline;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.core.phpModel.parser.ModelListener;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.ui.StandardPHPElementContentProvider;
import org.eclipse.php.ui.projectOutline.ProjectOutlinePart;
import org.eclipse.swt.widgets.Control;

public class ProjectOutlineContentProvider
extends StandardPHPElementContentProvider
implements ModelListener {
    private ProjectOutlinePart fPart;
    private TreeViewer fViewer;
    public static final int CLASSES = 1;
    public static final int FUNCTIONS = 2;
    public static final int CONSTANTS = 3;
    Object[] groupNodes;
    IProject fStoredProject;

    public ProjectOutlineContentProvider(ProjectOutlinePart projectOutlinePart, boolean bl) {
        this.fPart = projectOutlinePart;
        this.fViewer = projectOutlinePart.getViewer();
    }

    public Object[] getChildrenInternal(Object object) {
        if (object instanceof IProject) {
            if (this.groupNodes == null || (IProject)object != this.fStoredProject) {
                this.groupNodes = this.getOutlineChildren((IProject)object);
                this.fStoredProject = (IProject)object;
            }
            return this.groupNodes;
        }
        if (object instanceof OutlineNode) {
            OutlineNode outlineNode = (OutlineNode)object;
            return outlineNode.getChildren();
        }
        return super.getChildrenInternal(object);
    }

    private Object[] getOutlineChildren(IProject iProject) {
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (pHPProjectModel != null) {
            Object[] objectArray = new Object[]{new OutlineNode(1, "classes", pHPProjectModel, this.fPart), new OutlineNode(2, "functions", pHPProjectModel, this.fPart), new OutlineNode(3, "constants", pHPProjectModel, this.fPart)};
            return objectArray;
        }
        return this.getProjectChildren(iProject);
    }

    public boolean hasChildrenInternal(Object object) {
        if (object instanceof IProject) {
            return true;
        }
        if (object instanceof OutlineNode) {
            OutlineNode outlineNode = (OutlineNode)object;
            return outlineNode.hasChildren();
        }
        return super.hasChildrenInternal(object);
    }

    public static int getNodeType(Object object) {
        if (object instanceof OutlineNode) {
            return ((OutlineNode)object).getType();
        }
        return -1;
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        if (this.fPart.isInCurrentProject(pHPFileData)) {
            this.postRefresh(pHPFileData, true);
        }
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    public void dataCleared() {
    }

    private void postRefresh(Object object, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    int n = 0;
                    while (n < ProjectOutlineContentProvider.this.groupNodes.length) {
                        if (ProjectOutlineContentProvider.this.groupNodes[n] instanceof OutlineNode) {
                            OutlineNode outlineNode = (OutlineNode)ProjectOutlineContentProvider.this.groupNodes[n];
                            outlineNode.resetChildren();
                        }
                        ProjectOutlineContentProvider.this.fViewer.refresh(bl);
                        ++n;
                    }
                }
            }
        };
        this.fViewer.getControl().getDisplay().asyncExec(runnable);
    }

    public static class OutlineNode
    implements Comparable {
        String text;
        Object[] children;
        PHPProjectModel model;
        int type;
        ProjectOutlinePart part;

        public OutlineNode(int n, String string, PHPProjectModel pHPProjectModel, ProjectOutlinePart projectOutlinePart) {
            this.type = n;
            this.text = string;
            this.model = pHPProjectModel;
            this.part = projectOutlinePart;
        }

        void loadChildren() {
            switch (this.type) {
                case 1: {
                    if (this.part.isShowAll()) {
                        this.children = this.model.getClasses();
                        break;
                    }
                    this.children = this.model.getPHPUserModel().getClasses();
                    break;
                }
                case 2: {
                    if (this.part.isShowAll()) {
                        this.children = this.model.getFunctions();
                        break;
                    }
                    this.children = this.model.getPHPUserModel().getFunctions();
                    break;
                }
                case 3: {
                    if (this.part.isShowAll()) {
                        this.children = this.model.getConstants();
                        break;
                    }
                    this.children = this.model.getPHPUserModel().getConstants();
                    break;
                }
            }
        }

        public boolean hasChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children.length > 0;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children;
        }

        public String getText() {
            return this.text;
        }

        public int getType() {
            return this.type;
        }

        public void resetChildren() {
            this.children = null;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            if (object instanceof OutlineNode) {
                OutlineNode outlineNode = (OutlineNode)object;
                return this.type - outlineNode.type;
            }
            return 0;
        }
    }
}

