/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.ui.folding.IPHPFoldingPreferenceBlock;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class DefaultPHPFoldingPreferenceBlock
implements IPHPFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            DefaultPHPFoldingPreferenceBlock.this.fOverlayStore.setValue((String)DefaultPHPFoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public DefaultPHPFoldingPreferenceBlock() {
        this.fStore = PreferenceConstants.getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldPHPDoc"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldClasses"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldFunctions"));
        return arrayList.toArray(new OverlayPreferenceStore.OverlayKey[arrayList.size()]);
    }

    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 3;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(PHPUIMessages.DefaultPHPFoldingPreferenceBlock_title);
        this.addCheckBox(composite2, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_classes, "foldClasses", 0);
        this.addCheckBox(composite2, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_functions, "foldFunctions", 0);
        this.addCheckBox(composite2, PHPUIMessages.DefaultPHPFoldingPreferenceBlock_PHPdoc, "foldPHPDoc", 0);
        return composite2;
    }

    private Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = false;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    private void initializeFields() {
        Iterator iterator = this.fCheckBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            Button button = (Button)iterator.next();
            String string = (String)this.fCheckBoxes.get(button);
            button.setSelection(this.fOverlayStore.getBoolean(string));
        }
    }

    public void performOk() {
        this.fOverlayStore.propagate();
    }

    public void initialize() {
        this.initializeFields();
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    public void dispose() {
        this.fOverlayStore.stop();
    }
}

