/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpIni;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.ini4j.Ini;

public class IniModifier {
    static final String PARAM_INCLUDE_PATH = "include_path";
    static final String PATH_SEPARATOR = System.getProperty("os.name").toLowerCase().startsWith("windows") ? ";" : ":";

    public static File addIncludePath(File file, IPath[] iPathArray) {
        File file2;
        block6: {
            file2 = IniModifier.createTempFile();
            if (file2 != null) break block6;
            return null;
        }
        try {
            StringBuffer stringBuffer;
            Ini ini = new Ini();
            ini.load(new FileInputStream(file), Ini.IGNORE_ESCAPE | Ini.STRIP_QUOTES);
            String string = (String)((Ini.Section)ini.get("_")).get(PARAM_INCLUDE_PATH);
            if (string != null) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append(PATH_SEPARATOR);
            } else {
                stringBuffer = new StringBuffer();
            }
            int n = 0;
            while (n < iPathArray.length) {
                stringBuffer.append(iPathArray[n].toOSString()).append(PATH_SEPARATOR);
                ++n;
            }
            stringBuffer.insert(0, "\"");
            stringBuffer.append("\"");
            ((Ini.Section)ini.get("_")).put(PARAM_INCLUDE_PATH, stringBuffer.toString());
            ini.store(new FileOutputStream(file2), Ini.IGNORE_ESCAPE);
            return file2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File addIncludePath(File file, IProject iProject) {
        return IniModifier.addIncludePath(file, IniModifier.projectGetIncludePaths(iProject));
    }

    static File createTempFile() {
        try {
            File file = File.createTempFile("php.", ".ini");
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File findPHPIni(String string) {
        IPath iPath = new Path(string).removeLastSegments(1).append("php.ini");
        File file = new File(iPath.toOSString());
        if (!file.canRead()) {
            return null;
        }
        return file;
    }

    static IPath[] projectGetIncludePaths(IProject iProject) {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
        ArrayList<IPath> arrayList = new ArrayList<IPath>(iIncludePathEntryArray.length);
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            Object object;
            IPath iPath = iIncludePathEntryArray[n].getPath();
            if (iIncludePathEntryArray[n].getEntryKind() == 1) {
                if (iIncludePathEntryArray[n].getContentKind() != 2) {
                    arrayList.add(iPath);
                }
            } else if (iIncludePathEntryArray[n].getEntryKind() == 2) {
                object = iIncludePathEntryArray[n].getResource();
                if (object instanceof IProject) {
                    arrayList.add(object.getLocation());
                }
            } else if (iIncludePathEntryArray[n].getEntryKind() == 4) {
                object = iPath.toString();
                int n2 = ((String)object).indexOf(47);
                String string = "";
                if (n2 != -1) {
                    if (n2 + 1 < ((String)object).length()) {
                        string = ((String)object).substring(n2 + 1);
                    }
                    object = ((String)object).substring(0, n2);
                }
                IPath iPath2 = PHPProjectOptions.getIncludePathVariable((String)object);
                if ((string = (iPath2 = iPath2.append(string)).getFileExtension()) == null || !string.equalsIgnoreCase("zip")) {
                    arrayList.add(iPath2);
                }
            }
            ++n;
        }
        return arrayList.toArray(new IPath[arrayList.size()]);
    }
}

