/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.project.build.FullPhpProjectBuildVisitor;
import org.eclipse.php.core.project.build.PhpResourceDeltaBuildVisitor;

public class PhpIncrementalProjectBuilder
extends IncrementalProjectBuilder {
    public static final int PHP_VERSION_CHANGE_BUILD = 64;

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        this.cleanBuild(iProgressMonitor);
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        if (n == 15) {
            this.cleanBuild(iProgressMonitor);
            return null;
        }
        if (n == 6) {
            this.fullBuild();
            return null;
        }
        IResourceDelta iResourceDelta = this.getDelta(this.getProject());
        if (iResourceDelta == null) {
            return null;
        }
        this.buildDelta(iResourceDelta, iProgressMonitor);
        return null;
    }

    private void fullBuild() {
        try {
            this.getProject().accept((IResourceVisitor)new FullPhpProjectBuildVisitor());
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return;
        }
    }

    private void buildDelta(IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor) throws CoreException {
        iResourceDelta.accept((IResourceDeltaVisitor)new PhpResourceDeltaBuildVisitor(iProgressMonitor));
    }

    private void cleanBuild(IProgressMonitor iProgressMonitor) {
        this.cleanBuild();
    }

    private void cleanBuild(IProject iProject) {
        try {
            if (!iProject.hasNature("org.eclipse.php.core.PHPNature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return;
        }
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (pHPProjectModel != null) {
            pHPProjectModel.clean();
            return;
        }
    }

    private void cleanBuild() {
        this.cleanBuild(this.getProject());
    }
}

