/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.core.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.php.server.core.Logger;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.deploy.DeployFilter;
import org.eclipse.php.server.core.deploy.FileUtil;
import org.eclipse.php.server.core.launch.IHTTPServerLaunch;
import org.eclipse.php.server.core.manager.ServersManager;

public class ServerLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String PHP_IDE_PLUGIN_PREFIX = "org.eclipse.php.";

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.php.server.core", "httpServerLaunchDelegate");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0 || !iConfigurationElementArray[0].getName().equals("launchDelegate")) {
            this.doLaunch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
            return;
        }
        IConfigurationElement iConfigurationElement = null;
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            iConfigurationElement = iConfigurationElementArray[n];
            if (!iConfigurationElementArray[n].getNamespaceIdentifier().startsWith(PHP_IDE_PLUGIN_PREFIX)) break;
            ++n;
        }
        IHTTPServerLaunch iHTTPServerLaunch = (IHTTPServerLaunch)iConfigurationElement.createExecutableExtension("class");
        iHTTPServerLaunch.setHTTPServerDelegate(this);
        iHTTPServerLaunch.launch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
    }

    public void doLaunch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        Server server = ServersManager.getServer(iLaunchConfiguration.getAttribute("name", ""));
        if (server == null) {
            Logger.log(4, "Launch configuration could not find server");
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("file_name", null);
        Path path = new Path(string2);
        IProject iProject = null;
        try {
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        }
        catch (Throwable throwable) {}
        if (iProject == null) {
            Logger.log(4, "Could not launch (Project is null).");
            return;
        }
        boolean bl = iLaunchConfiguration.getAttribute("publish", false);
        if (bl && !FileUtil.publish(server, iProject, iLaunchConfiguration, DeployFilter.getFilterMap(), iProgressMonitor)) {
            return;
        }
    }

    protected void run(IWorkspaceRunnable iWorkspaceRunnable) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null, 0, null);
        }
        catch (CoreException coreException) {
            throw new DebugException(coreException.getStatus());
        }
    }
}

