/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.debugger;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.debugger.DebugMessagesRegistry;
import org.eclipse.php.debug.core.debugger.actions.IDebugAction;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;

public class DebugActionsRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugActions";
    private static final String ACTION_TAG = "action";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String MESSAGE_ATTRIBUTE = "message";
    private Dictionary actions = new Hashtable();
    private static DebugActionsRegistry instance = null;

    private DebugActionsRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (ACTION_TAG.equals(iConfigurationElement.getName())) {
                this.actions.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new DebugActionProxy(iConfigurationElement));
            }
            ++n;
        }
    }

    private static DebugActionsRegistry getInstance() {
        if (instance == null) {
            instance = new DebugActionsRegistry();
        }
        return instance;
    }

    private Dictionary getActions() {
        return this.actions;
    }

    public static IDebugAction getAction(String string) throws Exception {
        return (IDebugAction)DebugActionsRegistry.getInstance().getActions().get(string);
    }

    class DebugActionProxy
    implements IDebugAction {
        IDebugAction action;
        IConfigurationElement element;

        public DebugActionProxy(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IDebugAction createAction() {
            if (this.action == null) {
                Platform.run((ISafeRunnable)new SafeRunnable(this, "Error creation extension for extension-point org.eclipse.php.debug.core.phpDebugActions"){
                    final /* synthetic */ DebugActionProxy this$1;
                    {
                        this.this$1 = debugActionProxy;
                        super(string);
                    }

                    public void run() throws Exception {
                        this.this$1.action = (IDebugAction)this.this$1.element.createExecutableExtension("class");
                    }
                });
            }
            return this.action;
        }

        public IDebugMessage getMessage() {
            IDebugMessage iDebugMessage = this.createAction().getMessage();
            if (iDebugMessage == null) {
                try {
                    iDebugMessage = DebugMessagesRegistry.getMessage(this.element.getAttribute(DebugActionsRegistry.MESSAGE_ATTRIBUTE));
                }
                catch (Exception exception) {
                    Logger.logException("Error retrieving request message for debug action", exception);
                }
            }
            return iDebugMessage;
        }
    }
}

