/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences.phps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.php.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.debug.ui.preferences.phps.ShowPHPsPreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PHPsComboBlock
implements ISelectionProvider {
    PHPexes exes;
    private Combo fCombo;
    private Composite fControl;
    private Button fDefaultButton = null;
    private PHPexeDescriptor fDefaultDescriptor = null;
    private Button fManageButton;
    private ISelection fPrevSelection = new StructuredSelection();
    private final ListenerList fSelectionListeners = new ListenerList();
    private Button fSpecificButton = null;
    private PHPexeDescriptor fSpecificDescriptor = null;
    private String fTitle = null;
    private final List fVMs = new ArrayList();

    public PHPsComboBlock() {
        this.fDefaultDescriptor = new PHPexeDescriptor(){

            public String getDescription() {
                PHPexeItem pHPexeItem = PHPsComboBlock.this.getPHPs(true).getDefaultItem();
                if (pHPexeItem != null) {
                    return String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getPhpEXE().toString() + ")";
                }
                return "no php exes defined";
            }
        };
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.add((Object)iSelectionChangedListener);
    }

    public void createControl(Composite composite) {
        GridData gridData;
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.fControl = composite2;
        composite2.setFont(font);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        if (this.fTitle == null) {
            this.fTitle = PHPDebugUIMessages.PHPexesComboBlock_3;
        }
        group.setText(this.fTitle);
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton = new Button((Composite)group, 16);
            this.fDefaultButton.setText(this.fDefaultDescriptor.getDescription());
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (PHPsComboBlock.this.fDefaultButton.getSelection()) {
                        PHPsComboBlock.this.setUseDefaultPHPexe();
                    }
                }
            });
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.fDefaultButton.setLayoutData((Object)gridData);
            this.fDefaultButton.setFont(font);
        }
        this.fSpecificButton = new Button((Composite)group, 16);
        if (this.fSpecificDescriptor != null) {
            this.fSpecificButton.setText(this.fSpecificDescriptor.getDescription());
        } else {
            this.fSpecificButton.setText(PHPDebugUIMessages.PHPexesComboBlock_1);
        }
        this.fSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PHPsComboBlock.this.fSpecificButton.getSelection()) {
                    PHPsComboBlock.this.fCombo.setEnabled(true);
                    PHPsComboBlock.this.fManageButton.setEnabled(true);
                    if (PHPsComboBlock.this.fCombo.getText().length() == 0 && !PHPsComboBlock.this.fVMs.isEmpty()) {
                        PHPsComboBlock.this.fCombo.select(0);
                    }
                    PHPsComboBlock.this.fireSelectionChanged();
                }
            }
        });
        this.fSpecificButton.setFont(font);
        gridData = new GridData(1);
        this.fSpecificButton.setLayoutData((Object)gridData);
        this.fCombo = new Combo((Composite)group, 12);
        this.fCombo.setFont(font);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fCombo.setLayoutData((Object)gridData);
        ControlAccessibleListener.addListener((Control)this.fCombo, this.fSpecificButton.getText());
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPsComboBlock.this.setPHPexe(PHPsComboBlock.this.getPHPexe());
            }
        });
        this.fManageButton = this.createPushButton((Composite)group, PHPDebugUIMessages.PHPexesComboBlock_2);
        this.fManageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PHPexeItem pHPexeItem = PHPsComboBlock.this.getPHPexe();
                int n = -1;
                if (pHPexeItem != null) {
                    n = PHPsComboBlock.this.fVMs.indexOf(pHPexeItem);
                }
                ShowPHPsPreferences showPHPsPreferences = new ShowPHPsPreferences();
                showPHPsPreferences.run(null);
                PHPsComboBlock.this.fillWithWorkspacePHPexes();
                int n2 = -1;
                if (pHPexeItem != null) {
                    n2 = PHPsComboBlock.this.fVMs.indexOf(pHPexeItem);
                }
                if (n2 != n) {
                    PHPsComboBlock.this.fPrevSelection = null;
                }
                PHPsComboBlock.this.setDefaultPHPexeDescriptor(PHPsComboBlock.this.fDefaultDescriptor);
                if (PHPsComboBlock.this.isDefaultPHPexe()) {
                    PHPsComboBlock.this.setUseDefaultPHPexe();
                } else {
                    if (n2 >= 0) {
                        PHPsComboBlock.this.fCombo.select(n2);
                    } else {
                        PHPsComboBlock.this.fCombo.select(0);
                    }
                    PHPsComboBlock.this.setPHPexe(PHPsComboBlock.this.getPHPexe());
                }
            }
        });
        if (this.getPHPs(true).getDefaultItem() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.PHPsComboBlock_NoPHPsTitle, (String)PHPDebugUIMessages.PHPsComboBlock_noPHPsMessage);
            new ShowPHPsPreferences().run(null);
        }
        this.fillWithWorkspacePHPexes();
    }

    protected Button createPushButton(Composite composite, String string) {
        return SWTUtil.createPushButton((Composite)composite, (String)string, null);
    }

    protected void fillWithWorkspacePHPexes() {
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        PHPexeItem[] pHPexeItemArray = this.getPHPs(true).getItems();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            PHPexeItem pHPexeItem = pHPexeItemArray[n];
            arrayList.add(pHPexeItem);
            ++n;
        }
        this.setPHPexes(arrayList);
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    public PHPexeItem getPHPexe() {
        int n = this.fCombo.getSelectionIndex();
        if (n >= 0) {
            return (PHPexeItem)this.fVMs.get(n);
        }
        return null;
    }

    public PHPexeItem[] getPHPexes() {
        return this.fVMs.toArray(new PHPexeItem[this.fVMs.size()]);
    }

    public PHPexes getPHPs(boolean bl) {
        if (this.exes == null || bl) {
            this.exes = new PHPexes();
            this.exes.load(PHPDebugUIPlugin.getDefault().getPluginPreferences());
        }
        return this.exes;
    }

    public String getSelectedLocation() {
        if (this.fDefaultButton.getSelection()) {
            PHPexeItem pHPexeItem = this.getPHPs(false).getDefaultItem();
            if (pHPexeItem == null) {
                return null;
            }
            return pHPexeItem.getPhpEXE().toString();
        }
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem != null) {
            return pHPexeItem.getPhpEXE().toString();
        }
        return "";
    }

    public ISelection getSelection() {
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)pHPexeItem);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public boolean isDefaultPHPexe() {
        if (this.fDefaultButton != null) {
            return this.fDefaultButton.getSelection();
        }
        return false;
    }

    public void refresh() {
        this.setDefaultPHPexeDescriptor(this.fDefaultDescriptor);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    private void setButtonTextFromDescriptor(Button button, PHPexeDescriptor pHPexeDescriptor) {
        if (button != null) {
            String string = button.getText();
            String string2 = pHPexeDescriptor.getDescription();
            if (!string2.equals(string)) {
                button.setText(string2);
                this.fControl.layout();
            }
        }
    }

    public void setDefaultPHPexeDescriptor(PHPexeDescriptor pHPexeDescriptor) {
        this.fDefaultDescriptor = pHPexeDescriptor;
        this.setButtonTextFromDescriptor(this.fDefaultButton, pHPexeDescriptor);
    }

    public void setPHPexe(PHPexeItem pHPexeItem) {
        if (pHPexeItem == null || pHPexeItem != this.getPHPs(false).getDefaultItem()) {
            this.fSpecificButton.setSelection(true);
            this.fDefaultButton.setSelection(false);
            this.fCombo.setEnabled(true);
            this.fManageButton.setEnabled(true);
            if (pHPexeItem == null) {
                this.setSelection((ISelection)new StructuredSelection());
            } else {
                this.setSelection((ISelection)new StructuredSelection((Object)pHPexeItem));
            }
        } else {
            this.setUseDefaultPHPexe();
        }
    }

    protected void setPHPexes(List list) {
        this.fVMs.clear();
        this.fVMs.addAll(list);
        Collections.sort(this.fVMs, new Comparator(){

            public int compare(Object object, Object object2) {
                PHPexeItem pHPexeItem = (PHPexeItem)object;
                PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
            }

            public boolean equals(Object object) {
                return object == this;
            }
        });
        String[] stringArray = new String[this.fVMs.size()];
        Iterator iterator = this.fVMs.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PHPexeItem pHPexeItem = (PHPexeItem)iterator.next();
            stringArray[n] = String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getPhpEXE().toString() + ")";
            ++n;
        }
        this.fCombo.setItems(stringArray);
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.equals(this.fPrevSelection)) {
            this.fPrevSelection = iSelection;
            if (iSelection.isEmpty()) {
                this.fCombo.setText("");
                this.fCombo.select(-1);
                this.fCombo.setItems(new String[0]);
                this.fillWithWorkspacePHPexes();
            } else {
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                int n = this.fVMs.indexOf(object);
                if (n >= 0) {
                    this.fCombo.select(n);
                }
            }
            this.fireSelectionChanged();
        }
    }

    public void setSpecificPHPexeDescriptor(PHPexeDescriptor pHPexeDescriptor) {
        this.fSpecificDescriptor = pHPexeDescriptor;
        this.setButtonTextFromDescriptor(this.fSpecificButton, pHPexeDescriptor);
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public void setUseDefaultPHPexe() {
        if (this.fDefaultDescriptor != null && this.fControl != null) {
            this.fDefaultButton.setSelection(true);
            this.fSpecificButton.setSelection(false);
            this.fCombo.setEnabled(false);
            this.fManageButton.setEnabled(false);
            this.fPrevSelection = null;
            this.fireSelectionChanged();
        }
    }
}

